use strict;
use vars qw(%PROP %SET %SET_ALIAS $VERSION);
$VERSION=do{my @r=(q$Revision: 1.11 $=~/\d+/g);sprintf "%d."."%02d" x $#r,@r};

$PROP{perl_namespace_name} = 'Char::Class::';
$PROP{module_name} = 'FooScript';

sub header () {
<<"EOH";
## This file is auto-generated (at @{[ sprintf '%04d-%02d-%02dT%02d:%02d:%02dZ', (gmtime)[5]+1900, (gmtime)[4]+1, (gmtime)[3,2,1,0] ]}).
## Do not edit by hand!
use strict;

package $PROP{perl_namespace_name}$PROP{module_name};
our \$VERSION = '$PROP{version}';
@{[
#package main;
]}
use Exporter;
use vars qw(\@EXPORT_OK \@ISA \$VERSION);
\@ISA = qw(Exporter);

=head1 NAME

$PROP{perl_namespace_name}$PROP{module_name} - Regular Expression Character Classes - C<@{[ length $PROP{prefix_name} ? $PROP{prefix_name} : $PROP{module_name} ]}>
@{[$PROP{pod_description}? "
=head1 DESCRIPTION

$PROP{pod_description}":'']}

=cut

sub import (\$;\@) {
  my (\$self, \@sub) = (shift, \@_);
  for (\@sub) {
    no strict 'refs';
    *{'main::'.\$_} = \\&{\$_};
  }
  \$Exporter::ExportLevel = 1;
  \$self->SUPER::import (\@_);
  \$Exporter::ExportLevel = 0;
}

EOH
}

sub table () {
my $prefix = exists $PROP{prefix_name} ? $PROP{prefix_name} : $PROP{module_name};
my $r = '';
my @set;
my %set_description;
for (sort keys %SET) {
  my (@aline,@aitem);
  $SET{$_} =~ s{^#\+(\w+)$}{
    push @aline, qq(\&In${prefix}$1.); ''
  }mge;
  $SET{$_} =~ s{^!(.+)$}{	## Pre-formatted
    push @aitem, $1; ''
  }mge;
  $SET{$_} =~ s{^#DESCRIPTION\x20(.+)$}{
    $set_description{qq(In${prefix}$_)} = $1; ''
  }me;
  $SET{$_} =~ s{^#.+$}{}mg;
  $SET{$_} =~ tr/\x09\x0A\x0D\x20//d;
  push @set, [qq(In${prefix}$_) => 
    join "\n", qq(sub In${prefix}$_ {),
               @aline,
               (length $SET{$_}?
                 (q(<<EOH;),
                 @aitem,
                 (map {sprintf '%04X', $_} sort {$a <=> $b}
                  map {ord $_} split //, $SET{$_}),
                 q(EOH)):
               @aitem > 0? (q(<<EOH;), @aitem, q(EOH)): "''"),
               q(})
  ];
}
for (sort keys %SET_ALIAS) {
  push @set, [qq(In${prefix}$_) => qq(\*In${prefix}$_ = \\&In${prefix}$SET_ALIAS{$_};)];
  $set_description{qq(In${prefix}$_)} = qq<An alias for In${prefix}$SET_ALIAS{$_}.>;
}

$r = qq(\@EXPORT_OK = qw(@{[map {$_->[0]} @set]});\n\n);
$r .= join '', map {$_->[1]."\n\n"} @set;

$r .= "=head1 COLLECTION NAMES\n\n=over 4\n\n";
for (sort {$a->[0] cmp $b->[0]} @set) {
  $r .= sprintf "=item C<%s>\n\n", $_->[0];
  $r .= sprintf "%s\n\n", $set_description{ $_->[0] }
    if $set_description{ $_->[0] };
}
$r .= "=back\n\n=cut\n\n";

$r;
}

sub footer () {
my $r = <<EOH;
@{[$PROP{pod_example}? "
=head1 EXAMPLE

$PROP{pod_example}":"
=head1 EXAMPLE

 use $PROP{perl_namespace_name}$PROP{module_name};
 if (\$s =~ /\\p{In@{[[each %SET]->[0]]}}/) {
   print \"Match!\\n\";
 }
"]}@{[$PROP{pod_see_also}? "
=head1 SEE ALSO

$PROP{pod_see_also}":'']}@{[$PROP{pod_license}? "
=head1 LICENSE

$PROP{pod_license}":"
=head1 LICENSE

Copyright @{[(gmtime)[5]+1900]} $PROP{author_name} <$PROP{author_mail}>

This library and the library generated by it is free software;
you can redistribute them and/or modify them under the same
terms as Perl itself.
"]}
=cut

1;
### $PROP{module_name}.pm ends here
EOH
$r;
}

sub col2list ($) {
  my $s = shift;
  my @s;
  my @c;
  $s =~ s{^(#.+)}{
    push @c, $1; '';
  }gem;
  $s =~ s{^[\x20\x09]*([0-9A-F][0-9A-F])((?:[\x20\x09]+[0-9A-F][0-9A-F](?:-[0-9A-F][0-9A-F])?)+)}{
    my ($r, @c) = ($1, grep {length} split /\s+/, $2);
    for (@c) {
      if (/([0-9A-F][0-9A-F])-([0-9A-F][0-9A-F])/) {
        push @s, sprintf '%s%s	%s%s	', $r,$1, $r,$2;
      } else {
        push @s, sprintf '%s%s', $r,$_;
      }
    }
  }gem;
  join ("\n", @c, map {'!'.$_} @s)."\n";
}

sub print_module () {
  no warnings;
  print &header.&table.&footer;
}

=head1 NAME

mkpm.pl --- Char::Class::* modules generating library

=head1 LICENSE

Copyright 2002-2003 Wakaba <w@suika.fam.cx>

This library and the library generated by it is free software;
you can redistribute them and/or modify them under the same
terms as Perl itself.

=cut

1; ## $Date: 2004/06/04 08:29:56 $
### mkpm.pl ends here
