## This file is auto-generated (at 2007-07-19T12:15:40Z).
## Do not edit by hand!
use strict;

package Char::Class::JISX4052;
our $VERSION = '1.01';

use Exporter;
use vars qw(@EXPORT_OK @ISA $VERSION);
@ISA = qw(Exporter);

=head1 NAME

Char::Class::JISX4052 - Regular Expression Character Classes - C<JISX4052>

=head1 DESCRIPTION

JIS X 4052 character classes represented in UCS,
defined by JIS X 4052 Appendix 1, 2 and 3


=cut

sub import ($;@) {
  my ($self, @sub) = (shift, @_);
  for (@sub) {
    no strict 'refs';
    *{'main::'.$_} = \&{$_};
  }
  $Exporter::ExportLevel = 1;
  $self->SUPER::import (@_);
  $Exporter::ExportLevel = 0;
}

@EXPORT_OK = qw(InJISX4052Alphabetic InJISX4052AlphabeticBasic InJISX4052AlphabeticRecommended InJISX4052Digits InJISX4052KanaCharacter InJISX4052Kenten);

sub InJISX4052Alphabetic {
&InJISX4052AlphabeticBasic.
&InJISX4052AlphabeticRecommended.
''
}

sub InJISX4052AlphabeticBasic {
<<EOH;
0021	007E	
EOH
}

sub InJISX4052AlphabeticRecommended {
<<EOH;
00A1	00FF	
0100
0112
012A
014C
016A
0101
0113
012B
014D
016B
EOH
}

sub InJISX4052Digits {
<<EOH;
002C
002E
0030	0039
EOH
}

sub InJISX4052KanaCharacter {
<<EOH;
3041	3093	
309D	309E	
30A1	30F6	
30FC	30FE	
EOH
}

sub InJISX4052Kenten {
<<EOH;
25EF
25EB
25B2
25B3
25EE
25E9
FE45	FE46	
EOH
}

=head1 COLLECTION NAMES

=over 4

=item C<InJISX4052Alphabetic>

欧文用文字クラス (JIS X 4052:2000 附属書3)

=item C<InJISX4052AlphabeticBasic>

欧文用文字クラス基本文字種 (JIS X 4052:2000 附属書2)

=item C<InJISX4052AlphabeticRecommended>

欧文用文字クラス推奨文字種 (JIS X 4052:2000 附属書3)

=item C<InJISX4052Digits>

連数字クラス (JIS X 4052:2000 附属書4)

=item C<InJISX4052KanaCharacter>

仮名文字クラス (JIS X 4052:2000 附属書1)

=item C<InJISX4052Kenten>

圏点クラス (JIS X 4052:2000 附属書2)

=back

=cut


=head1 EXAMPLE

 use Char::Class::JISX4052;
 if ($s =~ /\p{InKanaCharacter}/) {
   print "Match!\n";
 }

=head1 SEE ALSO

JIS X 4052:2000, 『日本語文書の組版指定交換形式 Exchange format for 
Japanese documents with composition markup』, 日本工業標準調査会 
Japanese Industrial Standard Commitee (JISC <http://www.jisc.go.jp/>), 2000.

=head1 LICENSE

Copyright 2007 わかば Wakaba <w@suika.fam.cx>

This library and the library generated by it is free software;
you can redistribute them and/or modify them under the same
terms as Perl itself.

=cut

1;
### JISX4052.pm ends here
