## This file is auto-generated (at 2007-07-19T12:21:03Z).
## Do not edit by hand!
use strict;

package Char::Class::JISX0221;
our $VERSION = '1.01';

use Exporter;
use vars qw(@EXPORT_OK @ISA $VERSION);
@ISA = qw(Exporter);

=head1 NAME

Char::Class::JISX0221 - Regular Expression Character Classes - C<JISX0221>

=head1 DESCRIPTION

Japanese character sub-repertories, defined by JIS X 0221-1:2001
Appendix 1

Appendix 1 (informative) of JIS X 0221-1:2001 defines seven
Japanese character sub-repertories:

=over 4

=item a) BASIC JAPANESE (基本日本文字集合)

This sub-repertory contains of graphic characters defined by
JIS X 0201, ISO/IEC 646 IRV and JIS X 0208.  Han characters
are defined in main part of ISO/IEC 10646-1 27. (CJK Unified Ideographs)
with source JIS X 0208 code point.  Non-han charactrers
are listed in Appendix 1 table 1.

=item b) JAPANESE NON IDEOGRAPHICS SUPPLEMENT (追加非漢字集合)

This sub-repertory contains of non-Han JIS X 0212 character
and additional symbols used in Japanese documents that
does not included in JIS X 0201, JIS X 0208 and JIS X 0212.
Characters are listed in Appendix 1 table 2.

This sub-repertory is intended to be used with BASIC JAPANESE.

=item c) JAPANESE IDEOGRAPHICS SUPPLEMENT 1 (追加漢字集合)

This sub-repertory contains of Han characters defined by JIS X 0212
and being more frequently used.  Characters are listed in
Appendix 1 table 3.

This sub-repertory is intended to be used with BASIC JAPANESE.

=item d) JAPANESE IDEOGRAPHICS SUPPLEMENT 2 (補助漢字集合)

This sub-repertory contains of Han characters defined by JIS X 0212,
except those included of JAPANESE IDEOGRAPHICS SUPPLEMENT 1.

This sub-repertory is intended to be used with BASIC JAPANESE
and JAPANESE IDEOGRAPHICS SUPPLEMENT 1.

=item e) JAPANESE IDEOGRAPHICS SUPPLEMENT 3 (その他の漢字集合)

Han characters defined in CJK UNIFIED IDEOGRAPHS, except
those included in BASIC JAPANESE and JAPANESE IDEOGRAPHICS SUPPLEMENT
1 and 2.

This sub-repertory is intended to be used with BASIC JAPANESE
and JAPANESE IDEOGRAPHICS SUPPLEMENT 1 and 2.

=item f) FULLWIDTH ALPHANUMERICS (互換用全角英数字集合)

Fullwidth variants of ISO/IEC 646 IRV characters, listed in
Appendix 1 table 4.  This sub-repertory is intended to be used
for and only for keeping compatibility with old idiomatic Japanese
character repertory or presentation form.

This sub-repertory is intended to be used with BASIC JAPANESE
and BASIC LATIN (ISO/IEC 10646-1 Appendix A.1).

=item g) HALFWIDTH KATAKANA (互換用半角片仮名集合)

Halfwidth variants of Katakana characters defined by JIS X 0201,
listed in Appendix 1 table 5.  This sub-repertory is intended to be used
for and only for keeping compatibility with old idiomatic Japanese
character repertory or presentation form.

This sub-repertory is intended to be used with BASIC JAPANESE.

=back

Only a character, TILDE (U+007E) is doubly included in both
BASIC JAPANESE and JAPANESE NON IDEOGRAPHICS SUPPLEMENT.
Any other characters belong to one sub-repertory.



=cut

sub import ($;@) {
  my ($self, @sub) = (shift, @_);
  for (@sub) {
    no strict 'refs';
    *{'main::'.$_} = \&{$_};
  }
  $Exporter::ExportLevel = 1;
  $self->SUPER::import (@_);
  $Exporter::ExportLevel = 0;
}

@EXPORT_OK = qw(InJISX0221BasicJapanese InJISX0221FullwidthAlphanumeric InJISX0221HalfwidthKatakana InJISX0221JapaneseIdeographicsSupplement1 InJISX0221JapaneseIdeographicsSupplement2 InJISX0221JapaneseIdeographicsSupplement3 InJISX0221JapaneseNonIdeographicsSupplement);

sub InJISX0221BasicJapanese {
<<EOH;
0020	007E	
00A2
00A3
00A5
00A7
00A8
00AC
00B0
00B1
00B4
00B6
00D7
00F7
0391	03A1	
03A3	03A9	
03B1	03C1	
03C3	03C9	
0401
0410	044F	
0451
2010
2014
2016
2018
2019
201C
201D
2020
2021
2025
2026
2030
2032
2033
203B
203E
20DD
2103
212B
2190	2193	
21D2
21D4
2200
2202
2203
2207
2208
220B
2212
221A
221D
221E
2220
2227	222C	
2234
2235
223D
2252
2260
2261
2266
2267
226A
226B
2282
2283
2286
2287
22A5
2312
2500	2503	
250C
250F
2510
2513
2514
2517
2518
251B
251C
251D
2520
2534
2537
2538
253B
253C
253F
2542
254B
25A0
25A1
25B2
25B3
25BC
25BD
25C6
25C7
25CB
25CE
25CF
25EF
2605
2606
2640
2642
266A
266D
266F
3000	3003	
3005	3015	
301C
3041	3093	
309B	309E	
30A1	30F6	
30FB	30FE	
4E00
4E01
4E03
4E07
4E08
4E09
4E0A
4E0B
4E0D
4E0E
4E10
4E11
4E14
4E15
4E16
4E17
4E18
4E19
4E1E
4E21
4E26
4E2A
4E2D
4E31
4E32
4E36
4E38
4E39
4E3B
4E3C
4E3F
4E42
4E43
4E45
4E4B
4E4D
4E4E
4E4F
4E55
4E56
4E57
4E58
4E59
4E5D
4E5E
4E5F
4E62
4E71
4E73
4E7E
4E80
4E82
4E85
4E86
4E88
4E89
4E8A
4E8B
4E8C
4E8E
4E91
4E92
4E94
4E95
4E98
4E99
4E9B
4E9C
4E9E
4E9F
4EA0
4EA1
4EA2
4EA4
4EA5
4EA6
4EA8
4EAB
4EAC
4EAD
4EAE
4EB0
4EB3
4EB6
4EBA
4EC0
4EC1
4EC2
4EC4
4EC6
4EC7
4ECA
4ECB
4ECD
4ECE
4ECF
4ED4
4ED5
4ED6
4ED7
4ED8
4ED9
4EDD
4EDE
4EDF
4EE3
4EE4
4EE5
4EED
4EEE
4EF0
4EF2
4EF6
4EF7
4EFB
4F01
4F09
4F0A
4F0D
4F0E
4F0F
4F10
4F11
4F1A
4F1C
4F1D
4F2F
4F30
4F34
4F36
4F38
4F3A
4F3C
4F3D
4F43
4F46
4F47
4F4D
4F4E
4F4F
4F50
4F51
4F53
4F55
4F57
4F59
4F5A
4F5B
4F5C
4F5D
4F5E
4F69
4F6F
4F70
4F73
4F75
4F76
4F7B
4F7C
4F7F
4F83
4F86
4F88
4F8B
4F8D
4F8F
4F91
4F96
4F98
4F9B
4F9D
4FA0
4FA1
4FAB
4FAD
4FAE
4FAF
4FB5
4FB6
4FBF
4FC2
4FC3
4FC4
4FCA
4FCE
4FD0
4FD1
4FD4
4FD7
4FD8
4FDA
4FDB
4FDD
4FDF
4FE1
4FE3
4FE4
4FE5
4FEE
4FEF
4FF3
4FF5
4FF6
4FF8
4FFA
4FFE
5005
5006
5009
500B
500D
500F
5011
5012
5014
5016
5019
501A
501F
5021
5023
5024
5025
5026
5028
5029
502A
502B
502C
502D
5036
5039
5043
5047
5048
5049
504F
5050
5055
5056
505A
505C
5065
506C
5072
5074
5075
5076
5078
507D
5080
5085
508D
5091
5098
5099
509A
50AC
50AD
50B2
50B3
50B4
50B5
50B7
50BE
50C2
50C5
50C9
50CA
50CD
50CF
50D1
50D5
50D6
50DA
50DE
50E3
50E5
50E7
50ED
50EE
50F5
50F9
50FB
5100
5101
5102
5104
5109
5112
5114
5115
5116
5118
511A
511F
5121
512A
5132
5137
513A
513B
513C
513F
5140
5141
5143
5144
5145
5146
5147
5148
5149
514B
514C
514D
514E
5150
5152
5154
515A
515C
5162
5165
5168
5169
516A
516B
516C
516D
516E
5171
5175
5176
5177
5178
517C
5180
5182
5185
5186
5189
518A
518C
518D
518F
5190
5191
5192
5193
5195
5196
5197
5199
51A0
51A2
51A4
51A5
51A6
51A8
51A9
51AA
51AB
51AC
51B0
51B1
51B2
51B3
51B4
51B5
51B6
51B7
51BD
51C4
51C5
51C6
51C9
51CB
51CC
51CD
51D6
51DB
51DC
51DD
51E0
51E1
51E6
51E7
51E9
51EA
51ED
51F0
51F1
51F5
51F6
51F8
51F9
51FA
51FD
51FE
5200
5203
5204
5206
5207
5208
520A
520B
520E
5211
5214
5217
521D
5224
5225
5227
5229
522A
522E
5230
5233
5236
5237
5238
5239
523A
523B
5243
5244
5247
524A
524B
524C
524D
524F
5254
5256
525B
525E
5263
5264
5265
5269
526A
526F
5270
5271
5272
5273
5274
5275
527D
527F
5283
5287
5288
5289
528D
5291
5292
5294
529B
529F
52A0
52A3
52A9
52AA
52AB
52AC
52AD
52B1
52B4
52B5
52B9
52BC
52BE
52C1
52C3
52C5
52C7
52C9
52CD
52D2
52D5
52D7
52D8
52D9
52DD
52DE
52DF
52E0
52E2
52E3
52E4
52E6
52E7
52F2
52F3
52F5
52F8
52F9
52FA
52FE
52FF
5301
5302
5305
5306
5308
530D
530F
5310
5315
5316
5317
5319
531A
531D
5320
5321
5323
532A
532F
5331
5333
5338
5339
533A
533B
533F
5340
5341
5343
5345
5346
5347
5348
5349
534A
534D
5351
5352
5353
5354
5357
5358
535A
535C
535E
5360
5366
5369
536E
536F
5370
5371
5373
5374
5375
5377
5378
537B
537F
5382
5384
5396
5398
539A
539F
53A0
53A5
53A6
53A8
53A9
53AD
53AE
53B0
53B3
53B6
53BB
53C2
53C3
53C8
53C9
53CA
53CB
53CC
53CD
53CE
53D4
53D6
53D7
53D9
53DB
53DF
53E1
53E2
53E3
53E4
53E5
53E8
53E9
53EA
53EB
53EC
53ED
53EE
53EF
53F0
53F1
53F2
53F3
53F6
53F7
53F8
53FA
5401
5403
5404
5408
5409
540A
540B
540C
540D
540E
540F
5410
5411
541B
541D
541F
5420
5426
5429
542B
542C
542D
542E
5436
5438
5439
543B
543C
543D
543E
5440
5442
5446
5448
5449
544A
544E
5451
545F
5468
546A
5470
5471
5473
5475
5476
5477
547B
547C
547D
5480
5484
5486
548B
548C
548E
548F
5490
5492
54A2
54A4
54A5
54A8
54AB
54AC
54AF
54B2
54B3
54B8
54BC
54BD
54BE
54C0
54C1
54C2
54C4
54C7
54C8
54C9
54D8
54E1
54E2
54E5
54E6
54E8
54E9
54ED
54EE
54F2
54FA
54FD
5504
5506
5507
550F
5510
5514
5516
552E
552F
5531
5533
5538
5539
553E
5540
5544
5545
5546
554C
554F
5553
5556
5557
555C
555D
5563
557B
557C
557E
5580
5583
5584
5587
5589
558A
558B
5598
5599
559A
559C
559D
559E
559F
55A7
55A8
55A9
55AA
55AB
55AC
55AE
55B0
55B6
55C4
55C5
55C7
55D4
55DA
55DC
55DF
55E3
55E4
55F7
55F9
55FD
55FE
5606
5609
5614
5616
5617
5618
561B
5629
562F
5631
5632
5634
5636
5638
5642
564C
564E
5650
565B
5664
5668
566A
566B
566C
5674
5678
567A
5680
5686
5687
568A
568F
5694
56A0
56A2
56A5
56AE
56B4
56B6
56BC
56C0
56C1
56C2
56C3
56C8
56CE
56D1
56D3
56D7
56D8
56DA
56DB
56DE
56E0
56E3
56EE
56F0
56F2
56F3
56F9
56FA
56FD
56FF
5700
5703
5704
5708
5709
570B
570D
570F
5712
5713
5716
5718
571C
571F
5726
5727
5728
572D
5730
5737
5738
573B
5740
5742
5747
574A
574E
574F
5750
5751
5761
5764
5766
5769
576A
577F
5782
5788
5789
578B
5793
57A0
57A2
57A3
57A4
57AA
57B0
57B3
57C0
57C3
57C6
57CB
57CE
57D2
57D3
57D4
57D6
57DC
57DF
57E0
57E3
57F4
57F7
57F9
57FA
57FC
5800
5802
5805
5806
580A
580B
5815
5819
581D
5821
5824
582A
582F
5830
5831
5834
5835
583A
583D
5840
5841
584A
584B
5851
5852
5854
5857
5858
5859
585A
585E
5862
5869
586B
5870
5872
5875
5879
587E
5883
5885
5893
5897
589C
589F
58A8
58AB
58AE
58B3
58B8
58B9
58BA
58BB
58BE
58C1
58C5
58C7
58CA
58CC
58D1
58D3
58D5
58D7
58D8
58D9
58DC
58DE
58DF
58E4
58E5
58EB
58EC
58EE
58EF
58F0
58F1
58F2
58F7
58F9
58FA
58FB
58FC
58FD
5902
5909
590A
590F
5910
5915
5916
5918
5919
591A
591B
591C
5922
5925
5927
5929
592A
592B
592C
592D
592E
5931
5932
5937
5938
593E
5944
5947
5948
5949
594E
594F
5950
5951
5954
5955
5957
5958
595A
5960
5962
5965
5967
5968
5969
596A
596C
596E
5973
5974
5978
597D
5981
5982
5983
5984
598A
598D
5993
5996
5999
599B
599D
59A3
59A5
59A8
59AC
59B2
59B9
59BB
59BE
59C6
59C9
59CB
59D0
59D1
59D3
59D4
59D9
59DA
59DC
59E5
59E6
59E8
59EA
59EB
59F6
59FB
59FF
5A01
5A03
5A09
5A11
5A18
5A1A
5A1C
5A1F
5A20
5A25
5A29
5A2F
5A35
5A36
5A3C
5A40
5A41
5A46
5A49
5A5A
5A62
5A66
5A6A
5A6C
5A7F
5A92
5A9A
5A9B
5ABC
5ABD
5ABE
5AC1
5AC2
5AC9
5ACB
5ACC
5AD0
5AD6
5AD7
5AE1
5AE3
5AE6
5AE9
5AFA
5AFB
5B09
5B0B
5B0C
5B16
5B22
5B2A
5B2C
5B30
5B32
5B36
5B3E
5B40
5B43
5B45
5B50
5B51
5B54
5B55
5B57
5B58
5B5A
5B5B
5B5C
5B5D
5B5F
5B63
5B64
5B65
5B66
5B69
5B6B
5B70
5B71
5B73
5B75
5B78
5B7A
5B80
5B83
5B85
5B87
5B88
5B89
5B8B
5B8C
5B8D
5B8F
5B95
5B97
5B98
5B99
5B9A
5B9B
5B9C
5B9D
5B9F
5BA2
5BA3
5BA4
5BA5
5BA6
5BAE
5BB0
5BB3
5BB4
5BB5
5BB6
5BB8
5BB9
5BBF
5BC2
5BC3
5BC4
5BC5
5BC6
5BC7
5BC9
5BCC
5BD0
5BD2
5BD3
5BD4
5BDB
5BDD
5BDE
5BDF
5BE1
5BE2
5BE4
5BE5
5BE6
5BE7
5BE8
5BE9
5BEB
5BEE
5BF0
5BF3
5BF5
5BF6
5BF8
5BFA
5BFE
5BFF
5C01
5C02
5C04
5C05
5C06
5C07
5C08
5C09
5C0A
5C0B
5C0D
5C0E
5C0F
5C11
5C13
5C16
5C1A
5C20
5C22
5C24
5C28
5C2D
5C31
5C38
5C39
5C3A
5C3B
5C3C
5C3D
5C3E
5C3F
5C40
5C41
5C45
5C46
5C48
5C4A
5C4B
5C4D
5C4E
5C4F
5C50
5C51
5C53
5C55
5C5E
5C60
5C61
5C64
5C65
5C6C
5C6E
5C6F
5C71
5C76
5C79
5C8C
5C90
5C91
5C94
5CA1
5CA8
5CA9
5CAB
5CAC
5CB1
5CB3
5CB6
5CB7
5CB8
5CBB
5CBC
5CBE
5CC5
5CC7
5CD9
5CE0
5CE1
5CE8
5CE9
5CEA
5CED
5CEF
5CF0
5CF6
5CFA
5CFB
5CFD
5D07
5D0B
5D0E
5D11
5D14
5D15
5D16
5D17
5D18
5D19
5D1A
5D1B
5D1F
5D22
5D29
5D4B
5D4C
5D4E
5D50
5D52
5D5C
5D69
5D6C
5D6F
5D73
5D76
5D82
5D84
5D87
5D8B
5D8C
5D90
5D9D
5DA2
5DAC
5DAE
5DB7
5DBA
5DBC
5DBD
5DC9
5DCC
5DCD
5DD2
5DD3
5DD6
5DDB
5DDD
5DDE
5DE1
5DE3
5DE5
5DE6
5DE7
5DE8
5DEB
5DEE
5DF1
5DF2
5DF3
5DF4
5DF5
5DF7
5DFB
5DFD
5DFE
5E02
5E03
5E06
5E0B
5E0C
5E11
5E16
5E19
5E1A
5E1B
5E1D
5E25
5E2B
5E2D
5E2F
5E30
5E33
5E36
5E37
5E38
5E3D
5E40
5E43
5E44
5E45
5E47
5E4C
5E4E
5E54
5E55
5E57
5E5F
5E61
5E62
5E63
5E64
5E72
5E73
5E74
5E75
5E76
5E78
5E79
5E7A
5E7B
5E7C
5E7D
5E7E
5E7F
5E81
5E83
5E84
5E87
5E8A
5E8F
5E95
5E96
5E97
5E9A
5E9C
5EA0
5EA6
5EA7
5EAB
5EAD
5EB5
5EB6
5EB7
5EB8
5EC1
5EC2
5EC3
5EC8
5EC9
5ECA
5ECF
5ED0
5ED3
5ED6
5EDA
5EDB
5EDD
5EDF
5EE0
5EE1
5EE2
5EE3
5EE8
5EE9
5EEC
5EF0
5EF1
5EF3
5EF4
5EF6
5EF7
5EF8
5EFA
5EFB
5EFC
5EFE
5EFF
5F01
5F03
5F04
5F09
5F0A
5F0B
5F0C
5F0D
5F0F
5F10
5F11
5F13
5F14
5F15
5F16
5F17
5F18
5F1B
5F1F
5F25
5F26
5F27
5F29
5F2D
5F2F
5F31
5F35
5F37
5F38
5F3C
5F3E
5F41
5F48
5F4A
5F4C
5F4E
5F51
5F53
5F56
5F57
5F59
5F5C
5F5D
5F61
5F62
5F66
5F69
5F6A
5F6B
5F6C
5F6D
5F70
5F71
5F73
5F77
5F79
5F7C
5F7F
5F80
5F81
5F82
5F83
5F84
5F85
5F87
5F88
5F8A
5F8B
5F8C
5F90
5F91
5F92
5F93
5F97
5F98
5F99
5F9E
5FA0
5FA1
5FA8
5FA9
5FAA
5FAD
5FAE
5FB3
5FB4
5FB9
5FBC
5FBD
5FC3
5FC5
5FCC
5FCD
5FD6
5FD7
5FD8
5FD9
5FDC
5FDD
5FE0
5FE4
5FEB
5FF0
5FF1
5FF5
5FF8
5FFB
5FFD
5FFF
600E
600F
6010
6012
6015
6016
6019
601B
601C
601D
6020
6021
6025
6026
6027
6028
6029
602A
602B
602F
6031
603A
6041
6042
6043
6046
604A
604B
604D
6050
6052
6055
6059
605A
605F
6060
6062
6063
6064
6065
6068
6069
606A
606B
606C
606D
606F
6070
6075
6077
6081
6083
6084
6089
608B
608C
608D
6092
6094
6096
6097
609A
609B
609F
60A0
60A3
60A6
60A7
60A9
60AA
60B2
60B3
60B4
60B5
60B6
60B8
60BC
60BD
60C5
60C6
60C7
60D1
60D3
60D8
60DA
60DC
60DF
60E0
60E1
60E3
60E7
60E8
60F0
60F1
60F3
60F4
60F6
60F7
60F9
60FA
60FB
6100
6101
6103
6106
6108
6109
610D
610E
610F
6115
611A
611B
611F
6121
6127
6128
612C
6134
613C
613D
613E
613F
6142
6144
6147
6148
614A
614B
614C
614D
614E
6153
6155
6158
6159
615A
615D
615F
6162
6163
6165
6167
6168
616B
616E
616F
6170
6171
6173
6174
6175
6176
6177
617E
6182
6187
618A
618E
6190
6191
6194
6196
6199
619A
61A4
61A7
61A9
61AB
61AC
61AE
61B2
61B6
61BA
61BE
61C3
61C6
61C7
61C8
61C9
61CA
61CB
61CC
61CD
61D0
61E3
61E6
61F2
61F4
61F6
61F7
61F8
61FA
61FC
61FD
61FE
61FF
6200
6208
6209
620A
620C
620D
620E
6210
6211
6212
6214
6216
621A
621B
621D
621E
621F
6221
6226
622A
622E
622F
6230
6232
6233
6234
6238
623B
623F
6240
6241
6247
6248
6249
624B
624D
624E
6253
6255
6258
625B
625E
6260
6263
6268
626E
6271
6276
6279
627C
627E
627F
6280
6282
6283
6284
6289
628A
6291
6292
6293
6294
6295
6296
6297
6298
629B
629C
629E
62AB
62AC
62B1
62B5
62B9
62BB
62BC
62BD
62C2
62C5
62C6
62C7
62C8
62C9
62CA
62CC
62CD
62CF
62D0
62D1
62D2
62D3
62D4
62D7
62D8
62D9
62DB
62DC
62DD
62E0
62E1
62EC
62ED
62EE
62EF
62F1
62F3
62F5
62F6
62F7
62FE
62FF
6301
6302
6307
6308
6309
630C
6311
6319
631F
6327
6328
632B
632F
633A
633D
633E
633F
6349
634C
634D
634F
6350
6355
6357
635C
6367
6368
6369
636B
636E
6372
6376
6377
637A
637B
6380
6383
6388
6389
638C
638E
638F
6392
6396
6398
639B
639F
63A0
63A1
63A2
63A3
63A5
63A7
63A8
63A9
63AA
63AB
63AC
63B2
63B4
63B5
63BB
63BE
63C0
63C3
63C4
63C6
63C9
63CF
63D0
63D2
63D6
63DA
63DB
63E1
63E3
63E9
63EE
63F4
63F6
63FA
6406
640D
640F
6413
6416
6417
641C
6426
6428
642C
642D
6434
6436
643A
643E
6442
644E
6458
6467
6469
646F
6476
6478
647A
6483
6488
6492
6493
6495
649A
649E
64A4
64A5
64A9
64AB
64AD
64AE
64B0
64B2
64B9
64BB
64BC
64C1
64C2
64C5
64C7
64CD
64D2
64D4
64D8
64DA
64E0
64E1
64E2
64E3
64E6
64E7
64EC
64EF
64F1
64F2
64F4
64F6
64FA
64FD
64FE
6500
6505
6518
651C
651D
6523
6524
652A
652B
652C
652F
6534
6535
6536
6537
6538
6539
653B
653E
653F
6545
6548
654D
654F
6551
6555
6556
6557
6558
6559
655D
655E
6562
6563
6566
656C
6570
6572
6574
6575
6577
6578
6582
6583
6587
6588
6589
658C
658E
6590
6591
6597
6599
659B
659C
659F
65A1
65A4
65A5
65A7
65AB
65AC
65AD
65AF
65B0
65B7
65B9
65BC
65BD
65C1
65C3
65C4
65C5
65C6
65CB
65CC
65CF
65D2
65D7
65D9
65DB
65E0
65E1
65E2
65E5
65E6
65E7
65E8
65E9
65EC
65ED
65F1
65FA
65FB
6602
6603
6606
6607
660A
660C
660E
660F
6613
6614
661C
661F
6620
6625
6627
6628
662D
662F
6634
6635
6636
663C
663F
6641
6642
6643
6644
6649
664B
664F
6652
665D
665E
665F
6662
6664
6666
6667
6668
6669
666E
666F
6670
6674
6676
667A
6681
6683
6684
6687
6688
6689
668E
6691
6696
6697
6698
669D
66A2
66A6
66AB
66AE
66B4
66B8
66B9
66BC
66BE
66C1
66C4
66C7
66C9
66D6
66D9
66DA
66DC
66DD
66E0
66E6
66E9
66F0
66F2
66F3
66F4
66F5
66F7
66F8
66F9
66FC
66FD
66FE
66FF
6700
6703
6708
6709
670B
670D
670F
6714
6715
6716
6717
671B
671D
671E
671F
6726
6727
6728
672A
672B
672C
672D
672E
6731
6734
6736
6737
6738
673A
673D
673F
6741
6746
6749
674E
674F
6750
6751
6753
6756
6759
675C
675E
675F
6760
6761
6762
6763
6764
6765
676A
676D
676F
6770
6771
6772
6773
6775
6777
677C
677E
677F
6785
6787
6789
678B
678C
6790
6795
6797
679A
679C
679D
67A0
67A1
67A2
67A6
67A9
67AF
67B3
67B4
67B6
67B7
67B8
67B9
67C1
67C4
67C6
67CA
67CE
67CF
67D0
67D1
67D3
67D4
67D8
67DA
67DD
67DE
67E2
67E4
67E7
67E9
67EC
67EE
67EF
67F1
67F3
67F4
67F5
67FB
67FE
67FF
6802
6803
6804
6813
6816
6817
681E
6821
6822
6829
682A
682B
6832
6834
6838
6839
683C
683D
6840
6841
6842
6843
6846
6848
684D
684E
6850
6851
6853
6854
6859
685C
685D
685F
6863
6867
6874
6876
6877
687E
687F
6881
6883
6885
688D
688F
6893
6894
6897
689B
689D
689F
68A0
68A2
68A6
68A7
68A8
68AD
68AF
68B0
68B1
68B3
68B5
68B6
68B9
68BA
68BC
68C4
68C6
68C9
68CA
68CB
68CD
68D2
68D4
68D5
68D7
68D8
68DA
68DF
68E0
68E1
68E3
68E7
68EE
68EF
68F2
68F9
68FA
6900
6901
6904
6905
6908
690B
690C
690D
690E
690F
6912
6919
691A
691B
691C
6921
6922
6923
6925
6926
6928
692A
6930
6934
6936
6939
693D
693F
694A
6953
6954
6955
6959
695A
695C
695D
695E
6960
6961
6962
696A
696B
696D
696E
696F
6973
6974
6975
6977
6978
6979
697C
697D
697E
6981
6982
698A
698E
6991
6994
6995
699B
699C
69A0
69A7
69AE
69B1
69B2
69B4
69BB
69BE
69BF
69C1
69C3
69C7
69CA
69CB
69CC
69CD
69CE
69D0
69D3
69D8
69D9
69DD
69DE
69E7
69E8
69EB
69ED
69F2
69F9
69FB
69FD
69FF
6A02
6A05
6A0A
6A0B
6A0C
6A12
6A13
6A14
6A17
6A19
6A1B
6A1E
6A1F
6A21
6A22
6A23
6A29
6A2A
6A2B
6A2E
6A35
6A36
6A38
6A39
6A3A
6A3D
6A44
6A47
6A48
6A4B
6A58
6A59
6A5F
6A61
6A62
6A66
6A72
6A78
6A7F
6A80
6A84
6A8D
6A8E
6A90
6A97
6A9C
6AA0
6AA2
6AA3
6AAA
6AAC
6AAE
6AB3
6AB8
6ABB
6AC1
6AC2
6AC3
6AD1
6AD3
6ADA
6ADB
6ADE
6ADF
6AE8
6AEA
6AFA
6AFB
6B04
6B05
6B0A
6B12
6B16
6B1D
6B1F
6B20
6B21
6B23
6B27
6B32
6B37
6B38
6B39
6B3A
6B3D
6B3E
6B43
6B47
6B49
6B4C
6B4E
6B50
6B53
6B54
6B59
6B5B
6B5F
6B61
6B62
6B63
6B64
6B66
6B69
6B6A
6B6F
6B73
6B74
6B78
6B79
6B7B
6B7F
6B80
6B83
6B84
6B86
6B89
6B8A
6B8B
6B8D
6B95
6B96
6B98
6B9E
6BA4
6BAA
6BAB
6BAF
6BB1
6BB2
6BB3
6BB4
6BB5
6BB7
6BBA
6BBB
6BBC
6BBF
6BC0
6BC5
6BC6
6BCB
6BCD
6BCE
6BD2
6BD3
6BD4
6BD8
6BDB
6BDF
6BEB
6BEC
6BEF
6BF3
6C08
6C0F
6C11
6C13
6C14
6C17
6C1B
6C23
6C24
6C34
6C37
6C38
6C3E
6C40
6C41
6C42
6C4E
6C50
6C55
6C57
6C5A
6C5D
6C5E
6C5F
6C60
6C62
6C68
6C6A
6C70
6C72
6C73
6C7A
6C7D
6C7E
6C81
6C82
6C83
6C88
6C8C
6C8D
6C90
6C92
6C93
6C96
6C99
6C9A
6C9B
6CA1
6CA2
6CAB
6CAE
6CB1
6CB3
6CB8
6CB9
6CBA
6CBB
6CBC
6CBD
6CBE
6CBF
6CC1
6CC4
6CC5
6CC9
6CCA
6CCC
6CD3
6CD5
6CD7
6CD9
6CDB
6CDD
6CE1
6CE2
6CE3
6CE5
6CE8
6CEA
6CEF
6CF0
6CF1
6CF3
6D0B
6D0C
6D12
6D17
6D19
6D1B
6D1E
6D1F
6D25
6D29
6D2A
6D2B
6D32
6D33
6D35
6D36
6D38
6D3B
6D3D
6D3E
6D41
6D44
6D45
6D59
6D5A
6D5C
6D63
6D64
6D66
6D69
6D6A
6D6C
6D6E
6D74
6D77
6D78
6D79
6D85
6D88
6D8C
6D8E
6D93
6D95
6D99
6D9B
6D9C
6DAF
6DB2
6DB5
6DB8
6DBC
6DC0
6DC5
6DC6
6DC7
6DCB
6DCC
6DD1
6DD2
6DD5
6DD8
6DD9
6DDE
6DE1
6DE4
6DE6
6DE8
6DEA
6DEB
6DEC
6DEE
6DF1
6DF3
6DF5
6DF7
6DF9
6DFA
6DFB
6E05
6E07
6E08
6E09
6E0A
6E0B
6E13
6E15
6E19
6E1A
6E1B
6E1D
6E1F
6E20
6E21
6E23
6E24
6E25
6E26
6E29
6E2B
6E2C
6E2D
6E2E
6E2F
6E38
6E3A
6E3E
6E43
6E4A
6E4D
6E4E
6E56
6E58
6E5B
6E5F
6E67
6E6B
6E6E
6E6F
6E72
6E76
6E7E
6E7F
6E80
6E82
6E8C
6E8F
6E90
6E96
6E98
6E9C
6E9D
6E9F
6EA2
6EA5
6EAA
6EAF
6EB2
6EB6
6EB7
6EBA
6EBD
6EC2
6EC4
6EC5
6EC9
6ECB
6ECC
6ED1
6ED3
6ED4
6ED5
6EDD
6EDE
6EEC
6EEF
6EF2
6EF4
6EF7
6EF8
6EFE
6EFF
6F01
6F02
6F06
6F09
6F0F
6F11
6F13
6F14
6F15
6F20
6F22
6F23
6F2B
6F2C
6F31
6F32
6F38
6F3E
6F3F
6F41
6F45
6F54
6F58
6F5B
6F5C
6F5F
6F64
6F66
6F6D
6F6E
6F6F
6F70
6F74
6F78
6F7A
6F7C
6F80
6F81
6F82
6F84
6F86
6F8E
6F91
6F97
6FA1
6FA3
6FA4
6FAA
6FB1
6FB3
6FB9
6FC0
6FC1
6FC2
6FC3
6FC6
6FD4
6FD5
6FD8
6FDB
6FDF
6FE0
6FE1
6FE4
6FEB
6FEC
6FEE
6FEF
6FF1
6FF3
6FF6
6FFA
6FFE
7001
7009
700B
700F
7011
7015
7018
701A
701B
701D
701E
701F
7026
7027
702C
7030
7032
703E
704C
7051
7058
7063
706B
706F
7070
7078
707C
707D
7089
708A
708E
7092
7099
70AC
70AD
70AE
70AF
70B3
70B8
70B9
70BA
70C8
70CB
70CF
70D9
70DD
70DF
70F1
70F9
70FD
7109
7114
7119
711A
711C
7121
7126
7136
713C
7149
714C
714E
7155
7156
7159
7162
7164
7165
7166
7167
7169
716C
716E
717D
7184
7188
718A
718F
7194
7195
7199
719F
71A8
71AC
71B1
71B9
71BE
71C3
71C8
71C9
71CE
71D0
71D2
71D4
71D5
71D7
71DF
71E0
71E5
71E6
71E7
71EC
71ED
71EE
71F5
71F9
71FB
71FC
71FF
7206
720D
7210
721B
7228
722A
722C
722D
7230
7232
7235
7236
723A
723B
723C
723D
723E
723F
7240
7246
7247
7248
724B
724C
7252
7258
7259
725B
725D
725F
7261
7262
7267
7269
7272
7274
7279
727D
727E
7280
7281
7282
7287
7292
7296
72A0
72A2
72A7
72AC
72AF
72B2
72B6
72B9
72C2
72C3
72C4
72C6
72CE
72D0
72D2
72D7
72D9
72DB
72E0
72E1
72E2
72E9
72EC
72ED
72F7
72F8
72F9
72FC
72FD
730A
7316
7317
731B
731C
731D
731F
7325
7329
732A
732B
732E
732F
7334
7336
7337
733E
733F
7344
7345
734E
734F
7357
7363
7368
736A
7370
7372
7375
7378
737A
737B
7384
7387
7389
738B
7396
73A9
73B2
73B3
73BB
73C0
73C2
73C8
73CA
73CD
73CE
73DE
73E0
73E5
73EA
73ED
73EE
73F1
73F8
73FE
7403
7405
7406
7409
7422
7425
7432
7433
7434
7435
7436
743A
743F
7441
7455
7459
745A
745B
745C
745E
745F
7460
7463
7464
7469
746A
746F
7470
7473
7476
747E
7483
748B
749E
74A2
74A7
74B0
74BD
74CA
74CF
74D4
74DC
74E0
74E2
74E3
74E6
74E7
74E9
74EE
74F0
74F1
74F2
74F6
74F7
74F8
7503
7504
7505
750C
750D
750E
7511
7513
7515
7518
751A
751C
751E
751F
7523
7525
7526
7528
752B
752C
7530
7531
7532
7533
7537
7538
753A
753B
753C
7544
7546
7549
754A
754B
754C
754D
754F
7551
7554
7559
755A
755B
755C
755D
7560
7562
7564
7565
7566
7567
7569
756A
756B
756D
7570
7573
7574
7576
7577
7578
757F
7582
7586
7587
7589
758A
758B
758E
758F
7591
7594
759A
759D
75A3
75A5
75AB
75B1
75B2
75B3
75B5
75B8
75B9
75BC
75BD
75BE
75C2
75C3
75C5
75C7
75CA
75CD
75D2
75D4
75D5
75D8
75D9
75DB
75DE
75E2
75E3
75E9
75F0
75F2
75F3
75F4
75FA
75FC
75FE
75FF
7601
7609
760B
760D
761F
7620
7621
7622
7624
7627
7630
7634
763B
7642
7646
7647
7648
764C
7652
7656
7658
765C
7661
7662
7667
7668
7669
766A
766C
7670
7672
7676
7678
767A
767B
767C
767D
767E
7680
7683
7684
7686
7687
7688
768B
768E
7690
7693
7696
7699
769A
76AE
76B0
76B4
76B7
76B8
76B9
76BA
76BF
76C2
76C3
76C6
76C8
76CA
76CD
76D2
76D6
76D7
76DB
76DC
76DE
76DF
76E1
76E3
76E4
76E5
76E7
76EA
76EE
76F2
76F4
76F8
76FB
76FE
7701
7704
7707
7708
7709
770B
770C
771B
771E
771F
7720
7724
7725
7726
7729
7737
7738
773A
773C
7740
7747
775A
775B
7761
7763
7765
7766
7768
776B
7779
777E
777F
778B
778E
7791
779E
77A0
77A5
77AC
77AD
77B0
77B3
77B6
77B9
77BB
77BC
77BD
77BF
77C7
77CD
77D7
77DA
77DB
77DC
77E2
77E3
77E5
77E7
77E9
77ED
77EE
77EF
77F3
77FC
7802
780C
7812
7814
7815
7820
7825
7826
7827
7832
7834
783A
783F
7845
785D
786B
786C
786F
7872
7874
787C
7881
7886
7887
788C
788D
788E
7891
7893
7895
7897
789A
78A3
78A7
78A9
78AA
78AF
78B5
78BA
78BC
78BE
78C1
78C5
78C6
78CA
78CB
78D0
78D1
78D4
78DA
78E7
78E8
78EC
78EF
78F4
78FD
7901
7907
790E
7911
7912
7919
7926
792A
792B
792C
793A
793C
793E
7940
7941
7947
7948
7949
7950
7953
7955
7956
7957
795A
795D
795E
795F
7960
7962
7965
7968
796D
7977
797A
797F
7980
7981
7984
7985
798A
798D
798E
798F
799D
79A6
79A7
79AA
79AE
79B0
79B3
79B9
79BA
79BD
79BE
79BF
79C0
79C1
79C9
79CB
79D1
79D2
79D5
79D8
79DF
79E1
79E3
79E4
79E6
79E7
79E9
79EC
79F0
79FB
7A00
7A08
7A0B
7A0D
7A0E
7A14
7A17
7A18
7A19
7A1A
7A1C
7A1F
7A20
7A2E
7A31
7A32
7A37
7A3B
7A3C
7A3D
7A3E
7A3F
7A40
7A42
7A43
7A46
7A49
7A4D
7A4E
7A4F
7A50
7A57
7A61
7A62
7A63
7A69
7A6B
7A70
7A74
7A76
7A79
7A7A
7A7D
7A7F
7A81
7A83
7A84
7A88
7A92
7A93
7A95
7A96
7A97
7A98
7A9F
7AA9
7AAA
7AAE
7AAF
7AB0
7AB6
7ABA
7ABF
7AC3
7AC4
7AC5
7AC7
7AC8
7ACA
7ACB
7ACD
7ACF
7AD2
7AD3
7AD5
7AD9
7ADA
7ADC
7ADD
7ADF
7AE0
7AE1
7AE2
7AE3
7AE5
7AE6
7AEA
7AED
7AEF
7AF0
7AF6
7AF8
7AF9
7AFA
7AFF
7B02
7B04
7B06
7B08
7B0A
7B0B
7B0F
7B11
7B18
7B19
7B1B
7B1E
7B20
7B25
7B26
7B28
7B2C
7B33
7B35
7B36
7B39
7B45
7B46
7B48
7B49
7B4B
7B4C
7B4D
7B4F
7B50
7B51
7B52
7B54
7B56
7B5D
7B65
7B67
7B6C
7B6E
7B70
7B71
7B74
7B75
7B7A
7B86
7B87
7B8B
7B8D
7B8F
7B92
7B94
7B95
7B97
7B98
7B99
7B9A
7B9C
7B9D
7B9F
7BA1
7BAA
7BAD
7BB1
7BB4
7BB8
7BC0
7BC1
7BC4
7BC6
7BC7
7BC9
7BCB
7BCC
7BCF
7BDD
7BE0
7BE4
7BE5
7BE6
7BE9
7BED
7BF3
7BF6
7BF7
7C00
7C07
7C0D
7C11
7C12
7C13
7C14
7C17
7C1F
7C21
7C23
7C27
7C2A
7C2B
7C37
7C38
7C3D
7C3E
7C3F
7C40
7C43
7C4C
7C4D
7C4F
7C50
7C54
7C56
7C58
7C5F
7C60
7C64
7C65
7C6C
7C73
7C75
7C7E
7C81
7C82
7C83
7C89
7C8B
7C8D
7C90
7C92
7C95
7C97
7C98
7C9B
7C9F
7CA1
7CA2
7CA4
7CA5
7CA7
7CA8
7CAB
7CAD
7CAE
7CB1
7CB2
7CB3
7CB9
7CBD
7CBE
7CC0
7CC2
7CC5
7CCA
7CCE
7CD2
7CD6
7CD8
7CDC
7CDE
7CDF
7CE0
7CE2
7CE7
7CEF
7CF2
7CF4
7CF6
7CF8
7CFA
7CFB
7CFE
7D00
7D02
7D04
7D05
7D06
7D0A
7D0B
7D0D
7D10
7D14
7D15
7D17
7D18
7D19
7D1A
7D1B
7D1C
7D20
7D21
7D22
7D2B
7D2C
7D2E
7D2F
7D30
7D32
7D33
7D35
7D39
7D3A
7D3F
7D42
7D43
7D44
7D45
7D46
7D4B
7D4C
7D4E
7D4F
7D50
7D56
7D5B
7D5E
7D61
7D62
7D63
7D66
7D68
7D6E
7D71
7D72
7D73
7D75
7D76
7D79
7D7D
7D89
7D8F
7D93
7D99
7D9A
7D9B
7D9C
7D9F
7DA2
7DA3
7DAB
7DAC
7DAD
7DAE
7DAF
7DB0
7DB1
7DB2
7DB4
7DB5
7DB8
7DBA
7DBB
7DBD
7DBE
7DBF
7DC7
7DCA
7DCB
7DCF
7DD1
7DD2
7DD5
7DD8
7DDA
7DDC
7DDD
7DDE
7DE0
7DE1
7DE4
7DE8
7DE9
7DEC
7DEF
7DF2
7DF4
7DFB
7E01
7E04
7E05
7E09
7E0A
7E0B
7E12
7E1B
7E1E
7E1F
7E21
7E22
7E23
7E26
7E2B
7E2E
7E31
7E32
7E35
7E37
7E39
7E3A
7E3B
7E3D
7E3E
7E41
7E43
7E46
7E4A
7E4B
7E4D
7E54
7E55
7E56
7E59
7E5A
7E5D
7E5E
7E66
7E67
7E69
7E6A
7E6D
7E70
7E79
7E7B
7E7C
7E7D
7E7F
7E82
7E83
7E88
7E89
7E8C
7E8E
7E8F
7E90
7E92
7E93
7E94
7E96
7E9B
7E9C
7F36
7F38
7F3A
7F45
7F4C
7F4D
7F4E
7F50
7F51
7F54
7F55
7F58
7F5F
7F60
7F67
7F68
7F69
7F6A
7F6B
7F6E
7F70
7F72
7F75
7F77
7F78
7F79
7F82
7F83
7F85
7F86
7F87
7F88
7F8A
7F8C
7F8E
7F94
7F9A
7F9D
7F9E
7FA3
7FA4
7FA8
7FA9
7FAE
7FAF
7FB2
7FB6
7FB8
7FB9
7FBD
7FC1
7FC5
7FC6
7FCA
7FCC
7FD2
7FD4
7FD5
7FE0
7FE1
7FE6
7FE9
7FEB
7FF0
7FF3
7FF9
7FFB
7FFC
8000
8001
8003
8004
8005
8006
800B
800C
8010
8012
8015
8017
8018
8019
801C
8021
8028
8033
8036
803B
803D
803F
8046
804A
8052
8056
8058
805A
805E
805F
8061
8062
8068
806F
8070
8072
8073
8074
8076
8077
8079
807D
807E
807F
8084
8085
8086
8087
8089
808B
808C
8093
8096
8098
809A
809B
809D
80A1
80A2
80A5
80A9
80AA
80AC
80AD
80AF
80B1
80B2
80B4
80BA
80C3
80C4
80C6
80CC
80CE
80D6
80D9
80DA
80DB
80DD
80DE
80E1
80E4
80E5
80EF
80F1
80F4
80F8
80FC
80FD
8102
8105
8106
8107
8108
8109
810A
811A
811B
8123
8129
812F
8131
8133
8139
813E
8146
814B
814E
8150
8151
8153
8154
8155
815F
8165
8166
816B
816E
8170
8171
8174
8178
8179
817A
817F
8180
8182
8183
8188
818A
818F
8193
8195
819A
819C
819D
81A0
81A3
81A4
81A8
81A9
81B0
81B3
81B5
81B8
81BA
81BD
81BE
81BF
81C0
81C2
81C6
81C8
81C9
81CD
81D1
81D3
81D8
81D9
81DA
81DF
81E0
81E3
81E5
81E7
81E8
81EA
81ED
81F3
81F4
81FA
81FB
81FC
81FE
8201
8202
8205
8207
8208
8209
820A
820C
820D
820E
8210
8212
8216
8217
8218
821B
821C
821E
821F
8229
822A
822B
822C
822E
8233
8235
8236
8237
8238
8239
8240
8247
8258
8259
825A
825D
825F
8262
8264
8266
8268
826A
826B
826E
826F
8271
8272
8276
8277
8278
827E
828B
828D
8292
8299
829D
829F
82A5
82A6
82AB
82AC
82AD
82AF
82B1
82B3
82B8
82B9
82BB
82BD
82C5
82D1
82D2
82D3
82D4
82D7
82D9
82DB
82DC
82DE
82DF
82E1
82E3
82E5
82E6
82E7
82EB
82F1
82F3
82F4
82F9
82FA
82FB
8302
8303
8304
8305
8306
8309
830E
8316
8317
8318
831C
8323
8328
832B
832F
8331
8332
8334
8335
8336
8338
8339
8340
8345
8349
834A
834F
8350
8352
8358
8373
8375
8377
837B
837C
8385
8387
8389
838A
838E
8393
8396
839A
839E
839F
83A0
83A2
83A8
83AA
83AB
83B1
83B5
83BD
83C1
83C5
83CA
83CC
83CE
83D3
83D6
83D8
83DC
83DF
83E0
83E9
83EB
83EF
83F0
83F1
83F2
83F4
83F7
83FB
83FD
8403
8404
8407
840B
840C
840D
840E
8413
8420
8422
8429
842A
842C
8431
8435
8438
843C
843D
8446
8449
844E
8457
845B
8461
8462
8463
8466
8469
846B
846C
846D
846E
846F
8471
8475
8477
8479
847A
8482
8484
848B
8490
8494
8499
849C
849F
84A1
84AD
84B2
84B8
84B9
84BB
84BC
84BF
84C1
84C4
84C6
84C9
84CA
84CB
84CD
84D0
84D1
84D6
84D9
84DA
84EC
84EE
84F4
84FC
84FF
8500
8506
8511
8513
8514
8515
8517
8518
851A
851F
8521
8526
852C
852D
8535
853D
8540
8541
8543
8548
8549
854A
854B
854E
8555
8557
8558
855A
8563
8568
8569
856A
856D
8577
857E
8580
8584
8587
8588
858A
8590
8591
8594
8597
8599
859B
859C
85A4
85A6
85A8
85A9
85AA
85AB
85AC
85AE
85AF
85B9
85BA
85C1
85C9
85CD
85CF
85D0
85D5
85DC
85DD
85E4
85E5
85E9
85EA
85F7
85F9
85FA
85FB
85FE
8602
8606
8607
860A
860B
8613
8616
8617
861A
8622
862D
862F
8630
863F
864D
864E
8650
8654
8655
865A
865C
865E
865F
8667
866B
8671
8679
867B
868A
868B
868C
8693
8695
86A3
86A4
86A9
86AA
86AB
86AF
86B0
86B6
86C4
86C6
86C7
86C9
86CB
86CD
86CE
86D4
86D9
86DB
86DE
86DF
86E4
86E9
86EC
86ED
86EE
86EF
86F8
86F9
86FB
86FE
8700
8702
8703
8706
8708
8709
870A
870D
8711
8712
8718
871A
871C
8725
8729
8734
8737
873B
873F
8749
874B
874C
874E
8753
8755
8757
8759
875F
8760
8763
8766
8768
876A
876E
8774
8776
8778
877F
8782
878D
879F
87A2
87AB
87AF
87B3
87BA
87BB
87BD
87C0
87C4
87C6
87C7
87CB
87D0
87D2
87E0
87EF
87F2
87F6
87F7
87F9
87FB
87FE
8805
880D
880E
880F
8811
8815
8816
8821
8822
8823
8827
8831
8836
8839
883B
8840
8842
8844
8846
884C
884D
8852
8853
8857
8859
885B
885D
885E
8861
8862
8863
8868
886B
8870
8872
8875
8877
887D
887E
887F
8881
8882
8888
888B
888D
8892
8896
8897
8899
889E
88A2
88A4
88AB
88AE
88B0
88B1
88B4
88B5
88B7
88BF
88C1
88C2
88C3
88C4
88C5
88CF
88D4
88D5
88D8
88D9
88DC
88DD
88DF
88E1
88E8
88F2
88F3
88F4
88F8
88F9
88FC
88FD
88FE
8902
8904
8907
890A
890C
8910
8912
8913
891D
891E
8925
892A
892B
8936
8938
893B
8941
8943
8944
894C
894D
8956
895E
895F
8960
8964
8966
896A
896D
896F
8972
8974
8977
897E
897F
8981
8983
8986
8987
8988
898A
898B
898F
8993
8996
8997
8998
899A
89A1
89A6
89A7
89A9
89AA
89AC
89AF
89B2
89B3
89BA
89BD
89BF
89C0
89D2
89DA
89DC
89DD
89E3
89E6
89E7
89F4
89F8
8A00
8A02
8A03
8A08
8A0A
8A0C
8A0E
8A10
8A13
8A16
8A17
8A18
8A1B
8A1D
8A1F
8A23
8A25
8A2A
8A2D
8A31
8A33
8A34
8A36
8A3A
8A3B
8A3C
8A41
8A46
8A48
8A50
8A51
8A52
8A54
8A55
8A5B
8A5E
8A60
8A62
8A63
8A66
8A69
8A6B
8A6C
8A6D
8A6E
8A70
8A71
8A72
8A73
8A7C
8A82
8A84
8A85
8A87
8A89
8A8C
8A8D
8A91
8A93
8A95
8A98
8A9A
8A9E
8AA0
8AA1
8AA3
8AA4
8AA5
8AA6
8AA8
8AAC
8AAD
8AB0
8AB2
8AB9
8ABC
8ABF
8AC2
8AC4
8AC7
8ACB
8ACC
8ACD
8ACF
8AD2
8AD6
8ADA
8ADB
8ADC
8ADE
8AE0
8AE1
8AE2
8AE4
8AE6
8AE7
8AEB
8AED
8AEE
8AF1
8AF3
8AF7
8AF8
8AFA
8AFE
8B00
8B01
8B02
8B04
8B07
8B0C
8B0E
8B10
8B14
8B16
8B17
8B19
8B1A
8B1B
8B1D
8B20
8B21
8B26
8B28
8B2B
8B2C
8B33
8B39
8B3E
8B41
8B49
8B4C
8B4E
8B4F
8B56
8B58
8B5A
8B5B
8B5C
8B5F
8B66
8B6B
8B6C
8B6F
8B70
8B71
8B72
8B74
8B77
8B7D
8B80
8B83
8B8A
8B8C
8B8E
8B90
8B92
8B93
8B96
8B99
8B9A
8C37
8C3A
8C3F
8C41
8C46
8C48
8C4A
8C4C
8C4E
8C50
8C55
8C5A
8C61
8C62
8C6A
8C6B
8C6C
8C78
8C79
8C7A
8C7C
8C82
8C85
8C89
8C8A
8C8C
8C8D
8C8E
8C94
8C98
8C9D
8C9E
8CA0
8CA1
8CA2
8CA7
8CA8
8CA9
8CAA
8CAB
8CAC
8CAD
8CAE
8CAF
8CB0
8CB2
8CB3
8CB4
8CB6
8CB7
8CB8
8CBB
8CBC
8CBD
8CBF
8CC0
8CC1
8CC2
8CC3
8CC4
8CC7
8CC8
8CCA
8CCD
8CCE
8CD1
8CD3
8CDA
8CDB
8CDC
8CDE
8CE0
8CE2
8CE3
8CE4
8CE6
8CEA
8CED
8CFA
8CFB
8CFC
8CFD
8D04
8D05
8D07
8D08
8D0A
8D0B
8D0D
8D0F
8D10
8D13
8D14
8D16
8D64
8D66
8D67
8D6B
8D6D
8D70
8D71
8D73
8D74
8D77
8D81
8D85
8D8A
8D99
8DA3
8DA8
8DB3
8DBA
8DBE
8DC2
8DCB
8DCC
8DCF
8DD6
8DDA
8DDB
8DDD
8DDF
8DE1
8DE3
8DE8
8DEA
8DEB
8DEF
8DF3
8DF5
8DFC
8DFF
8E08
8E09
8E0A
8E0F
8E10
8E1D
8E1E
8E1F
8E2A
8E30
8E34
8E35
8E42
8E44
8E47
8E48
8E49
8E4A
8E4C
8E50
8E55
8E59
8E5F
8E60
8E63
8E64
8E72
8E74
8E76
8E7C
8E81
8E84
8E85
8E87
8E8A
8E8B
8E8D
8E91
8E93
8E94
8E99
8EA1
8EAA
8EAB
8EAC
8EAF
8EB0
8EB1
8EBE
8EC5
8EC6
8EC8
8ECA
8ECB
8ECC
8ECD
8ED2
8EDB
8EDF
8EE2
8EE3
8EEB
8EF8
8EFB
8EFC
8EFD
8EFE
8F03
8F05
8F09
8F0A
8F0C
8F12
8F13
8F14
8F15
8F19
8F1B
8F1C
8F1D
8F1F
8F26
8F29
8F2A
8F2F
8F33
8F38
8F39
8F3B
8F3E
8F3F
8F42
8F44
8F45
8F46
8F49
8F4C
8F4D
8F4E
8F57
8F5C
8F5F
8F61
8F62
8F63
8F64
8F9B
8F9C
8F9E
8F9F
8FA3
8FA7
8FA8
8FAD
8FAE
8FAF
8FB0
8FB1
8FB2
8FB7
8FBA
8FBB
8FBC
8FBF
8FC2
8FC4
8FC5
8FCE
8FD1
8FD4
8FDA
8FE2
8FE5
8FE6
8FE9
8FEA
8FEB
8FED
8FEF
8FF0
8FF4
8FF7
8FF8
8FF9
8FFA
8FFD
9000
9001
9003
9005
9006
900B
900D
900E
900F
9010
9011
9013
9014
9015
9016
9017
9019
901A
901D
901E
901F
9020
9021
9022
9023
9027
902E
9031
9032
9035
9036
9038
9039
903C
903E
9041
9042
9045
9047
9049
904A
904B
904D
904E
904F
9050
9051
9052
9053
9054
9055
9056
9058
9059
905C
905E
9060
9061
9063
9065
9068
9069
906D
906E
906F
9072
9075
9076
9077
9078
907A
907C
907D
907F
9080
9081
9082
9083
9084
9087
9089
908A
908F
9091
90A3
90A6
90A8
90AA
90AF
90B1
90B5
90B8
90C1
90CA
90CE
90DB
90E1
90E2
90E4
90E8
90ED
90F5
90F7
90FD
9102
9112
9119
912D
9130
9132
9149
914A
914B
914C
914D
914E
9152
9154
9156
9158
9162
9163
9165
9169
916A
916C
9172
9173
9175
9177
9178
9182
9187
9189
918B
918D
9190
9192
9197
919C
91A2
91A4
91AA
91AB
91AF
91B4
91B5
91B8
91BA
91C0
91C1
91C6
91C7
91C8
91C9
91CB
91CC
91CD
91CE
91CF
91D0
91D1
91D6
91D8
91DB
91DC
91DD
91DF
91E1
91E3
91E6
91E7
91F5
91F6
91FC
91FF
920D
920E
9211
9214
9215
921E
9229
922C
9234
9237
923F
9244
9245
9248
9249
924B
9250
9257
925A
925B
925E
9262
9264
9266
9271
927E
9280
9283
9285
9291
9293
9295
9296
9298
929A
929B
929C
92AD
92B7
92B9
92CF
92D2
92E4
92E9
92EA
92ED
92F2
92F3
92F8
92FA
92FC
9306
930F
9310
9318
9319
931A
9320
9322
9323
9326
9328
932B
932C
932E
932F
9332
9335
933A
933B
9344
934B
934D
9354
9356
935B
935C
9360
936C
936E
9375
937C
937E
938C
9394
9396
9397
939A
93A7
93AC
93AD
93AE
93B0
93B9
93C3
93C8
93D0
93D1
93D6
93D7
93D8
93DD
93E1
93E4
93E5
93E8
9403
9407
9410
9413
9414
9418
9419
941A
9421
942B
9435
9436
9438
943A
9441
9444
9451
9452
9453
945A
945B
945E
9460
9462
946A
9470
9475
9477
947C
947D
947E
947F
9481
9577
9580
9582
9583
9587
9589
958A
958B
958F
9591
9593
9594
9596
9598
9599
95A0
95A2
95A3
95A4
95A5
95A7
95A8
95AD
95B2
95B9
95BB
95BC
95BE
95C3
95C7
95CA
95CC
95CD
95D4
95D5
95D6
95D8
95DC
95E1
95E2
95E5
961C
9621
9628
962A
962E
962F
9632
963B
963F
9640
9642
9644
964B
964C
964D
964F
9650
965B
965C
965D
965E
965F
9662
9663
9664
9665
9666
966A
966C
9670
9672
9673
9675
9676
9677
9678
967A
967D
9685
9686
9688
968A
968B
968D
968E
968F
9694
9695
9697
9698
9699
969B
969C
96A0
96A3
96A7
96A8
96AA
96B0
96B1
96B2
96B4
96B6
96B7
96B8
96B9
96BB
96BC
96C0
96C1
96C4
96C5
96C6
96C7
96C9
96CB
96CC
96CD
96CE
96D1
96D5
96D6
96D9
96DB
96DC
96E2
96E3
96E8
96EA
96EB
96F0
96F2
96F6
96F7
96F9
96FB
9700
9704
9706
9707
9708
970A
970D
970E
970F
9711
9713
9716
9719
971C
971E
9724
9727
972A
9730
9732
9738
9739
973D
973E
9742
9744
9746
9748
9749
9752
9756
9759
975C
975E
9760
9761
9762
9764
9766
9768
9769
976B
976D
9771
9774
9779
977A
977C
9781
9784
9785
9786
978B
978D
978F
9790
9798
979C
97A0
97A3
97A6
97A8
97AB
97AD
97B3
97B4
97C3
97C6
97C8
97CB
97D3
97DC
97ED
97EE
97F2
97F3
97F5
97F6
97FB
97FF
9801
9802
9803
9805
9806
9808
980C
980F
9810
9811
9812
9813
9817
9818
981A
9821
9824
982C
982D
9834
9837
9838
983B
983C
983D
9846
984B
984C
984D
984E
984F
9854
9855
9858
985B
985E
9867
986B
986F
9870
9871
9873
9874
98A8
98AA
98AF
98B1
98B6
98C3
98C4
98C6
98DB
98DC
98DF
98E2
98E9
98EB
98ED
98EE
98EF
98F2
98F4
98FC
98FD
98FE
9903
9905
9909
990A
990C
9910
9912
9913
9914
9918
991D
991E
9920
9921
9924
9928
992C
992E
993D
993E
9942
9945
9949
994B
994C
9950
9951
9952
9955
9957
9996
9997
9998
9999
99A5
99A8
99AC
99AD
99AE
99B3
99B4
99BC
99C1
99C4
99C5
99C6
99C8
99D0
99D1
99D2
99D5
99D8
99DB
99DD
99DF
99E2
99ED
99EE
99F1
99F2
99F8
99FB
99FF
9A01
9A05
9A0E
9A0F
9A12
9A13
9A19
9A28
9A2B
9A30
9A37
9A3E
9A40
9A42
9A43
9A45
9A4D
9A55
9A57
9A5A
9A5B
9A5F
9A62
9A64
9A65
9A69
9A6A
9A6B
9AA8
9AAD
9AB0
9AB8
9ABC
9AC0
9AC4
9ACF
9AD1
9AD3
9AD4
9AD8
9ADE
9ADF
9AE2
9AE3
9AE6
9AEA
9AEB
9AED
9AEE
9AEF
9AF1
9AF4
9AF7
9AFB
9B06
9B18
9B1A
9B1F
9B22
9B23
9B25
9B27
9B28
9B29
9B2A
9B2E
9B2F
9B31
9B32
9B3B
9B3C
9B41
9B42
9B43
9B44
9B45
9B4D
9B4E
9B4F
9B51
9B54
9B58
9B5A
9B6F
9B74
9B83
9B8E
9B91
9B92
9B93
9B96
9B97
9B9F
9BA0
9BA8
9BAA
9BAB
9BAD
9BAE
9BB4
9BB9
9BC0
9BC6
9BC9
9BCA
9BCF
9BD1
9BD2
9BD4
9BD6
9BDB
9BE1
9BE2
9BE3
9BE4
9BE8
9BF0
9BF1
9BF2
9BF5
9C04
9C06
9C08
9C09
9C0A
9C0C
9C0D
9C10
9C12
9C13
9C14
9C15
9C1B
9C21
9C24
9C25
9C2D
9C2E
9C2F
9C30
9C32
9C39
9C3A
9C3B
9C3E
9C46
9C47
9C48
9C52
9C57
9C5A
9C60
9C67
9C76
9C78
9CE5
9CE7
9CE9
9CEB
9CEC
9CF0
9CF3
9CF4
9CF6
9D03
9D06
9D07
9D08
9D09
9D0E
9D12
9D15
9D1B
9D1F
9D23
9D26
9D28
9D2A
9D2B
9D2C
9D3B
9D3E
9D3F
9D41
9D44
9D46
9D48
9D50
9D51
9D59
9D5C
9D5D
9D5E
9D60
9D61
9D64
9D6C
9D6F
9D72
9D7A
9D87
9D89
9D8F
9D9A
9DA4
9DA9
9DAB
9DAF
9DB2
9DB4
9DB8
9DBA
9DBB
9DC1
9DC2
9DC4
9DC6
9DCF
9DD3
9DD9
9DE6
9DED
9DEF
9DF2
9DF8
9DF9
9DFA
9DFD
9E1A
9E1B
9E1E
9E75
9E78
9E79
9E7D
9E7F
9E81
9E88
9E8B
9E8C
9E91
9E92
9E93
9E95
9E97
9E9D
9E9F
9EA5
9EA6
9EA9
9EAA
9EAD
9EB8
9EB9
9EBA
9EBB
9EBC
9EBE
9EBF
9EC4
9ECC
9ECD
9ECE
9ECF
9ED0
9ED2
9ED4
9ED8
9ED9
9EDB
9EDC
9EDD
9EDE
9EE0
9EE5
9EE8
9EEF
9EF4
9EF6
9EF7
9EF9
9EFB
9EFC
9EFD
9F07
9F08
9F0E
9F13
9F15
9F20
9F21
9F2C
9F3B
9F3E
9F4A
9F4B
9F4E
9F4F
9F52
9F54
9F5F
9F60
9F61
9F62
9F63
9F66
9F67
9F6A
9F6C
9F72
9F76
9F77
9F8D
9F95
9F9C
9F9D
9FA0
EOH
}

sub InJISX0221FullwidthAlphanumeric {
<<EOH;
FF01	FF5E	
EOH
}

sub InJISX0221HalfwidthKatakana {
<<EOH;
FF61	FF9F	
EOH
}

sub InJISX0221JapaneseIdeographicsSupplement1 {
<<EOH;
4E1F
4E28
4E2B
4E2F
4E44
4E7F
4E8D
4EB9
4EFF
4F03
4F0B
4F15
4F3B
4F49
4F54
4F60
4F7A
4F7D
4F7E
4F8A
4F97
4FBE
4FC9
4FCF
4FE0
4FFD
5001
5010
501B
501E
5027
502E
503B
5066
506A
5094
5096
50E9
5108
510B
511B
511E
51A1
5201
5202
5213
5215
5249
5251
5266
5293
52A6
52DB
52F0
530A
530B
533E
5361
536C
5393
53AB
53DA
53F5
5427
544D
5456
545B
5474
548D
549C
54A9
54AD
54B9
54BF
54C6
550E
552B
5535
555E
5586
5588
558E
560E
560F
5637
563F
5649
564B
564F
5666
5669
566F
5671
5672
5695
5699
569A
56AC
56AD
56B1
56C9
56CA
56DD
5723
572F
5770
579C
57AC
57B8
57E6
57ED
57F5
57F6
57FF
5820
5832
5861
587C
5880
58A9
58CE
590C
592F
595B
595D
5961
596D
59D2
59DD
59E3
5A0C
5A47
5A55
5A63
5A6D
5A7E
5A9E
5AA7
5AB3
5AE0
5B00
5B19
5B25
5B2D
5B41
5B7C
5B7F
5BC0
5C23
5C2B
5C30
5C62
5C63
5C69
5CBA
5CCB
5CD2
5CF4
5D24
5D26
5D27
5D43
5D46
5D4A
5D92
5D94
5D99
5DA0
5DB8
5DD8
5DE0
5E12
5E14
5E18
5E6C
5EAA
5EBE
5EBF
5ED2
5F07
5F0E
5F1C
5F1D
5F22
5F28
5F36
5F40
5F45
5F50
5F58
5F67
5FA7
5FAF
5FB8
5FC4
5FC9
5FE1
5FE9
5FED
6033
6061
607F
608A
60B0
60D5
60DB
60F8
6113
6114
6130
6137
618D
61A8
61C2
6215
6229
6243
6246
624C
6256
62C4
630A
630D
6339
6342
6343
6365
6374
637D
6384
6387
6390
639E
63F5
6409
6410
6414
6422
6451
645B
6460
646D
647B
649D
64BF
64E5
64F7
64FB
6504
6516
6519
6522
6585
65C2
65F0
6609
6615
661E
662C
6631
664C
6659
665C
6661
666B
6673
66A4
66B2
66EC
66FB
6748
674C
6766
6776
677B
67B0
67B2
67BB
67F0
67F9
682C
6830
685B
6872
6875
687A
68B2
68D0
68D6
68E8
68ED
68F0
68F1
68FC
6913
6957
6963
6968
6972
697F
6980
69A6
69AD
69B7
6A01
6A0F
6A15
6A28
6A34
6A3E
6A50
6A51
6A56
6A5B
6A7E
6A83
6A89
6A9D
6A9E
6A9F
6ADC
6AE4
6AE7
8B1E
8B35
8B46
8B56
8B60
8BD6
8BF1
6C10
6C33
6C35
6C3A
6C59
6C76
6C85
6C86
6C95
6C9C
6CD0
6CD4
6CD6
6CEB
6CEE
6D04
6D0E
6D11
6D2E
6D5E
6D65
6D82
6D87
6DBF
6DC4
6DD6
6DE9
6E22
6E51
6E5C
6ECE
6F1A
6F2A
6F51
6F5A
7039
703C
704A
7054
705D
705E
706C
707E
7081
7085
70AB
70B7
70D8
70DC
7120
7130
7131
7147
715C
7160
71C1
721D
722B
7238
7241
7253
7255
7256
728D
72AD
72B4
72FB
7328
7331
7343
736C
737C
7383
7386
7395
739E
739F
73A0
73A6
73AB
73B5
73B7
73BC
73C9
73CF
73D6
73E3
73E9
73F5
73FD
7407
740A
741A
741B
7426
7428
742A
742C
742E
742F
7430
7431
7439
7444
744D
7451
7457
746B
7471
7480
7485
7486
7487
7489
7498
749C
749F
74A0
74A3
74A8
74AB
74B5
74BF
74C8
74DA
74DE
754E
756F
7579
7590
7592
7593
75F9
7600
760A
7615
761E
7626
7635
7643
764B
766D
766F
7671
7674
769B
76A4
76A6
76C5
76CC
76EC
7734
7736
775F
7760
777D
7795
77AA
77F0
77F4
7806
7821
7822
782D
782E
7835
7868
789E
78C8
78CC
78CE
78E4
78F2
78F7
78FB
7931
793D
7945
795B
795C
7994
7996
7998
79B1
79B8
79CA
7A11
7A2D
7A39
7A4C
7A5D
7A6D
7A78
7AA0
7AA3
7AB3
7ABB
7AD1
7AEB
7B07
7B14
7B27
7B31
7B47
7B4B
7B60
7B6D
7B72
7B91
7BAF
7BD7
7BD9
7C0B
7C0F
7C20
7C26
7C36
7C51
7C59
7C67
7C6E
7C70
7CBC
7CBF
7CC8
7CC9
7CD7
7CDD
7CEB
7D07
7D08
7D09
7D1D
7D23
7D41
7D53
7D59
7D5C
7D7A
7D86
7D8C
7DB7
7DCC
7DEB
7DF1
7E11
7E20
7E47
7E61
7E62
7E6B
7E6E
7E73
7E8A
7E91
7E98
7F44
7F47
7F4F
7F52
7F53
7F61
7F91
7FBF
7FCE
7FDF
7FE5
7FEC
7FEE
7FEF
7FFA
800E
8011
8014
8024
803C
8071
8075
80AB
80D7
80D8
814A
814C
8181
8184
81B4
81CF
8203
8221
8232
824B
82B7
82FE
8343
8351
8386
8392
8398
83A9
83C0
83EA
840A
840F
8411
844A
8476
84A8
84C0
84C2
84DC
84FD
850C
8523
858F
85B7
85CE
8629
866C
867A
868D
8691
8698
86A7
86A8
86FA
870B
871E
8728
873E
8771
8788
8799
87AC
87AD
87B5
87D6
87EB
87ED
8803
8806
8814
881C
881F
8856
885F
8864
8898
88BD
88BE
88CA
88D2
88DB
88F0
88F1
8918
8919
8927
8930
893E
897B
89D4
89D6
89E5
89F1
8A07
8A12
8A15
8A22
8A79
8ABE
8ADF
8AF4
8AF6
8B1F
8B43
8B54
8B9C
8B9E
8C47
8C54
8C73
8CA4
8CE1
8CFE
8D1B
8D69
8D6C
8D8D
8D95
8DC6
8DCE
8DEC
8E4B
8E6C
8E7A
8E92
8EAE
8EC0
8ECF
8ED4
8EF9
8F17
8F36
8FB5
8FB6
8FE0
8FE4
9002
9044
9088
9095
9099
909B
90A2
90B4
90DD
9127
913D
9148
9161
9164
918E
919E
91A8
91AC
91AD
91AE
91B1
91BC
91E5
91ED
9206
9207
9210
9238
9247
924F
9278
9288
92C2
92CC
92D7
92DF
92E0
930D
931E
9321
9327
9352
9365
936A
936D
939B
93A9
93BA
93C1
93CA
93DE
93E2
93FD
940F
9434
9455
946B
9472
94A6
94AB
94DA
961D
9641
9684
969D
96A9
96D2
96DE
96E9
96F1
9702
9709
975A
976E
9773
979A
97A2
97B6
97D9
97DE
97F4
980A
980E
981E
982B
9830
9852
9853
9857
985A
9865
986C
98B8
98BA
98BF
98E5
9932
9933
9940
994D
99BA
99C9
9A24
9A27
9A2D
9A2E
9A56
9AB5
9AF0
9B20
9B33
9B34
9B8F
9BA7
9BC1
9BD7
9BE7
9BEB
9BF7
9BFD
9C0B
9C27
9C36
9C41
9C53
9C63
9C77
9D02
9D42
9D47
9D69
9D7C
9D8D
9DB1
9DC3
9DC7
9DD6
9DD7
9DDF
9DEB
9DF4
9E15
9E1D
9E7C
9EA4
9EA8
9EB4
9EB5
9EE7
9EEE
9F10
9F12
9F17
9F19
9F2F
9F41
9F45
9F57
9F71
9F75
9F90
9F94
9FA2
EOH
}

sub InJISX0221JapaneseIdeographicsSupplement2 {
<<EOH;
4E02
4E04
4E05
4E0C
4E12
4E23
4E24
4E2E
4E30
4E35
4E40
4E41
4E47
4E51
4E5A
4E5C
4E63
4E68
4E69
4E74
4E75
4E79
4E96
4E97
4E9D
4EAF
4EC3
4ED0
4EDA
4EDB
4EE0
4EE1
4EE2
4EE8
4EEF
4EF1
4EF3
4EF5
4EFD
4EFE
4F00
4F02
4F08
4F0C
4F12
4F16
4F17
4F19
4F2E
4F31
4F33
4F35
4F37
4F39
4F3E
4F40
4F42
4F48
4F4B
4F4C
4F52
4F56
4F58
4F5F
4F63
4F6A
4F6C
4F6E
4F71
4F77
4F78
4F79
4F81
4F82
4F84
4F85
4F89
4F8C
4F8E
4F90
4F92
4F93
4F94
4F99
4F9A
4F9E
4F9F
4FB2
4FB7
4FB9
4FBB
4FBC
4FBD
4FC0
4FC1
4FC5
4FC6
4FC8
4FCB
4FCC
4FCD
4FD2
4FDC
4FE2
4FF0
4FF2
4FFC
4FFF
5000
5004
5007
500A
500C
500E
5013
5017
5018
501C
501D
5022
5030
5032
5033
5035
5040
5041
5042
5045
5046
504A
504C
504E
5051
5052
5053
5057
5059
505F
5060
5062
5063
5067
506D
5070
5071
5081
5083
5084
5086
508A
508E
508F
5090
5092
5093
509B
509C
509E
509F
50A0
50A1
50A2
50AA
50AF
50B0
50B9
50BA
50BD
50C0
50C3
50C4
50C7
50CC
50CE
50D0
50D3
50D4
50D8
50DC
50DD
50DF
50E2
50E4
50E6
50E8
50EF
50F1
50F2
50F6
50FA
50FE
5103
5106
5107
510C
510D
510E
5110
5117
5119
511C
511D
5123
5127
5128
512C
512D
512F
5131
5133
5134
5135
5138
5139
5142
514A
514F
5153
5155
5157
5158
515F
5164
5166
517E
5183
5184
518B
518E
5198
519D
51A3
51AD
51B8
51BA
51BC
51BE
51BF
51C2
51C8
51CF
51D1
51D2
51D3
51D5
51D8
51DE
51E2
51E5
51EE
51F2
51F3
51F4
51F7
5205
5212
5216
5218
5222
5228
5231
5232
5235
523C
5245
5255
5257
5258
525A
525C
525F
5260
5261
526E
5277
5278
5279
5280
5282
5285
528A
528C
5295
5296
5297
5298
529A
529C
52A4
52A5
52A7
52AF
52B0
52B6
52B7
52B8
52BA
52BB
52BD
52C0
52C4
52C6
52C8
52CC
52CF
52D1
52D4
52D6
52DC
52E1
52E5
52E8
52E9
52EA
52EC
52F1
52F4
52F6
52F7
5300
5303
530C
5311
5313
5318
531B
531C
531E
531F
5325
5327
5328
5329
532B
532C
532D
5330
5332
5335
533C
533D
5342
534B
534C
5359
535B
5363
5365
536D
5372
5379
537E
5383
5387
5388
538E
5394
5399
539D
53A1
53A4
53AA
53AF
53B2
53B4
53B5
53B7
53B8
53BA
53BD
53C0
53C5
53CF
53D2
53D3
53D5
53DD
53DE
53E0
53E6
53E7
5402
5413
541A
5421
5428
542A
542F
5431
5434
5435
5443
5444
5447
544F
545E
5462
5464
5466
5467
5469
546B
546D
546E
547F
5481
5483
5485
5488
5489
5491
5495
5496
549F
54A1
54A6
54A7
54AA
54AE
54B1
54B7
54BA
54BB
54CA
54CD
54CE
54E0
54EA
54EC
54EF
54F6
54FC
54FE
54FF
5500
5501
5505
5508
5509
550C
550D
5515
552A
5532
5536
553B
553C
553D
5541
5547
5549
554A
554D
5550
5551
5558
555A
555B
5560
5561
5564
5566
557F
5581
5582
558F
5591
5592
5593
5594
5597
55A3
55A4
55AD
55B2
55BF
55C1
55C3
55C6
55C9
55CB
55CC
55CE
55D1
55D2
55D3
55D7
55D8
55DB
55DE
55E2
55E9
55F6
55FF
5605
5608
560A
560D
5610
5611
5612
5619
562C
5630
5633
5635
5639
563B
563C
563D
5640
5641
5643
5644
5646
564D
5654
565E
5660
5661
5662
5663
566D
5675
5684
5685
5688
568B
568C
569D
569E
569F
56A6
56A7
56A8
56A9
56AB
56B3
56B7
56BE
56C5
56CB
56CC
56CD
56CF
56D0
56D9
56DC
56DF
56E1
56E4
56E5
56E6
56E7
56E8
56EB
56ED
56F1
56F6
56F7
5701
5702
5707
570A
570C
5711
5715
571A
571B
571D
5720
5722
5724
5725
5729
572A
572C
572E
5733
5734
573D
573E
573F
5745
5746
574C
574D
5752
5762
5765
5767
5768
576B
576D
576E
576F
5771
5773
5774
5775
5777
5779
577A
577B
577C
577E
5781
5783
578C
5794
5795
5797
5799
579A
579D
579E
579F
57A1
57A7
57A8
57A9
57BD
57C7
57C8
57CC
57CF
57D5
57DD
57DE
57E1
57E4
57E7
57E9
57F0
57F8
57FD
57FE
5803
5804
5808
5809
580C
580D
581B
581E
581F
5826
5827
582D
5839
583F
5849
584C
584D
584F
5850
5855
585F
5864
5867
5868
5878
587F
5881
5887
5888
5889
588A
588C
588D
588F
5890
5894
5896
589D
58A0
58A1
58A2
58A6
58B1
58B2
58BC
58C2
58C4
58C8
58CD
58D0
58D2
58D4
58D6
58DA
58DD
58E1
58E2
58E9
58F3
5905
5906
590B
5912
5913
5914
591D
5921
5923
5924
5928
5930
5933
5935
5936
593F
5943
5946
5952
5953
5959
595E
595F
5963
596B
596F
5972
5975
5976
5979
597B
597C
598B
598C
598E
5992
5995
5997
599F
59A4
59A7
59AD
59AE
59AF
59B0
59B3
59B7
59BA
59BC
59C1
59C3
59C4
59C8
59CA
59CD
59DE
59DF
59E4
59E7
59EE
59EF
59F1
59F2
59F4
59F7
5A00
5A04
5A0D
5A0E
5A12
5A13
5A1E
5A23
5A24
5A27
5A28
5A2A
5A2D
5A30
5A44
5A45
5A48
5A4C
5A50
5A5E
5A65
5A67
5A77
5A7A
5A7B
5A8B
5A90
5A93
5A96
5A99
5A9C
5A9F
5AA0
5AA2
5AAC
5AB1
5AB2
5AB5
5AB8
5ABA
5ABB
5ABF
5AC4
5AC6
5AC8
5ACF
5ADA
5ADC
5AE5
5AEA
5AEE
5AF5
5AF6
5AFD
5B01
5B08
5B17
5B1B
5B1D
5B21
5B34
5B38
5B4B
5B4C
5B52
5B56
5B5E
5B68
5B6E
5B6F
5B7D
5B7E
5B81
5B84
5B86
5B8A
5B8E
5B90
5B91
5B93
5B94
5B96
5BA8
5BA9
5BAC
5BAD
5BAF
5BB1
5BB2
5BB7
5BBA
5BBC
5BC1
5BCD
5BCF
5BD6
5BD7
5BD8
5BD9
5BDA
5BE0
5BEF
5BF1
5BF4
5BFD
5C0C
5C17
5C1E
5C1F
5C26
5C29
5C2C
5C2E
5C32
5C35
5C36
5C59
5C5A
5C5C
5C67
5C68
5C6D
5C70
5C74
5C75
5C7A
5C7B
5C7C
5C7D
5C87
5C88
5C8A
5C8F
5C92
5C9D
5C9F
5CA0
5CA2
5CA3
5CA6
5CAA
5CB2
5CB4
5CB5
5CC9
5CD7
5CDD
5CEE
5CF1
5CF2
5D01
5D06
5D0D
5D12
5D23
5D2B
5D31
5D34
5D39
5D3D
5D3F
5D42
5D48
5D51
5D55
5D59
5D5F
5D60
5D61
5D62
5D64
5D6A
5D6D
5D70
5D79
5D7A
5D7E
5D7F
5D81
5D83
5D88
5D8A
5D93
5D95
5D9B
5D9F
5DA7
5DAB
5DB0
5DB2
5DB4
5DB9
5DC3
5DC7
5DCB
5DCE
5DD0
5DD9
5DE4
5DE9
5DF8
5DF9
5E00
5E07
5E0D
5E15
5E1F
5E20
5E28
5E2E
5E32
5E35
5E3E
5E49
5E4B
5E50
5E51
5E56
5E58
5E5B
5E5C
5E5E
5E68
5E6A
5E6B
5E6D
5E6E
5E70
5E80
5E8B
5E8E
5EA2
5EA4
5EA5
5EA8
5EAC
5EB1
5EB3
5EBD
5EC6
5ECB
5ECC
5ECE
5ED1
5ED4
5ED5
5EDC
5EDE
5EE5
5EEB
5F02
5F06
5F08
5F19
5F21
5F23
5F24
5F2B
5F2C
5F2E
5F30
5F34
5F3B
5F3D
5F3F
5F44
5F47
5F4D
5F54
5F5B
5F60
5F63
5F64
5F6F
5F72
5F74
5F75
5F78
5F7A
5F7D
5F7E
5F89
5F8D
5F8F
5F96
5F9C
5F9D
5FA2
5FA4
5FAB
5FAC
5FB0
5FB1
5FC7
5FC8
5FCB
5FD0
5FD1
5FD2
5FD3
5FD4
5FDE
5FE2
5FE8
5FEA
5FEC
5FEE
5FEF
5FF2
5FF3
5FF6
5FFA
5FFC
6007
600A
600D
6013
6014
6017
6018
601A
601F
6024
602D
6035
6040
6047
6048
6049
604C
6051
6054
6056
6057
605D
6067
6071
607E
6082
6086
6088
608E
6091
6093
6095
6098
609D
609E
60A2
60A4
60A5
60A8
60B1
60B7
60BB
60BE
60C2
60C4
60C8
60C9
60CA
60CB
60CE
60CF
60D4
60D9
60DD
60DE
60E2
60E5
60F2
60F5
60FC
60FD
6102
6107
610A
610C
6110
6111
6112
6116
6117
6119
611C
611E
6122
612A
612B
6131
6135
6136
6139
6141
6145
6146
6149
615E
6160
616C
6172
6178
617B
617C
617F
6180
6181
6183
6184
618B
6192
6193
6197
6198
619C
619D
619F
61A0
61A5
61AA
61AD
61B8
61B9
61BC
61C0
61C1
61CE
61CF
61D5
61DC
61DD
61DE
61DF
61E1
61E2
61E5
61E7
61E9
61EC
61ED
61EF
6201
6203
6204
6207
6213
621C
6220
6222
6223
6227
622B
6239
623D
6242
6244
6250
6251
6252
6254
625A
625C
6264
626D
626F
6273
627A
627D
628D
628E
628F
6290
62A6
62A8
62B3
62B6
62B7
62BA
62BE
62BF
62CE
62D5
62D6
62DA
62EA
62F2
62F4
62FC
62FD
6303
6304
630B
6310
6313
6316
6318
6329
632A
632D
6335
6336
633C
6341
6344
6346
634A
634B
634E
6352
6353
6354
6358
635B
6366
636C
636D
6371
6375
6378
637C
637F
6382
638A
6394
6395
6399
639A
63A4
63A6
63AD
63AE
63AF
63BD
63C1
63C5
63C8
63CE
63D1
63D3
63D4
63D5
63DC
63E0
63E5
63EA
63EC
63F2
63F3
63F8
63F9
640A
6412
6418
641E
6420
6424
6425
6429
642A
642F
6430
6435
643D
643F
644B
644F
6452
6453
6454
645A
645C
645D
645F
6461
6463
6473
6474
647D
6485
6487
648F
6490
6491
6498
6499
649B
649F
64A1
64A3
64A6
64A8
64AC
64B3
64BD
64BE
64C4
64C9
64CA
64CB
64CC
64CE
64D0
64D1
64D5
64D7
64E4
64E9
64EA
64ED
64F0
64F5
64FF
6501
6508
6509
650A
650F
6513
6514
651B
651E
651F
6526
6529
652E
6531
653A
653C
653D
6543
6547
6549
6550
6552
6554
655F
6560
6567
656B
657A
657D
6581
658A
6592
6595
6598
659D
65A0
65A3
65A6
65AE
65B2
65B3
65B4
65BF
65C8
65C9
65CE
65D0
65D4
65D6
65D8
65DF
65F2
65F4
65F5
65F9
65FE
65FF
6600
6604
6608
660D
6611
6612
6616
661D
6621
6622
6623
6624
6626
6629
662A
662B
662E
6630
6633
6637
6639
6640
6645
6646
664A
664E
6651
6657
6658
665B
6660
666A
666C
6675
6677
6678
6679
667B
667C
667E
667F
6680
668B
668C
668D
6690
6692
6699
669A
669B
669C
669F
66A0
66AD
66B1
66B5
66BB
66BF
66C0
66C2
66C3
66C8
66CC
66CE
66CF
66D4
66DB
66DF
66E8
66EB
66EE
66FA
6705
6707
670E
6713
6719
671C
6720
6722
6733
673E
6745
6747
6754
6755
675D
676C
676E
6774
6781
6784
678E
678F
6791
6793
6796
6798
6799
679B
67B1
67B5
67BC
67BD
67C0
67C2
67C3
67C5
67C8
67C9
67D2
67D7
67D9
67DC
67E1
67E6
67F2
67F6
67F7
6814
6819
681D
681F
6827
6828
682D
682F
6831
6833
683B
683F
6844
6845
684A
684C
6852
6855
6857
6858
686B
686E
686F
6870
6871
6879
687B
687C
6882
6884
6886
6888
6896
6898
689A
689C
68A1
68A3
68A5
68A9
68AA
68AE
68BB
68C5
68C8
68CC
68CF
68D1
68D3
68D9
68DC
68DD
68E5
68EA
68EB
68EC
68F5
68F6
68FB
68FD
6906
6909
690A
6910
6911
6916
6917
6931
6933
6935
6938
693B
6942
6945
6949
694E
695B
6964
6965
6966
6969
696C
6970
6971
697A
697B
698D
6992
6996
6998
69A1
69A5
69A8
69AB
69AF
69B8
69BA
69BC
69C5
69C8
69D1
69D6
69D7
69E2
69E5
69EE
69EF
69F1
69F3
69F5
69FE
6A00
6A03
6A11
6A1A
6A1D
6A20
6A24
6A30
6A32
6A37
6A3B
6A3F
6A45
6A46
6A49
6A4A
6A4E
6A52
6A55
6A64
6A67
6A6A
6A71
6A73
6A81
6A86
6A87
6A8B
6A91
6A9B
6AA5
6AAB
6AAF
6AB0
6AB1
6AB4
6ABD
6ABE
6ABF
6AC6
6AC8
6AC9
6ACC
6AD0
6AD4
6AD5
6AD6
6ADD
6AEC
6AF0
6AF1
6AF2
6AFC
6AFD
6B02
6B03
6B06
6B07
6B09
6B0F
6B10
6B11
6B17
6B1B
6B1E
6B24
6B28
6B2B
6B2C
6B2F
6B35
6B36
6B3B
6B3F
6B46
6B4A
6B4D
6B52
6B56
6B58
6B5D
6B60
6B67
6B6B
6B6E
6B70
6B75
6B7D
6B7E
6B82
6B85
6B97
6B9B
6B9F
6BA0
6BA2
6BA3
6BA8
6BA9
6BAC
6BAD
6BAE
6BB0
6BB8
6BB9
6BBD
6BBE
6BC3
6BC4
6BC9
6BCC
6BD6
6BDA
6BE1
6BE3
6BE6
6BE7
6BEE
6BF1
6BF7
6BF9
6BFF
6C02
6C04
6C05
6C09
6C0D
6C0E
6C12
6C19
6C1F
6C26
6C27
6C28
6C2C
6C2E
6C36
6C3B
6C3F
6C4A
6C4B
6C4D
6C4F
6C52
6C54
6C5B
6C5C
6C67
6C6B
6C6D
6C6F
6C74
6C78
6C79
6C7B
6C87
6C89
6C94
6C97
6C98
6C9F
6CB0
6CB2
6CB4
6CC2
6CC6
6CCD
6CCF
6CD1
6CD2
6CDA
6CDC
6CE0
6CE7
6CE9
6CEC
6CF2
6CF4
6D07
6D0A
6D0F
6D13
6D1A
6D26
6D27
6D28
6D2F
6D31
6D39
6D3C
6D3F
6D57
6D5F
6D61
6D67
6D6F
6D70
6D7C
6D91
6D92
6D94
6D96
6D97
6D98
6DAA
6DAC
6DB4
6DB7
6DB9
6DBD
6DC8
6DCA
6DCE
6DCF
6DDB
6DDD
6DDF
6DE0
6DE2
6DE5
6DEF
6DF0
6DF4
6DF6
6DFC
6E00
6E04
6E1E
6E27
6E32
6E36
6E39
6E3B
6E3C
6E44
6E45
6E48
6E49
6E4B
6E4F
6E52
6E53
6E54
6E57
6E5D
6E5E
6E62
6E63
6E68
6E73
6E7B
6E7D
6E8D
6E93
6E99
6EA0
6EA7
6EAD
6EAE
6EB1
6EB3
6EBB
6EBF
6EC0
6EC1
6EC3
6EC7
6EC8
6ECA
6ECD
6ECF
6EEB
6EED
6EEE
6EF9
6EFB
6EFD
6F04
6F08
6F0A
6F0C
6F0D
6F16
6F18
6F1B
6F26
6F29
6F2D
6F2F
6F30
6F33
6F36
6F3B
6F3C
6F4F
6F52
6F53
6F57
6F59
6F5D
6F5E
6F61
6F62
6F68
6F6C
6F7D
6F7E
6F83
6F87
6F88
6F8B
6F8C
6F8D
6F90
6F92
6F93
6F94
6F96
6F9A
6F9F
6FA0
6FA5
6FA6
6FA7
6FA8
6FAE
6FAF
6FB0
6FB5
6FB6
6FBC
6FC5
6FC7
6FC8
6FCA
6FDA
6FDE
6FE8
6FE9
6FF0
6FF5
6FF9
6FFC
6FFD
7000
7005
7006
7007
700D
7017
7020
7023
702F
7034
7037
7043
7044
7048
7049
704B
704E
7055
7064
7065
706E
7075
7076
7086
7094
7095
7096
7097
7098
709B
70A4
70B0
70B1
70B4
70CA
70D1
70D3
70D4
70D5
70D6
70E4
70FA
7103
7104
7105
7106
7107
710B
710C
710F
711E
712B
712D
712F
7138
7141
7145
7146
714A
714B
7150
7152
7157
715A
715E
7168
7179
7180
7185
7187
718C
7192
719A
719B
71A0
71A2
71AF
71B0
71B2
71B3
71BA
71BF
71C0
71C4
71CB
71CC
71D3
71D6
71D9
71DA
71DC
71F8
71FE
7200
7207
7208
7209
7213
7217
721A
721F
7224
722F
7234
7239
7242
7243
7245
724E
724F
7250
725A
725C
725E
7260
7263
7268
726B
726E
726F
7271
7277
7278
727B
727C
727F
7284
7289
728E
7293
729B
72A8
72AE
72B1
72BE
72C1
72C7
72C9
72CC
72D5
72D6
72D8
72DF
72E5
72F3
72F4
72FA
72FE
7302
7304
7305
7307
730B
730D
7312
7313
7318
7319
731E
7322
7324
7327
732C
7332
7335
733A
733B
733D
734D
7350
7352
7356
7358
735D
735E
735F
7360
7366
7367
7369
736B
736E
736F
7371
7377
7379
7380
7381
7385
738E
7390
7393
7397
7398
739C
73A2
73A5
73AA
73AD
73B9
73BD
73BF
73C5
73C6
73CB
73CC
73D2
73D3
73D9
73DD
73E1
73E6
73E7
73F4
73F7
73F9
73FA
73FB
73FF
7400
7401
7404
7411
7424
7429
742B
742D
7440
7443
7446
7447
744B
7452
745D
7462
7466
7467
7468
746D
746E
7472
7481
748F
7490
7491
7492
7499
749A
74A1
74A6
74A9
74AA
74AE
74AF
74B1
74B2
74B9
74BB
74C9
74CC
74D0
74D3
74D8
74DB
74DF
74E4
74E8
74EA
74EB
74EF
74F4
74FA
74FB
74FC
74FF
7506
7512
7516
7517
7520
7521
7524
7527
7529
752A
752F
7536
7539
753D
753E
753F
7540
7543
7547
7548
7550
7552
7557
755E
755F
7561
7571
757A
757B
757C
757D
757E
7581
7585
7595
7599
759C
75A2
75A4
75B4
75BA
75BF
75C0
75C1
75C4
75C6
75CC
75CE
75CF
75D7
75DC
75DF
75E0
75E1
75E4
75E7
75EC
75EE
75EF
75F1
7602
7603
7604
7607
7608
760C
760F
7612
7613
7616
7619
761B
761C
761D
7623
7625
7629
762D
7632
7633
7638
7639
763A
763C
7640
7641
7644
7645
7649
764A
7655
7659
765F
7664
7665
766E
7681
7685
768C
768D
7695
769C
769D
769F
76A0
76A2
76A3
76A5
76A7
76A8
76AA
76AD
76BD
76C1
76C9
76CB
76CE
76D4
76D9
76E0
76E6
76E8
76F0
76F1
76F6
76F9
76FC
7700
7706
770A
770E
7712
7714
7715
7717
7719
771A
771C
7722
7728
772D
772E
772F
7735
7739
773D
773E
7742
7745
7746
774A
774D
774E
774F
7752
7756
7757
775C
775E
7762
7764
7767
776A
776C
7770
7772
7773
7774
777A
7780
7784
778C
778D
7794
7796
779A
779F
77A2
77A7
77AE
77AF
77B1
77B5
77BE
77C3
77C9
77D1
77D2
77D5
77D9
77DE
77DF
77E0
77E4
77E6
77EA
77EC
77F1
77F8
77FB
7805
7809
780D
780E
7811
781D
7823
7830
7837
7843
7844
7847
7848
784C
784E
7852
785C
785E
7860
7861
7863
7864
786A
786E
787A
787E
788A
788F
7894
7898
789D
789F
78A1
78A4
78A8
78AC
78AD
78B0
78B1
78B2
78B3
78BB
78BD
78BF
78C7
78C9
78D2
78D3
78D5
78D6
78DB
78DF
78E0
78E1
78E6
78EA
78F3
78F6
78FA
78FF
7900
7906
790C
7910
791A
791C
791E
791F
7920
7925
7927
7929
792D
7934
7935
793B
793F
7944
7946
794A
794B
794F
7951
7954
7958
7967
7969
796B
7972
7979
797B
797C
797E
798B
798C
7991
7993
7995
799B
799C
79A1
79A8
79A9
79AB
79AF
79B4
79BB
79C2
79C4
79C7
79C8
79CF
79D4
79D6
79DA
79DD
79DE
79E0
79E2
79E5
79EA
79EB
79ED
79F1
79F8
79FC
7A02
7A03
7A07
7A09
7A0A
7A0C
7A15
7A1B
7A1E
7A21
7A27
7A2B
7A2F
7A30
7A34
7A35
7A38
7A3A
7A44
7A45
7A47
7A48
7A55
7A56
7A59
7A5C
7A5F
7A60
7A65
7A67
7A6A
7A75
7A7E
7A80
7A82
7A85
7A86
7A8A
7A8B
7A90
7A91
7A94
7A9E
7AAC
7AB5
7AB9
7ABC
7AC6
7AC9
7ACC
7ACE
7ADB
7AE8
7AE9
7AEC
7AF1
7AF4
7AFB
7AFD
7AFE
7B1F
7B23
7B29
7B2A
7B2B
7B2D
7B2E
7B2F
7B30
7B34
7B3D
7B3F
7B40
7B41
7B4E
7B55
7B64
7B66
7B69
7B6A
7B6F
7B73
7B77
7B84
7B89
7B8E
7B90
7B96
7B9B
7B9E
7BA0
7BA5
7BAC
7BB0
7BB2
7BB5
7BB6
7BBA
7BBB
7BBC
7BBD
7BC2
7BC5
7BC8
7BCA
7BD4
7BD6
7BDA
7BDB
7BE8
7BEA
7BF2
7BF4
7BF5
7BF8
7BF9
7BFA
7BFC
7BFE
7C01
7C02
7C03
7C04
7C06
7C09
7C0C
7C0E
7C19
7C1B
7C25
7C28
7C2C
7C31
7C33
7C34
7C39
7C3A
7C46
7C4A
7C52
7C53
7C55
7C5A
7C5B
7C5C
7C5D
7C5E
7C61
7C63
7C69
7C6D
7C72
7C79
7C7C
7C7D
7C86
7C87
7C8F
7C94
7C9E
7CA0
7CA6
7CB0
7CB6
7CB7
7CBA
7CBB
7CC4
7CC7
7CCD
7CCF
7CD3
7CD4
7CD5
7CD9
7CDA
7CE6
7CE9
7CF5
7D03
7D0F
7D11
7D12
7D13
7D16
7D1E
7D26
7D2A
7D2D
7D31
7D3C
7D3D
7D3E
7D40
7D47
7D48
7D4D
7D51
7D57
7D5A
7D5D
7D65
7D67
7D6A
7D70
7D78
7D7B
7D7F
7D81
7D82
7D83
7D85
7D88
7D8B
7D8D
7D91
7D96
7D97
7D9D
7D9E
7DA6
7DA7
7DAA
7DB3
7DB6
7DB9
7DC2
7DC3
7DC4
7DC5
7DC6
7DCD
7DCE
7DD7
7DD9
7DE2
7DE5
7DE6
7DEA
7DED
7DF5
7DF6
7DF9
7DFA
7E00
7E08
7E10
7E15
7E17
7E1C
7E1D
7E27
7E28
7E2C
7E2D
7E2F
7E33
7E36
7E3F
7E44
7E45
7E4E
7E50
7E52
7E58
7E5F
7E65
7E6F
7E78
7E7E
7E81
7E86
7E87
7E8D
7E95
7E9A
7E9D
7E9E
7F3B
7F3C
7F3D
7F3E
7F3F
7F43
7F5B
7F5C
7F5D
7F63
7F64
7F65
7F66
7F6D
7F71
7F7D
7F7E
7F7F
7F80
7F8B
7F8D
7F8F
7F90
7F96
7F97
7F9C
7FA1
7FA2
7FA6
7FAA
7FAD
7FB4
7FBC
7FC0
7FC3
7FC8
7FCF
7FDB
7FE3
7FE8
7FF2
7FFD
7FFE
7FFF
8007
8008
800A
800D
800F
8013
8016
801D
801E
801F
8020
8026
802C
802E
8030
8034
8035
8037
8039
803A
803E
8040
8044
8060
8064
8066
806D
8081
8088
808E
809C
809E
80A6
80A7
80B8
80B9
80C8
80CD
80CF
80D2
80D4
80D5
80E0
80ED
80EE
80F0
80F2
80F3
80F6
80F9
80FA
80FE
8103
810B
8116
8117
8118
811C
811E
8120
8124
8127
812C
8130
8135
813A
813C
8145
8147
8152
8157
8160
8161
8167
8168
8169
816D
816F
8177
8185
8186
818B
818E
8190
8196
8198
819B
819E
81A2
81AE
81B2
81BB
81C3
81C5
81CA
81CB
81CE
81D5
81D7
81DB
81DD
81DE
81E1
81E4
81EB
81EC
81F0
81F1
81F2
81F5
81F6
81F8
81F9
81FD
81FF
8200
820F
8213
8214
8219
821A
821D
8222
8228
8234
823A
8243
8244
8245
8246
824E
824F
8251
8256
825C
8260
8263
8267
826D
8274
827B
827D
827F
8280
8281
8283
8284
8287
8289
828A
828E
8291
8294
8296
8298
829A
829B
82A0
82A1
82A3
82A4
82A7
82A8
82A9
82AA
82AE
82B0
82B2
82B4
82BA
82BC
82BE
82BF
82C6
82D0
82D5
82DA
82E0
82E2
82E4
82E8
82EA
82ED
82EF
82F6
82F7
82FD
8300
8301
8307
8308
830A
830B
831B
831D
831E
831F
8321
8322
832C
832D
832E
8330
8333
8337
833A
833C
833D
8342
8344
8347
834D
834E
8353
8354
8355
8356
8357
8370
8378
837D
837F
8380
8382
8384
838D
8394
8395
8399
839B
839C
839D
83A6
83A7
83AC
83AD
83BE
83BF
83C7
83C9
83CF
83D0
83D1
83D4
83DD
83E8
83F6
83F8
83F9
83FC
8401
8406
8415
8419
842F
8439
8445
8447
8448
844D
844F
8451
8452
8456
8458
8459
845A
845C
8460
8464
8465
8467
846A
8470
8473
8474
8478
847C
847D
8481
8485
8492
8493
8495
849E
84A6
84A9
84AA
84AF
84B1
84B4
84BA
84BD
84BE
84C7
84C8
84CC
84CF
84D3
84E7
84EA
84EF
84F0
84F1
84F2
84F7
84FA
84FB
8502
8503
8507
850E
8510
851C
851E
8522
8524
8525
8527
852A
852B
852F
8532
8533
8534
8536
853F
8546
854F
8550
8551
8552
8553
8556
8559
855C
855D
855E
855F
8560
8561
8562
8564
856B
856F
8579
857A
857B
857D
857F
8581
8585
8586
8589
858B
858C
8593
8598
859D
859F
85A0
85A2
85A5
85A7
85AD
85B4
85B6
85B8
85BC
85BD
85BE
85BF
85C2
85C7
85CA
85CB
85D8
85DA
85DF
85E0
85E6
85E8
85ED
85F3
85F6
85FC
85FF
8600
8604
8605
860D
860E
8610
8611
8612
8618
8619
861B
861E
8621
8627
8636
8638
863A
863C
863D
8640
8641
8642
8646
8652
8653
8656
8657
8658
8659
865D
8660
8661
8662
8663
8664
8669
866F
8675
8676
8677
8688
8696
869A
869C
86A1
86A6
86AD
86B1
86B3
86B4
86B5
86B7
86B8
86B9
86BF
86C0
86C1
86C3
86C5
86D1
86D2
86D5
86D7
86DA
86DC
86E0
86E3
86E5
86E7
86FC
86FD
8704
8705
8707
870E
870F
8710
8713
8714
8719
871F
8721
8723
872E
872F
8731
8732
8739
873A
873C
873D
8740
8743
8745
874D
8758
875D
8761
8764
8765
876F
8772
877B
8783
8784
8785
8786
8787
8789
878B
878C
8790
8793
8795
8797
8798
879E
87A0
87A3
87A7
87AE
87B1
87BE
87BF
87C1
87C8
87C9
87CA
87CE
87D5
87D9
87DA
87DC
87DF
87E2
87E3
87E4
87EA
87F1
87F3
87F8
87FA
87FF
8801
8809
880A
880B
8810
8812
8813
8818
8819
881A
881B
881E
8828
882D
882E
8830
8832
8835
883A
883C
8841
8843
8845
8848
8849
884A
884B
884E
8851
8855
8858
885A
885C
8860
8869
8871
8879
887B
8880
889A
889B
889C
889F
88A0
88A8
88AA
88BA
88C0
88CB
88CC
88CD
88CE
88D1
88D3
88DE
88E7
88EF
88F5
88F7
8901
8906
890D
890E
890F
8915
8916
891A
891C
8920
8926
8928
8931
8932
8935
8939
893A
8940
8942
8945
8946
8949
894F
8952
8957
895A
895B
895C
8961
8962
8963
896B
896E
8970
8973
8975
897A
897C
897D
8989
898D
8990
8994
8995
899B
899C
899F
89A0
89A5
89B0
89B4
89B5
89B6
89B7
89BC
89D5
89D7
89D8
89E9
89EB
89ED
89F3
89F6
89F9
89FD
89FF
8A04
8A05
8A0F
8A11
8A14
8A1E
8A20
8A24
8A26
8A2B
8A2C
8A2F
8A35
8A37
8A3D
8A3E
8A40
8A43
8A45
8A47
8A49
8A4D
8A4E
8A53
8A56
8A57
8A58
8A5C
8A5D
8A61
8A65
8A67
8A75
8A76
8A77
8A7A
8A7B
8A7E
8A7F
8A80
8A83
8A86
8A8B
8A8F
8A90
8A92
8A96
8A97
8A99
8A9F
8AA7
8AA9
8AAE
8AAF
8AB3
8AB6
8AB7
8ABB
8AC3
8AC6
8AC8
8AC9
8ACA
8AD1
8AD3
8AD4
8AD5
8AD7
8ADD
8AEC
8AF0
8AF5
8AFC
8AFF
8B05
8B06
8B0A
8B0B
8B11
8B1C
8B2D
8B30
8B37
8B3C
8B42
8B44
8B45
8B48
8B4D
8B52
8B53
8B59
8B5E
8B63
8B6D
8B76
8B78
8B79
8B7C
8B7E
8B81
8B84
8B85
8B8B
8B8D
8B8F
8B94
8B95
8B9F
8C38
8C39
8C3D
8C3E
8C45
8C49
8C4B
8C4F
8C51
8C53
8C57
8C58
8C59
8C5B
8C5D
8C63
8C64
8C66
8C68
8C69
8C6D
8C75
8C76
8C7B
8C7E
8C86
8C87
8C8B
8C90
8C92
8C93
8C99
8C9B
8C9C
8CB9
8CBA
8CC5
8CC6
8CC9
8CCB
8CCF
8CD5
8CD6
8CD9
8CDD
8CE8
8CEC
8CEF
8CF0
8CF2
8CF5
8CF7
8CF8
8CFF
8D01
8D03
8D09
8D12
8D17
8D65
8D6E
8D7F
8D82
8D84
8D88
8D90
8D91
8D9E
8D9F
8DA0
8DA6
8DAB
8DAC
8DAF
8DB2
8DB5
8DB7
8DB9
8DBB
8DBC
8DC0
8DC5
8DC7
8DC8
8DCA
8DD1
8DD4
8DD5
8DD7
8DD9
8DE4
8DE5
8DE7
8DF0
8DF1
8DF2
8DF4
8DFD
8E01
8E04
8E05
8E06
8E0B
8E11
8E14
8E16
8E20
8E21
8E22
8E23
8E26
8E27
8E31
8E33
8E36
8E37
8E38
8E39
8E3D
8E40
8E41
8E4D
8E4E
8E4F
8E54
8E5B
8E5C
8E5D
8E5E
8E61
8E62
8E69
8E6D
8E6F
8E70
8E71
8E79
8E7B
8E82
8E83
8E89
8E90
8E95
8E9A
8E9B
8E9D
8E9E
8EA2
8EA7
8EA9
8EAD
8EB3
8EB5
8EBA
8EBB
8EC1
8EC3
8EC4
8EC7
8ED1
8EDC
8EE8
8EED
8EEE
8EF0
8EF1
8EF7
8EFA
8F00
8F02
8F07
8F08
8F0F
8F10
8F16
8F18
8F1E
8F20
8F21
8F23
8F25
8F27
8F28
8F2C
8F2D
8F2E
8F34
8F35
8F37
8F3A
8F40
8F41
8F43
8F47
8F4F
8F51
8F52
8F53
8F54
8F55
8F58
8F5D
8F5E
8F65
8F9D
8FA0
8FA1
8FA4
8FA5
8FA6
8FB8
8FBE
8FC0
8FC1
8FC6
8FCA
8FCB
8FCD
8FD0
8FD2
8FD3
8FD5
8FE3
8FE8
8FEE
8FF1
8FF5
8FF6
8FFB
8FFE
9004
9008
900C
9018
901B
9028
9029
902A
902C
902D
902F
9033
9034
9037
903F
9043
904C
905B
905D
9062
9066
9067
906C
9070
9074
9079
9085
908B
908C
908E
9090
9097
9098
90A0
90A1
90A5
90B0
90B2
90B3
90B6
90BD
90BE
90C3
90C4
90C5
90C7
90C8
90CC
90D2
90D5
90D7
90D8
90D9
90DC
90DF
90E5
90EB
90EF
90F0
90F4
90F6
90FE
90FF
9100
9104
9105
9106
9108
910D
9110
9114
9116
9117
9118
911A
911C
911E
9120
9122
9123
9125
9129
912E
912F
9131
9134
9136
9137
9139
913A
913C
9143
9147
914F
9153
9157
9159
915A
915B
9167
916D
9174
9179
917A
917B
9181
9183
9185
9186
918A
9191
9193
9194
9195
9198
91A1
91A6
91B0
91B2
91B3
91B6
91BB
91BD
91BF
91C2
91C3
91C5
91D3
91D4
91D7
91D9
91DA
91DE
91E4
91E9
91EA
91EC
91EE
91EF
91F0
91F1
91F7
91F9
91FB
91FD
9200
9201
9204
9205
9209
920A
920C
9212
9213
9216
9218
921C
921D
9223
9224
9225
9226
9228
922E
922F
9230
9233
9235
9236
9239
923A
923C
923E
9240
9242
9243
9246
924A
924D
924E
9251
9258
9259
925C
925D
9260
9261
9265
9267
9268
9269
926E
926F
9270
9275
9276
9277
9279
927B
927C
927D
927F
9289
928A
928D
928E
9292
9297
9299
929F
92A0
92A4
92A5
92A7
92A8
92AB
92AF
92B2
92B6
92B8
92BA
92BB
92BC
92BD
92BF
92C0
92C1
92C3
92C5
92C6
92C7
92C8
92CB
92CD
92CE
92D0
92D3
92D5
92D8
92D9
92DC
92DD
92E1
92E3
92E5
92E7
92E8
92EC
92EE
92F0
92F9
92FB
92FF
9300
9302
9308
9311
9314
9315
931C
931D
931F
9324
9325
9329
932A
9333
9334
9336
9337
9347
9348
9349
9350
9351
9355
9357
9358
935A
935E
9364
9367
9369
936F
9370
9371
9373
9374
9376
937A
937D
937F
9380
9381
9382
9388
938A
938B
938D
938F
9392
9395
9398
939E
93A1
93A3
93A4
93A6
93A8
93AB
93B4
93B5
93B6
93C4
93C5
93C6
93C7
93C9
93CB
93CC
93CD
93D3
93D9
93DC
93DF
93E6
93E7
93F7
93F8
93F9
93FA
93FB
9401
9402
9404
9408
9409
940D
940E
9415
9416
9417
941F
942E
942F
9431
9432
9433
943B
943D
943F
9443
9445
9448
944A
944C
9459
945C
945F
9461
9463
9468
946D
946E
946F
9471
9483
9484
9578
9579
957E
9584
9588
958C
958D
958E
959D
959E
959F
95A1
95A6
95A9
95AB
95AC
95B4
95B6
95BA
95BD
95BF
95C6
95C8
95C9
95CB
95D0
95D1
95D2
95D3
95D9
95DA
95DD
95DE
95DF
95E0
95E4
95E6
961E
9622
9624
9625
9626
962C
9631
9633
9637
9638
9639
963A
963C
963D
9652
9654
9656
9657
9658
9661
966E
9674
967B
967C
967E
967F
9681
9682
9683
9689
9691
9696
969A
969F
96A4
96A5
96A6
96AE
96AF
96B3
96BA
96CA
96D8
96DA
96DD
96DF
96EF
96FA
9703
9705
971A
971B
971D
9721
9722
9723
9728
9731
9733
9741
9743
974A
974E
974F
9755
9757
9758
975B
9763
9767
976A
9776
9777
9778
977B
977D
977F
9780
9789
9795
9796
9797
9799
979E
979F
97AC
97AE
97B1
97B2
97B5
97B8
97B9
97BA
97BC
97BE
97BF
97C1
97C4
97C5
97C7
97C9
97CA
97CC
97CD
97CE
97D0
97D1
97D4
97D7
97D8
97DB
97DD
97E0
97E1
97E4
97EF
97F1
97F7
97F8
97FA
9807
980D
9814
9816
9819
981C
9820
9823
9825
9826
982E
982F
9832
9833
9835
983E
9844
9847
984A
9851
9856
9859
9862
9863
9866
986A
98AB
98AD
98AE
98B0
98B4
98B7
98BB
98C2
98C5
98C8
98CC
98E1
98E3
98E6
98E7
98EA
98F3
98F6
9902
9907
9908
9911
9915
9916
9917
991A
991B
991C
991F
9922
9926
9927
992B
9931
9934
9935
9939
993A
993B
993C
9941
9946
9947
9948
994E
9954
9958
9959
995B
995C
995E
995F
9960
999B
999D
999F
99A6
99B0
99B1
99B2
99B5
99B9
99BD
99BF
99C3
99D3
99D4
99D9
99DA
99DC
99DE
99E7
99EA
99EB
99EC
99F0
99F4
99F5
99F9
99FD
99FE
9A02
9A03
9A04
9A0B
9A0C
9A10
9A11
9A16
9A1E
9A20
9A22
9A23
9A33
9A35
9A36
9A38
9A41
9A44
9A47
9A4A
9A4B
9A4C
9A4E
9A51
9A54
9A5D
9AAA
9AAC
9AAE
9AAF
9AB2
9AB4
9AB6
9AB9
9ABB
9ABE
9ABF
9AC1
9AC3
9AC6
9AC8
9ACE
9AD0
9AD2
9AD5
9AD6
9AD7
9ADB
9ADC
9AE0
9AE4
9AE5
9AE7
9AE9
9AEC
9AF2
9AF3
9AF5
9AF9
9AFA
9AFD
9AFF
9B00
9B01
9B02
9B03
9B04
9B05
9B08
9B09
9B0B
9B0C
9B0D
9B0E
9B10
9B12
9B16
9B19
9B1B
9B1C
9B26
9B2B
9B2D
9B35
9B37
9B39
9B3A
9B3D
9B48
9B4B
9B4C
9B55
9B56
9B57
9B5B
9B5E
9B61
9B63
9B65
9B66
9B68
9B6A
9B6B
9B6C
9B6D
9B6E
9B73
9B75
9B77
9B78
9B79
9B7F
9B80
9B84
9B85
9B86
9B87
9B89
9B8A
9B8B
9B8D
9B90
9B94
9B9A
9B9D
9B9E
9BA6
9BA9
9BAC
9BB0
9BB1
9BB2
9BB7
9BB8
9BBB
9BBC
9BBE
9BBF
9BC7
9BC8
9BCE
9BD0
9BD8
9BDD
9BDF
9BE5
9BEA
9BEF
9BF3
9BF8
9BF9
9BFA
9BFF
9C00
9C02
9C0F
9C11
9C16
9C18
9C19
9C1A
9C1C
9C1E
9C22
9C23
9C26
9C28
9C29
9C2A
9C31
9C35
9C37
9C3D
9C43
9C44
9C45
9C49
9C4A
9C4E
9C4F
9C50
9C54
9C56
9C58
9C5B
9C5C
9C5D
9C5E
9C5F
9C68
9C69
9C6A
9C6B
9C6E
9C70
9C72
9C75
9C7B
9CE6
9CF2
9CF7
9CF9
9D0B
9D11
9D17
9D18
9D1C
9D1D
9D1E
9D2F
9D30
9D32
9D33
9D34
9D3A
9D3C
9D3D
9D43
9D45
9D4A
9D53
9D54
9D5F
9D62
9D63
9D65
9D6A
9D6B
9D70
9D76
9D77
9D7B
9D7E
9D83
9D84
9D86
9D8A
9D8E
9D92
9D93
9D95
9D96
9D97
9D98
9DA1
9DAA
9DAC
9DAE
9DB5
9DB9
9DBC
9DBF
9DC9
9DCA
9DD4
9DD5
9DDA
9DDE
9DE0
9DE5
9DE7
9DE9
9DEE
9DF0
9DF3
9DFE
9E02
9E07
9E0A
9E0E
9E10
9E11
9E12
9E16
9E19
9E1C
9E7A
9E7B
9E80
9E82
9E83
9E84
9E85
9E87
9E8E
9E8F
9E96
9E98
9E9B
9E9E
9EAC
9EAE
9EAF
9EB0
9EB3
9EC6
9EC8
9ECB
9ED5
9EDF
9EE4
9EEC
9EED
9EF0
9EF1
9EF2
9EF5
9EF8
9EFF
9F02
9F03
9F09
9F0F
9F11
9F14
9F16
9F1A
9F1B
9F1F
9F22
9F26
9F2A
9F2B
9F31
9F32
9F34
9F37
9F39
9F3A
9F3C
9F3D
9F3F
9F43
9F44
9F46
9F47
9F53
9F55
9F56
9F58
9F5A
9F5D
9F5E
9F68
9F69
9F6D
9F6E
9F6F
9F70
9F73
9F7A
9F7D
9F8F
9F91
9F92
9F96
9F97
9F9E
9FA1
9FA3
9FA5
EOH
}

sub InJISX0221JapaneseIdeographicsSupplement3 {
<<EOH;
4E06
4E0F
4E13
4E1A
4E1B
4E1C
4E1D
4E20
4E22
4E25
4E27
4E29
4E2C
4E33
4E34
4E37
4E3A
4E3D
4E3E
4E46
4E48
4E49
4E4A
4E4C
4E50
4E52
4E53
4E54
4E5B
4E60
4E61
4E64
4E65
4E66
4E67
4E6A
4E6B
4E6C
4E6D
4E6E
4E6F
4E70
4E72
4E76
4E77
4E78
4E7A
4E7B
4E7C
4E7D
4E81
4E83
4E84
4E87
4E8F
4E90
4E93
4E9A
4EA3
4EA7
4EA9
4EAA
4EB1
4EB2
4EB4
4EB5
4EB7
4EB8
4EBB
4EBC
4EBD
4EBE
4EBF
4EC5
4EC8
4EC9
4ECC
4ED1
4ED2
4ED3
4EDC
4EE6
4EE7
4EE9
4EEA
4EEB
4EEC
4EF4
4EF8
4EF9
4EFA
4EFC
4F04
4F05
4F06
4F07
4F13
4F14
4F18
4F1B
4F1E
4F1F
4F20
4F21
4F22
4F23
4F24
4F25
4F26
4F27
4F28
4F29
4F2A
4F2B
4F2C
4F2D
4F32
4F3F
4F41
4F44
4F45
4F4A
4F61
4F62
4F64
4F65
4F66
4F67
4F68
4F6B
4F6D
4F72
4F74
4F80
4F87
4F95
4F9C
4FA2
4FA3
4FA4
4FA5
4FA6
4FA7
4FA8
4FA9
4FAA
4FAC
4FB0
4FB1
4FB3
4FB4
4FB8
4FBA
4FC7
4FD3
4FD5
4FD6
4FD9
4FDE
4FE6
4FE7
4FE8
4FE9
4FEA
4FEB
4FEC
4FED
4FF1
4FF4
4FF7
4FF9
4FFB
5002
5003
5008
5015
5020
502F
5031
5034
5037
5038
503A
503C
503D
503E
503F
5044
504B
504D
5054
5058
505B
505D
505E
5061
5064
5068
5069
506B
506E
506F
5073
5077
5079
507A
507B
507C
507E
507F
5082
5087
5088
5089
508B
508C
5095
5097
509D
50A3
50A4
50A5
50A6
50A7
50A8
50A9
50AB
50AE
50B1
50B6
50B8
50BB
50BC
50BF
50C1
50C6
50C8
50CB
50D2
50D7
50D9
50DB
50E0
50E1
50EA
50EB
50EC
50F0
50F3
50F4
50F7
50F8
50FC
50FD
50FF
5105
510A
510F
5111
5113
5120
5122
5124
5125
5126
5129
512B
512E
5130
5136
513D
513E
5151
5156
5159
515B
515D
515E
5160
5161
5163
5167
516F
5170
5172
5173
5174
5179
517A
517B
517D
517F
5181
5187
5188
5194
519A
519B
519C
519E
519F
51A7
51AE
51AF
51B9
51BB
51C0
51C1
51C3
51C7
51CA
51CE
51D0
51D4
51D7
51D9
51DA
51DF
51E3
51E4
51E8
51EB
51EC
51EF
51FB
51FC
51FF
5209
520C
520D
520F
5210
5219
521A
521B
521C
521E
521F
5220
5221
5223
5226
522B
522C
522D
522F
5234
523D
523E
523F
5240
5241
5242
5246
5248
524E
5250
5252
5253
5259
525D
5262
5267
5268
526B
526C
526D
5276
527A
527B
527C
527E
5281
5284
5286
528B
528E
528F
5290
5299
529D
529E
52A1
52A2
52A8
52AE
52B2
52B3
52BF
52C2
52CA
52CB
52CE
52D0
52D3
52DA
52EB
52ED
52EE
52EF
52FB
52FC
52FD
5304
5307
5309
530E
5312
5314
5322
5324
5326
532E
5334
5336
5337
5344
534E
534F
5350
5355
5356
535D
535F
5362
5364
5367
5368
536A
536B
5376
537A
537C
537D
5380
5381
5385
5386
5389
538A
538B
538C
538D
538F
5390
5391
5392
5395
5397
539B
539C
539E
53A2
53A3
53A7
53AC
53B1
53B9
53BC
53BE
53BF
53C1
53C4
53C6
53C7
53D0
53D1
53D8
53DC
53F4
53F9
53FB
53FC
53FD
53FE
53FF
5400
5405
5406
5407
5412
5414
5415
5416
5417
5418
5419
541C
541E
5422
5423
5424
5425
5430
5432
5433
5437
543A
543F
5441
5445
544B
544C
5450
5452
5453
5454
5455
5457
5458
5459
545A
545C
545D
5460
5461
5463
5465
546C
546F
5472
5478
5479
547A
547E
5482
5487
548A
5493
5494
5497
5498
5499
549A
549B
549D
549E
54A0
54A3
54B0
54B4
54B5
54B6
54C3
54C5
54CB
54CC
54CF
54D0
54D1
54D2
54D3
54D4
54D5
54D6
54D7
54D9
54DA
54DB
54DC
54DD
54DE
54DF
54E3
54E4
54E7
54EB
54F0
54F1
54F3
54F4
54F5
54F7
54F8
54F9
54FB
5502
5503
550A
550B
5511
5512
5513
5517
5518
5519
551A
551B
551C
551D
551E
551F
5520
5521
5522
5523
5524
5525
5526
5527
5528
5529
552C
552D
5530
5534
5537
553A
553F
5542
5543
5548
554B
554E
5552
5554
5555
5559
555F
5562
5565
5567
5568
5569
556A
556B
556C
556D
556E
556F
5570
5571
5572
5573
5574
5575
5576
5577
5578
5579
557A
557D
5585
558C
558D
5590
5595
5596
559B
55A0
55A1
55A2
55A5
55A6
55AF
55B1
55B3
55B4
55B5
55B7
55B8
55B9
55BA
55BB
55BC
55BD
55BE
55C0
55C2
55C8
55CA
55CD
55CF
55D0
55D5
55D6
55D9
55DD
55E0
55E1
55E5
55E6
55E7
55E8
55EA
55EB
55EC
55ED
55EE
55EF
55F0
55F1
55F2
55F3
55F4
55F5
55F8
55FA
55FB
55FC
5600
5601
5602
5603
5604
5607
560B
560C
5613
5615
561A
561C
561D
561E
561F
5620
5621
5622
5623
5624
5625
5626
5627
5628
562A
562B
562D
562E
563A
563E
5645
5647
5648
564A
5651
5652
5653
5655
5656
5657
5658
5659
565A
565C
565D
565F
5665
5667
566E
5670
5673
5676
5677
5679
567B
567C
567D
567E
567F
5681
5682
5683
5689
568D
568E
5690
5691
5692
5693
5696
5697
5698
569B
569C
56A1
56A3
56A4
56AA
56AF
56B0
56B2
56B5
56B8
56B9
56BA
56BB
56BD
56BF
56C4
56C6
56C7
56D2
56D4
56D5
56D6
56E2
56E9
56EA
56EC
56EF
56F4
56F5
56F8
56FB
56FC
56FE
5705
5706
570E
5710
5714
5717
5719
571E
5721
572B
5731
5732
5735
5736
5739
573A
573C
5741
5743
5744
5748
5749
574B
5753
5754
5755
5756
5757
5758
5759
575A
575B
575C
575D
575E
575F
5760
5763
576C
5772
5776
5778
577D
5780
5784
5785
5786
5787
578A
578D
578E
578F
5790
5791
5792
5796
5798
579B
57A5
57A6
57AB
57AD
57AE
57AF
57B1
57B2
57B4
57B5
57B6
57B7
57B9
57BA
57BB
57BC
57BE
57BF
57C1
57C2
57C4
57C5
57C9
57CA
57CD
57D0
57D1
57D7
57D8
57D9
57DA
57DB
57E2
57E5
57E8
57EA
57EB
57EC
57EE
57EF
57F1
57F2
57F3
57FB
5801
5807
580E
580F
5810
5811
5812
5813
5814
5816
5817
5818
581A
581C
5822
5823
5825
5828
5829
582B
582C
582E
5833
5836
5837
5838
583B
583C
583E
5842
5843
5844
5845
5846
5847
5848
584E
5853
5856
585B
585C
585D
5860
5863
5865
5866
586A
586C
586D
586E
586F
5871
5873
5874
5876
5877
587A
587B
587D
5882
5884
5886
588B
588E
5891
5892
5895
5898
5899
589A
589B
589E
58A3
58A4
58A5
58A7
58AA
58AC
58AD
58AF
58B0
58B4
58B5
58B6
58B7
58BD
58BF
58C0
58C3
58C6
58C9
58CB
58CF
58DB
58E0
58E3
58E6
58E7
58E8
58EA
58ED
58F4
58F5
58F6
58F8
58FE
58FF
5900
5901
5903
5904
5907
5908
590D
590E
5911
5917
591E
591F
5920
5926
5934
5939
593A
593B
593C
593D
5940
5941
5942
5945
594A
594B
594C
594D
5956
595C
5964
5966
5970
5971
5977
597A
597E
597F
5980
5985
5986
5987
5988
5989
598F
5990
5991
5994
5998
599A
599C
599E
59A0
59A1
59A2
59A6
59A9
59AA
59AB
59B1
59B4
59B5
59B6
59B8
59BD
59BF
59C0
59C2
59C5
59C7
59CC
59CE
59CF
59D5
59D6
59D7
59D8
59DB
59E0
59E1
59E2
59E9
59EC
59ED
59F0
59F3
59F5
59F8
59F9
59FA
59FC
59FD
59FE
5A02
5A05
5A06
5A07
5A08
5A0A
5A0B
5A0F
5A10
5A14
5A15
5A16
5A17
5A19
5A1B
5A1D
5A21
5A22
5A26
5A2B
5A2C
5A2E
5A31
5A32
5A33
5A34
5A37
5A38
5A39
5A3A
5A3B
5A3D
5A3E
5A3F
5A42
5A43
5A4A
5A4B
5A4D
5A4E
5A4F
5A51
5A52
5A53
5A54
5A56
5A57
5A58
5A59
5A5B
5A5C
5A5D
5A5F
5A60
5A61
5A64
5A68
5A69
5A6B
5A6E
5A6F
5A70
5A71
5A72
5A73
5A74
5A75
5A76
5A78
5A79
5A7C
5A7D
5A80
5A81
5A82
5A83
5A84
5A85
5A86
5A87
5A88
5A89
5A8A
5A8C
5A8D
5A8E
5A8F
5A91
5A94
5A95
5A97
5A98
5A9D
5AA1
5AA3
5AA4
5AA5
5AA6
5AA8
5AA9
5AAA
5AAB
5AAD
5AAE
5AAF
5AB0
5AB4
5AB6
5AB7
5AB9
5AC0
5AC3
5AC5
5AC7
5ACA
5ACD
5ACE
5AD1
5AD2
5AD3
5AD4
5AD5
5AD8
5AD9
5ADB
5ADD
5ADE
5ADF
5AE2
5AE4
5AE7
5AE8
5AEB
5AEC
5AED
5AEF
5AF0
5AF1
5AF2
5AF3
5AF4
5AF7
5AF8
5AF9
5AFC
5AFE
5AFF
5B02
5B03
5B04
5B05
5B06
5B07
5B0A
5B0D
5B0E
5B0F
5B10
5B11
5B12
5B13
5B14
5B15
5B18
5B1A
5B1C
5B1E
5B1F
5B20
5B23
5B24
5B26
5B27
5B28
5B29
5B2B
5B2E
5B2F
5B31
5B33
5B35
5B37
5B39
5B3A
5B3B
5B3C
5B3D
5B3F
5B42
5B44
5B46
5B47
5B48
5B49
5B4A
5B4D
5B4E
5B4F
5B53
5B59
5B60
5B61
5B62
5B67
5B6A
5B6C
5B6D
5B72
5B74
5B76
5B77
5B79
5B7B
5B82
5B92
5B9E
5BA0
5BA1
5BA7
5BAA
5BAB
5BBB
5BBD
5BBE
5BC8
5BCA
5BCB
5BCE
5BD1
5BD5
5BDC
5BE3
5BEA
5BEC
5BED
5BF2
5BF7
5BF9
5BFB
5BFC
5C00
5C03
5C10
5C12
5C14
5C15
5C18
5C19
5C1B
5C1C
5C1D
5C21
5C25
5C27
5C2A
5C2F
5C33
5C34
5C37
5C42
5C43
5C44
5C47
5C49
5C4C
5C52
5C54
5C56
5C57
5C58
5C5B
5C5D
5C5F
5C66
5C6A
5C6B
5C72
5C73
5C77
5C78
5C7E
5C7F
5C80
5C81
5C82
5C83
5C84
5C85
5C86
5C89
5C8B
5C8D
5C8E
5C93
5C95
5C96
5C97
5C98
5C99
5C9A
5C9B
5C9C
5C9E
5CA4
5CA5
5CA7
5CAD
5CAE
5CAF
5CB0
5CB9
5CBD
5CBF
5CC0
5CC1
5CC2
5CC3
5CC4
5CC6
5CC8
5CCA
5CCC
5CCD
5CCE
5CCF
5CD0
5CD1
5CD3
5CD4
5CD5
5CD6
5CD8
5CDA
5CDB
5CDC
5CDE
5CDF
5CE2
5CE3
5CE4
5CE5
5CE6
5CE7
5CEB
5CEC
5CF3
5CF5
5CF7
5CF8
5CF9
5CFC
5CFE
5CFF
5D00
5D02
5D03
5D04
5D05
5D08
5D09
5D0A
5D0C
5D0F
5D10
5D13
5D1C
5D1D
5D1E
5D20
5D21
5D25
5D28
5D2A
5D2C
5D2D
5D2E
5D2F
5D30
5D32
5D33
5D35
5D36
5D37
5D38
5D3A
5D3B
5D3C
5D3E
5D40
5D41
5D44
5D45
5D47
5D49
5D4D
5D4F
5D53
5D54
5D56
5D57
5D58
5D5A
5D5B
5D5D
5D5E
5D63
5D65
5D66
5D67
5D68
5D6B
5D6E
5D71
5D72
5D74
5D75
5D77
5D78
5D7B
5D7C
5D7D
5D80
5D85
5D86
5D89
5D8D
5D8E
5D8F
5D91
5D96
5D97
5D98
5D9A
5D9C
5D9E
5DA1
5DA3
5DA4
5DA5
5DA6
5DA8
5DA9
5DAA
5DAD
5DAF
5DB1
5DB3
5DB5
5DB6
5DBB
5DBE
5DBF
5DC0
5DC1
5DC2
5DC4
5DC5
5DC6
5DC8
5DCA
5DCF
5DD1
5DD4
5DD5
5DD7
5DDA
5DDC
5DDF
5DE2
5DEA
5DEC
5DED
5DEF
5DF0
5DF6
5DFA
5DFC
5DFF
5E01
5E04
5E05
5E08
5E09
5E0A
5E0E
5E0F
5E10
5E13
5E17
5E1C
5E1E
5E21
5E22
5E23
5E24
5E26
5E27
5E29
5E2A
5E2C
5E31
5E34
5E39
5E3A
5E3B
5E3C
5E3F
5E41
5E42
5E46
5E48
5E4A
5E4D
5E4F
5E52
5E53
5E59
5E5A
5E5D
5E60
5E65
5E66
5E67
5E69
5E6F
5E71
5E77
5E82
5E85
5E86
5E88
5E89
5E8C
5E8D
5E90
5E91
5E92
5E93
5E94
5E98
5E99
5E9B
5E9D
5E9E
5E9F
5EA1
5EA3
5EA9
5EAE
5EAF
5EB0
5EB2
5EB4
5EB9
5EBA
5EBB
5EBC
5EC0
5EC4
5EC5
5EC7
5ECD
5ED7
5ED8
5ED9
5EE4
5EE6
5EE7
5EEA
5EED
5EEE
5EEF
5EF2
5EF5
5EF9
5EFD
5F00
5F05
5F12
5F1A
5F1E
5F20
5F2A
5F32
5F33
5F39
5F3A
5F42
5F43
5F46
5F49
5F4B
5F4F
5F52
5F55
5F5A
5F5E
5F5F
5F65
5F68
5F6E
5F76
5F7B
5F86
5F8E
5F94
5F95
5F9A
5F9B
5F9F
5FA3
5FA5
5FA6
5FB2
5FB5
5FB6
5FB7
5FBA
5FBB
5FBE
5FBF
5FC0
5FC1
5FC2
5FC6
5FCA
5FCE
5FCF
5FD5
5FDA
5FDB
5FDF
5FE3
5FE5
5FE6
5FE7
5FF4
5FF7
5FF9
5FFE
6000
6001
6002
6003
6004
6005
6006
6008
6009
600B
600C
6011
601E
6022
6023
602C
602E
6030
6032
6034
6036
6037
6038
6039
603B
603C
603D
603E
603F
6044
6045
604E
604F
6053
6058
605B
605C
605E
6066
606E
6072
6073
6074
6076
6078
6079
607A
607B
607C
607D
6080
6085
6087
608F
6090
6099
609C
60A1
60AB
60AC
60AD
60AE
60AF
60B9
60BA
60BF
60C0
60C1
60C3
60CC
60CD
60D0
60D2
60D6
60D7
60E4
60E6
60E9
60EA
60EB
60EC
60ED
60EE
60EF
60FE
60FF
6104
6105
610B
6118
611D
6120
6123
6124
6125
6126
6129
612D
612E
612F
6132
6133
6138
613A
613B
6140
6143
614F
6150
6151
6152
6154
6156
6157
615B
615C
6161
6164
6166
6169
616A
616D
6179
617A
617D
6185
6186
6188
6189
618C
618F
6195
619B
619E
61A1
61A2
61A3
61A6
61AF
61B0
61B1
61B3
61B4
61B5
61B7
61BB
61BD
61BF
61C4
61C5
61D1
61D2
61D3
61D4
61D6
61D7
61D8
61D9
61DA
61DB
61E0
61E4
61E8
61EA
61EB
61EE
61F0
61F1
61F3
61F5
61F9
61FB
6202
6205
6206
620B
620F
6217
6218
6219
6224
6225
6228
622C
622D
6231
6235
6236
6237
623A
623C
623E
6245
624A
624F
6257
6259
625D
625F
6261
6262
6265
6266
6267
6269
626A
626B
626C
6270
6272
6274
6275
6277
6278
627B
6281
6285
6286
6287
6288
628B
628C
6299
629A
629D
629F
62A0
62A1
62A2
62A3
62A4
62A5
62A7
62A9
62AA
62AD
62AE
62AF
62B0
62B2
62B4
62B8
62C0
62C1
62C3
62CB
62DE
62DF
62E2
62E3
62E4
62E5
62E6
62E7
62E8
62E9
62EB
62F0
62F8
62F9
62FA
62FB
6300
6305
6306
630E
630F
6312
6314
6315
6317
631A
631B
631C
631D
631E
6320
6321
6322
6323
6324
6325
6326
632C
632E
6330
6331
6332
6333
6334
6337
6338
633B
6340
6345
6347
6348
6351
6356
6359
635A
635D
635E
635F
6360
6361
6362
6363
6364
636A
636F
6370
6373
6379
637E
6381
6385
6386
638B
638D
6391
6393
6397
639C
639D
63B0
63B1
63B3
63B6
63B7
63B8
63B9
63BA
63BC
63BF
63C2
63C7
63CA
63CB
63CC
63CD
63D7
63D8
63D9
63DD
63DE
63DF
63E2
63E4
63E6
63E7
63E8
63EB
63ED
63EF
63F0
63F1
63F7
63FB
63FC
63FD
63FE
63FF
6400
6401
6402
6403
6404
6405
6407
6408
640B
640C
640E
6411
6415
6419
641A
641B
641D
641F
6421
6423
6427
642B
642E
6431
6432
6433
6437
6438
6439
643B
643C
6440
6441
6443
6444
6445
6446
6447
6448
6449
644A
644C
644D
6450
6455
6456
6457
6459
645E
6462
6464
6465
6466
6468
646A
646B
646C
646E
6470
6471
6472
6475
6477
6479
647C
647E
647F
6480
6481
6482
6484
6486
6489
648A
648B
648C
648D
648E
6494
6496
6497
649C
64A0
64A2
64A7
64AA
64AF
64B1
64B4
64B5
64B6
64B7
64B8
64BA
64C0
64C3
64C6
64C8
64CF
64D3
64D6
64D9
64DB
64DC
64DD
64DE
64DF
64E8
64EB
64EE
64F3
64F8
64F9
64FC
6502
6503
6506
6507
650B
650C
650D
650E
6510
6511
6512
6515
6517
651A
6520
6521
6525
6527
6528
652D
6530
6532
6533
6540
6541
6542
6544
6546
654A
654B
654C
654E
6553
655A
655B
655C
6561
6564
6565
6568
6569
656A
656D
656E
656F
6571
6573
6576
6579
657B
657C
657E
657F
6580
6584
6586
658B
658D
658F
6593
6594
6596
659A
659E
65A2
65A8
65A9
65AA
65B1
65B5
65B6
65B8
65BA
65BB
65BE
65C0
65C7
65CA
65CD
65D1
65D3
65D5
65DA
65DC
65DD
65DE
65E3
65E4
65EA
65EB
65EE
65EF
65F3
65F6
65F7
65F8
65FC
65FD
6601
6605
660B
6610
6617
6618
6619
661A
661B
6632
6638
663A
663B
663D
663E
6647
6648
664D
6650
6653
6654
6655
6656
665A
6663
6665
666D
6671
6672
667D
6682
6685
6686
668A
668F
6693
6694
6695
669E
66A1
66A3
66A5
66A7
66A8
66A9
66AA
66AC
66AF
66B0
66B3
66B6
66B7
66BA
66BD
66C5
66C6
66CA
66CB
66CD
66D0
66D1
66D2
66D3
66D5
66D7
66D8
66DE
66E1
66E2
66E3
66E4
66E5
66E7
66EA
66ED
66EF
66F1
66F6
6701
6702
6704
6706
670A
670C
6710
6711
6712
6718
671A
6721
6723
6724
6725
6729
672F
6730
6732
6735
6739
673B
673C
6740
6742
6743
6744
674A
674B
674D
6752
6757
6758
675A
675B
6767
6768
6769
676B
6778
6779
677A
677D
6780
6782
6783
6786
6788
678A
678D
6792
6794
679E
679F
67A3
67A4
67A5
67A7
67A8
67AA
67AB
67AC
67AD
67AE
67BA
67BE
67BF
67C7
67CB
67CC
67CD
67D5
67D6
67DB
67DF
67E0
67E3
67E5
67E8
67EA
67EB
67ED
67F8
67FA
67FC
67FD
6800
6801
6805
6806
6807
6808
6809
680A
680B
680C
680D
680E
680F
6810
6811
6812
6815
6818
681A
681B
681C
6820
6823
6824
6825
6826
682E
6835
6836
6837
683A
683E
6847
6849
684B
684F
6856
685A
685E
6860
6861
6862
6864
6865
6866
6868
6869
686A
686C
686D
6873
6878
687D
6880
6887
6889
688A
688B
688C
688E
6890
6891
6892
6895
6899
689E
68A4
68AB
68AC
68B4
68B7
68B8
68BD
68BE
68BF
68C0
68C1
68C2
68C3
68C7
68CE
68DB
68DE
68E2
68E4
68E6
68E9
68F3
68F4
68F7
68F8
68FE
68FF
6902
6903
6907
6914
6915
6918
691D
691E
691F
6920
6924
6927
6929
692B
692C
692D
692E
692F
6932
6937
693A
693C
693E
6940
6941
6943
6944
6946
6947
6948
694B
694C
694D
694F
6950
6951
6952
6956
6958
695F
6967
6976
6983
6984
6985
6986
6987
6988
6989
698B
698C
698F
6990
6993
6997
6999
699A
699D
699E
699F
69A2
69A3
69A4
69A9
69AA
69AC
69B0
69B3
69B5
69B6
69B9
69BD
69C0
69C2
69C4
69C6
69C9
69CF
69D2
69D4
69D5
69DA
69DB
69DC
69DF
69E0
69E1
69E3
69E4
69E6
69E9
69EA
69EC
69F0
69F4
69F6
69F7
69F8
69FA
69FC
6A04
6A06
6A07
6A08
6A09
6A0D
6A0E
6A10
6A16
6A18
6A1C
6A25
6A26
6A27
6A2C
6A2D
6A2F
6A31
6A33
6A3C
6A40
6A41
6A42
6A43
6A4C
6A4D
6A4F
6A53
6A54
6A57
6A5A
6A5C
6A5D
6A5E
6A60
6A63
6A65
6A68
6A69
6A6B
6A6C
6A6D
6A6E
6A6F
6A70
6A74
6A75
6A76
6A77
6A79
6A7A
6A7B
6A7C
6A7D
6A82
6A85
6A88
6A8A
6A8C
6A8F
6A92
6A93
6A94
6A95
6A96
6A98
6A99
6A9A
6AA1
6AA4
6AA6
6AA7
6AA8
6AA9
6AAD
6AB2
6AB5
6AB6
6AB7
6AB9
6ABA
6ABC
6AC0
6AC4
6AC5
6AC7
6ACA
6ACB
6ACD
6ACE
6ACF
6AD2
6AD7
6AD8
6AD9
6AE0
6AE1
6AE2
6AE3
6AE5
6AE6
6AE9
6AEB
6AED
6AEE
6AEF
6AF3
6AF4
6AF5
6AF6
6AF7
6AF8
6AF9
6AFE
6AFF
6B00
6B01
6B08
6B0B
6B0C
6B0D
6B0E
6B13
6B14
6B15
6B18
6B19
6B1A
6B1C
6B22
6B25
6B26
6B29
6B2A
6B2D
6B2E
6B30
6B31
6B33
6B34
6B3C
6B40
6B41
6B42
6B44
6B45
6B48
6B4B
6B4F
6B51
6B55
6B57
6B5A
6B5C
6B5E
6B65
6B68
6B6C
6B6D
6B71
6B72
6B76
6B77
6B7A
6B7C
6B81
6B87
6B88
6B8C
6B8E
6B8F
6B90
6B91
6B92
6B93
6B94
6B99
6B9A
6B9C
6B9D
6BA1
6BA5
6BA6
6BA7
6BB6
6BC1
6BC2
6BC7
6BC8
6BCA
6BCF
6BD0
6BD1
6BD5
6BD7
6BD9
6BDC
6BDD
6BDE
6BE0
6BE2
6BE4
6BE5
6BE8
6BE9
6BEA
6BED
6BF0
6BF2
6BF4
6BF5
6BF6
6BF8
6BFA
6BFB
6BFC
6BFD
6BFE
6C00
6C01
6C03
6C06
6C07
6C0A
6C0B
6C0C
6C15
6C16
6C18
6C1A
6C1C
6C1D
6C1E
6C20
6C21
6C22
6C25
6C29
6C2A
6C2B
6C2D
6C2F
6C30
6C31
6C32
6C39
6C3C
6C3D
6C43
6C44
6C45
6C46
6C47
6C48
6C49
6C4C
6C51
6C53
6C56
6C58
6C61
6C63
6C64
6C65
6C66
6C69
6C6C
6C6E
6C71
6C75
6C77
6C7C
6C7F
6C80
6C84
6C8A
6C8B
6C8E
6C8F
6C91
6C9D
6C9E
6CA0
6CA3
6CA4
6CA5
6CA6
6CA7
6CA8
6CA9
6CAA
6CAC
6CAD
6CAF
6CB5
6CB6
6CB7
6CC0
6CC3
6CC7
6CC8
6CCB
6CCE
6CD8
6CDE
6CDF
6CE4
6CE6
6CED
6CF5
6CF6
6CF7
6CF8
6CF9
6CFA
6CFB
6CFC
6CFD
6CFE
6CFF
6D00
6D01
6D02
6D03
6D05
6D06
6D08
6D09
6D0D
6D10
6D14
6D15
6D16
6D18
6D1C
6D1D
6D20
6D21
6D22
6D23
6D24
6D2C
6D2D
6D30
6D34
6D37
6D3A
6D40
6D42
6D43
6D46
6D47
6D48
6D49
6D4A
6D4B
6D4C
6D4D
6D4E
6D4F
6D50
6D51
6D52
6D53
6D54
6D55
6D56
6D58
6D5B
6D5D
6D60
6D62
6D68
6D6B
6D6D
6D71
6D72
6D73
6D75
6D76
6D7A
6D7B
6D7D
6D7E
6D7F
6D80
6D81
6D83
6D84
6D86
6D89
6D8A
6D8B
6D8D
6D8F
6D90
6D9A
6D9D
6D9E
6D9F
6DA0
6DA1
6DA2
6DA3
6DA4
6DA5
6DA6
6DA7
6DA8
6DA9
6DAB
6DAD
6DAE
6DB0
6DB1
6DB3
6DB6
6DBA
6DBB
6DBE
6DC1
6DC2
6DC3
6DC9
6DCD
6DD0
6DD3
6DD4
6DD7
6DDA
6DDC
6DE3
6DE7
6DED
6DF2
6DF8
6DFD
6DFE
6DFF
6E01
6E02
6E03
6E06
6E0C
6E0D
6E0E
6E0F
6E10
6E11
6E12
6E14
6E16
6E17
6E18
6E1C
6E28
6E2A
6E30
6E31
6E33
6E34
6E35
6E37
6E3D
6E3F
6E40
6E41
6E42
6E46
6E47
6E4C
6E50
6E55
6E59
6E5A
6E60
6E61
6E64
6E65
6E66
6E69
6E6A
6E6C
6E6D
6E70
6E71
6E74
6E75
6E77
6E78
6E79
6E7A
6E7C
6E81
6E83
6E84
6E85
6E86
6E87
6E88
6E89
6E8A
6E8B
6E8E
6E91
6E92
6E94
6E95
6E97
6E9A
6E9B
6E9E
6EA1
6EA3
6EA4
6EA6
6EA8
6EA9
6EAB
6EAC
6EB0
6EB4
6EB5
6EB8
6EB9
6EBC
6EBE
6EC6
6ED0
6ED2
6ED6
6ED7
6ED8
6ED9
6EDA
6EDB
6EDC
6EDF
6EE0
6EE1
6EE2
6EE3
6EE4
6EE5
6EE6
6EE7
6EE8
6EE9
6EEA
6EF0
6EF1
6EF3
6EF5
6EF6
6EFA
6EFC
6F00
6F03
6F05
6F07
6F0B
6F0E
6F10
6F12
6F17
6F19
6F1C
6F1D
6F1E
6F1F
6F21
6F24
6F25
6F27
6F28
6F2E
6F34
6F35
6F37
6F39
6F3A
6F3D
6F40
6F42
6F43
6F44
6F46
6F47
6F48
6F49
6F4A
6F4B
6F4C
6F4D
6F4E
6F50
6F55
6F56
6F60
6F63
6F65
6F67
6F69
6F6A
6F6B
6F71
6F72
6F73
6F75
6F76
6F77
6F79
6F7B
6F7F
6F85
6F89
6F8A
6F8F
6F95
6F98
6F99
6F9B
6F9C
6F9D
6F9E
6FA2
6FA9
6FAB
6FAC
6FAD
6FB2
6FB4
6FB7
6FB8
6FBA
6FBB
6FBD
6FBE
6FBF
6FC4
6FC9
6FCB
6FCC
6FCD
6FCE
6FCF
6FD0
6FD1
6FD2
6FD3
6FD6
6FD7
6FD9
6FDC
6FDD
6FE2
6FE3
6FE5
6FE6
6FE7
6FEA
6FED
6FF2
6FF4
6FF7
6FF8
6FFB
6FFF
7002
7003
7004
7008
700A
700C
700E
7010
7012
7013
7014
7016
7019
701C
7021
7022
7024
7025
7028
7029
702A
702B
702D
702E
7031
7033
7035
7036
7038
703A
703B
703D
703F
7040
7041
7042
7045
7046
7047
704D
704F
7050
7052
7053
7056
7057
7059
705A
705B
705C
705F
7060
7061
7062
7066
7067
7068
7069
706A
706D
7071
7072
7073
7074
7077
7079
707A
707B
707F
7080
7082
7083
7084
7087
7088
708B
708C
708D
708F
7090
7091
7093
709A
709C
709D
709E
709F
70A0
70A1
70A2
70A3
70A5
70A6
70A7
70A8
70A9
70AA
70B2
70B5
70B6
70BB
70BC
70BD
70BE
70BF
70C0
70C1
70C2
70C3
70C4
70C5
70C6
70C7
70C9
70CC
70CD
70CE
70D0
70D2
70D7
70DA
70DB
70DE
70E0
70E1
70E2
70E3
70E5
70E6
70E7
70E8
70E9
70EA
70EB
70EC
70ED
70EE
70EF
70F0
70F2
70F3
70F4
70F5
70F6
70F7
70F8
70FB
70FC
70FE
70FF
7100
7101
7102
7108
710A
710D
710E
7110
7111
7112
7113
7115
7116
7117
7118
711B
711D
711F
7122
7123
7124
7125
7127
7128
7129
712A
712C
712E
7132
7133
7134
7135
7137
7139
713A
713B
713D
713E
713F
7140
7142
7143
7144
7148
714D
714F
7151
7153
7154
7158
715B
715D
715F
7161
7163
716A
716B
716D
716F
7170
7171
7172
7173
7174
7175
7176
7177
7178
717A
717B
717C
717E
717F
7181
7182
7183
7186
7189
718B
718D
718E
7190
7191
7193
7196
7197
7198
719C
719D
719E
71A1
71A3
71A4
71A5
71A6
71A7
71A9
71AA
71AB
71AD
71AE
71B4
71B5
71B6
71B7
71B8
71BB
71BC
71BD
71C2
71C5
71C6
71C7
71CA
71CD
71CF
71D1
71D8
71DB
71DD
71DE
71E1
71E2
71E3
71E4
71E8
71E9
71EA
71EB
71EF
71F0
71F1
71F2
71F3
71F4
71F6
71F7
71FA
71FD
7201
7202
7203
7204
7205
720A
720B
720C
720E
720F
7211
7212
7214
7215
7216
7218
7219
721C
721E
7220
7221
7222
7223
7225
7226
7227
7229
722E
7231
7233
7237
7244
7249
724A
724D
7251
7254
7257
7264
7265
7266
726A
726C
726D
7270
7273
7275
7276
727A
7283
7285
7286
7288
728A
728B
728C
728F
7290
7291
7294
7295
7297
7298
7299
729A
729C
729D
729E
729F
72A1
72A3
72A4
72A5
72A6
72A9
72AA
72AB
72B0
72B3
72B5
72B7
72B8
72BA
72BB
72BC
72BD
72BF
72C0
72C5
72C8
72CA
72CB
72CD
72CF
72D1
72D3
72D4
72DA
72DC
72DD
72DE
72E3
72E4
72E6
72E7
72E8
72EA
72EB
72EE
72EF
72F0
72F1
72F2
72F5
72F6
72FF
7300
7301
7303
7306
7308
7309
730C
730E
730F
7310
7311
7314
7315
731A
7320
7321
7323
7326
732D
7330
7333
7338
7339
733C
7340
7341
7342
7346
7347
7348
7349
734A
734B
734C
7351
7353
7354
7355
7359
735A
735B
735C
7361
7362
7364
7365
736D
7373
7374
7376
737D
737E
737F
7382
7388
738A
738C
738D
738F
7391
7392
7394
7399
739A
739B
739D
73A1
73A3
73A4
73A7
73A8
73AC
73AE
73AF
73B0
73B1
73B4
73B6
73B8
73BA
73BE
73C1
73C3
73C4
73C7
73D0
73D1
73D4
73D5
73D7
73D8
73DA
73DB
73DC
73DF
73E2
73E4
73E8
73EB
73EC
73EF
73F0
73F2
73F3
73F6
73FC
7402
7408
740B
740C
740D
740E
740F
7410
7412
7413
7414
7415
7416
7417
7418
7419
741C
741D
741E
741F
7420
7421
7423
7427
7437
7438
743B
743C
743D
743E
7442
7445
7448
7449
744A
744C
744E
744F
7450
7453
7454
7456
7458
7461
7465
746C
7474
7475
7477
7478
7479
747A
747B
747C
747D
747F
7482
7484
7488
748A
748C
748D
748E
7493
7494
7495
7496
7497
749B
749D
74A4
74A5
74AC
74AD
74B3
74B4
74B6
74B7
74B8
74BA
74BC
74BE
74C0
74C1
74C2
74C3
74C4
74C5
74C6
74C7
74CB
74CD
74CE
74D1
74D2
74D5
74D6
74D7
74D9
74DD
74E1
74E5
74EC
74ED
74F3
74F5
74F9
74FD
74FE
7500
7501
7502
7507
7508
7509
750A
750B
750F
7510
7514
7519
751B
751D
7522
752D
752E
7534
7535
7541
7542
7545
7553
7555
7556
7558
7563
7568
756C
756E
7572
7575
7580
7583
7584
7588
758C
758D
7596
7597
7598
759B
759E
759F
75A0
75A1
75A6
75A7
75A8
75A9
75AA
75AC
75AD
75AE
75AF
75B0
75B6
75B7
75BB
75C8
75C9
75CB
75D0
75D1
75D3
75D6
75DA
75DD
75E5
75E6
75E8
75EA
75EB
75ED
75F5
75F6
75F7
75F8
75FB
75FD
7605
7606
760E
7610
7611
7614
7617
7618
761A
7628
762A
762B
762C
762E
762F
7631
7636
7637
763D
763E
763F
764D
764E
764F
7650
7651
7653
7654
7657
765A
765B
765D
765E
7660
7663
7666
766B
7673
7675
7677
7679
767F
7682
7689
768A
768F
7691
7692
7694
7697
7698
769E
76A1
76A9
76AB
76AC
76AF
76B1
76B2
76B3
76B5
76B6
76BB
76BC
76BE
76C0
76C4
76C7
76CF
76D0
76D1
76D3
76D5
76D8
76DA
76DD
76E2
76E9
76EB
76ED
76EF
76F3
76F5
76F7
76FA
76FD
76FF
7702
7703
7705
770D
770F
7710
7711
7713
7716
7718
771D
7721
7723
7727
772A
772B
772C
7730
7731
7732
7733
773B
773F
7741
7743
7744
7748
7749
774B
774C
7750
7751
7753
7754
7755
7758
7759
775D
7769
776D
776E
776F
7771
7775
7776
7777
7778
777B
777C
7781
7782
7783
7785
7786
7787
7788
7789
778A
778F
7790
7792
7793
7797
7798
7799
779B
779C
779D
77A1
77A3
77A4
77A6
77A8
77A9
77AB
77B2
77B4
77B7
77B8
77BA
77C0
77C1
77C2
77C4
77C5
77C6
77C8
77CA
77CB
77CC
77CE
77CF
77D0
77D3
77D4
77D6
77D8
77DD
77E1
77E8
77EB
77F2
77F5
77F6
77F7
77F9
77FA
77FD
77FE
77FF
7800
7801
7803
7804
7807
7808
780A
780B
780F
7810
7813
7816
7817
7818
7819
781A
781B
781C
781E
781F
7824
7828
7829
782A
782B
782C
782F
7831
7833
7836
7838
7839
783B
783C
783D
783E
7840
7841
7842
7846
7849
784A
784B
784D
784F
7850
7851
7853
7854
7855
7856
7857
7858
7859
785A
785B
785F
7862
7865
7866
7867
7869
786D
7870
7871
7873
7875
7876
7877
7878
7879
787B
787D
787F
7880
7882
7883
7884
7885
7888
7889
788B
7890
7892
7896
7899
789B
789C
78A0
78A2
78A5
78A6
78AB
78AE
78B4
78B6
78B7
78B8
78B9
78C0
78C2
78C3
78C4
78CD
78CF
78D7
78D8
78D9
78DC
78DD
78DE
78E2
78E3
78E5
78E9
78EB
78ED
78EE
78F0
78F1
78F5
78F8
78F9
78FC
78FE
7902
7903
7904
7905
7908
7909
790A
790B
790D
790F
7913
7914
7915
7916
7917
7918
791B
791D
7921
7922
7923
7924
7928
792E
792F
7930
7932
7933
7936
7937
7938
7939
7942
7943
794C
794D
794E
7952
7959
7961
7963
7964
7966
796A
796C
796E
796F
7970
7971
7973
7974
7975
7976
7978
797D
7982
7983
7986
7987
7988
7989
7990
7992
7997
7999
799A
799E
799F
79A0
79A2
79A3
79A4
79A5
79AC
79AD
79B2
79B5
79B6
79B7
79BC
79C3
79C5
79C6
79CC
79CD
79CE
79D0
79D3
79D7
79D9
79DB
79DC
79E8
79EE
79EF
79F2
79F3
79F4
79F5
79F6
79F7
79F9
79FA
79FD
79FE
79FF
7A01
7A04
7A05
7A06
7A0F
7A10
7A12
7A13
7A16
7A1D
7A22
7A23
7A24
7A25
7A26
7A28
7A29
7A2A
7A2C
7A33
7A36
7A41
7A4A
7A4B
7A51
7A52
7A53
7A54
7A58
7A5A
7A5B
7A5E
7A64
7A66
7A68
7A6C
7A6E
7A6F
7A71
7A72
7A73
7A77
7A7B
7A7C
7A87
7A89
7A8C
7A8D
7A8E
7A8F
7A99
7A9A
7A9B
7A9C
7A9D
7AA1
7AA2
7AA4
7AA5
7AA6
7AA7
7AA8
7AAB
7AAD
7AB1
7AB2
7AB4
7AB7
7AB8
7ABD
7ABE
7AC0
7AC1
7AC2
7AD0
7AD4
7AD6
7AD7
7AD8
7ADE
7AE4
7AE7
7AEE
7AF2
7AF3
7AF5
7AF7
7AFC
7B00
7B01
7B03
7B05
7B09
7B0C
7B0D
7B0E
7B10
7B12
7B13
7B15
7B16
7B17
7B1A
7B1C
7B1D
7B21
7B22
7B24
7B32
7B37
7B38
7B3A
7B3B
7B3C
7B3E
7B42
7B43
7B44
7B4A
7B53
7B57
7B58
7B59
7B5A
7B5B
7B5C
7B5E
7B5F
7B61
7B62
7B63
7B68
7B6B
7B76
7B78
7B79
7B7B
7B7C
7B7D
7B7E
7B7F
7B80
7B81
7B82
7B83
7B85
7B88
7B8A
7B8C
7B93
7BA2
7BA3
7BA4
7BA6
7BA7
7BA8
7BA9
7BAB
7BAE
7BB3
7BB7
7BB9
7BBE
7BBF
7BC3
7BCD
7BCE
7BD0
7BD1
7BD2
7BD3
7BD5
7BD8
7BDC
7BDE
7BDF
7BE1
7BE2
7BE3
7BE7
7BEB
7BEC
7BEE
7BEF
7BF0
7BF1
7BFB
7BFD
7BFF
7C05
7C08
7C0A
7C10
7C15
7C16
7C18
7C1A
7C1C
7C1D
7C1E
7C22
7C24
7C29
7C2D
7C2E
7C2F
7C30
7C32
7C35
7C3B
7C3C
7C41
7C42
7C44
7C45
7C47
7C48
7C49
7C4B
7C4E
7C57
7C62
7C66
7C68
7C6A
7C6B
7C6F
7C71
7C74
7C76
7C77
7C78
7C7A
7C7B
7C7F
7C80
7C84
7C85
7C88
7C8A
7C8C
7C8E
7C91
7C93
7C96
7C99
7C9A
7C9C
7C9D
7CA3
7CA9
7CAA
7CAC
7CAF
7CB4
7CB5
7CB8
7CC1
7CC3
7CC6
7CCB
7CCC
7CD0
7CD1
7CDB
7CE1
7CE3
7CE4
7CE5
7CE8
7CEA
7CEC
7CED
7CEE
7CF0
7CF1
7CF3
7CF7
7CF9
7CFC
7CFD
7CFF
7D01
7D0C
7D0E
7D1F
7D24
7D25
7D27
7D28
7D29
7D34
7D36
7D37
7D38
7D3B
7D49
7D4A
7D52
7D54
7D55
7D58
7D5F
7D60
7D64
7D69
7D6B
7D6C
7D6D
7D6F
7D74
7D77
7D7C
7D7E
7D80
7D84
7D87
7D8A
7D8E
7D90
7D92
7D94
7D95
7D98
7DA0
7DA1
7DA4
7DA5
7DA8
7DA9
7DBC
7DC0
7DC1
7DC8
7DC9
7DD0
7DD3
7DD4
7DD6
7DDB
7DDF
7DE3
7DE7
7DEE
7DF0
7DF3
7DF7
7DF8
7DFC
7DFD
7DFE
7DFF
7E02
7E03
7E06
7E07
7E0C
7E0D
7E0E
7E0F
7E13
7E14
7E16
7E18
7E19
7E1A
7E24
7E25
7E29
7E2A
7E30
7E34
7E38
7E3C
7E40
7E42
7E48
7E49
7E4C
7E4F
7E51
7E53
7E57
7E5B
7E5C
7E60
7E63
7E64
7E68
7E6C
7E71
7E72
7E74
7E75
7E76
7E77
7E7A
7E80
7E84
7E85
7E8B
7E97
7E99
7E9F
7EA0
7EA1
7EA2
7EA3
7EA4
7EA5
7EA6
7EA7
7EA8
7EA9
7EAA
7EAB
7EAC
7EAD
7EAE
7EAF
7EB0
7EB1
7EB2
7EB3
7EB4
7EB5
7EB6
7EB7
7EB8
7EB9
7EBA
7EBB
7EBC
7EBD
7EBE
7EBF
7EC0
7EC1
7EC2
7EC3
7EC4
7EC5
7EC6
7EC7
7EC8
7EC9
7ECA
7ECB
7ECC
7ECD
7ECE
7ECF
7ED0
7ED1
7ED2
7ED3
7ED4
7ED5
7ED6
7ED7
7ED8
7ED9
7EDA
7EDB
7EDC
7EDD
7EDE
7EDF
7EE0
7EE1
7EE2
7EE3
7EE4
7EE5
7EE6
7EE7
7EE8
7EE9
7EEA
7EEB
7EEC
7EED
7EEE
7EEF
7EF0
7EF1
7EF2
7EF3
7EF4
7EF5
7EF6
7EF7
7EF8
7EF9
7EFA
7EFB
7EFC
7EFD
7EFE
7EFF
7F00
7F01
7F02
7F03
7F04
7F05
7F06
7F07
7F08
7F09
7F0A
7F0B
7F0C
7F0D
7F0E
7F0F
7F10
7F11
7F12
7F13
7F14
7F15
7F16
7F17
7F18
7F19
7F1A
7F1B
7F1C
7F1D
7F1E
7F1F
7F20
7F21
7F22
7F23
7F24
7F25
7F26
7F27
7F28
7F29
7F2A
7F2B
7F2C
7F2D
7F2E
7F2F
7F30
7F31
7F32
7F33
7F34
7F35
7F37
7F39
7F40
7F41
7F42
7F46
7F48
7F49
7F4A
7F4B
7F56
7F57
7F59
7F5A
7F5E
7F62
7F6C
7F6F
7F73
7F74
7F76
7F7A
7F7B
7F7C
7F81
7F84
7F89
7F92
7F93
7F95
7F98
7F99
7F9B
7F9F
7FA0
7FA5
7FA7
7FAB
7FAC
7FB0
7FB1
7FB3
7FB5
7FB7
7FBA
7FBB
7FBE
7FC2
7FC4
7FC7
7FC9
7FCB
7FCD
7FD0
7FD1
7FD3
7FD6
7FD7
7FD8
7FD9
7FDA
7FDC
7FDD
7FDE
7FE2
7FE4
7FE7
7FEA
7FED
7FF1
7FF4
7FF5
7FF6
7FF7
7FF8
8002
8009
801A
801B
8022
8023
8025
8027
8029
802A
802B
802D
802F
8031
8032
8038
8041
8042
8043
8045
8047
8048
8049
804B
804C
804D
804E
804F
8050
8051
8053
8054
8055
8057
8059
805B
805C
805D
8063
8065
8067
8069
806A
806B
806C
806E
8078
807A
807B
807C
8080
8082
8083
808A
808D
808F
8090
8091
8092
8094
8095
8097
8099
809F
80A0
80A3
80A4
80A8
80AE
80B0
80B3
80B5
80B6
80B7
80BB
80BC
80BD
80BE
80BF
80C0
80C1
80C2
80C5
80C7
80C9
80CA
80CB
80D0
80D1
80D3
80DC
80DF
80E2
80E3
80E6
80E7
80E8
80E9
80EA
80EB
80EC
80F5
80F7
80FB
80FF
8100
8101
8104
810C
810D
810E
810F
8110
8111
8112
8113
8114
8115
8119
811D
811F
8121
8122
8125
8126
8128
812A
812B
812D
812E
8132
8134
8136
8137
8138
813B
813D
813F
8140
8141
8142
8143
8144
8148
8149
814D
814F
8156
8158
8159
815A
815B
815C
815D
815E
8162
8163
8164
816A
816C
8172
8173
8175
8176
817B
817C
817D
817E
8187
8189
818C
818D
8191
8192
8194
8197
8199
819F
81A1
81A5
81A6
81A7
81AA
81AB
81AC
81AD
81AF
81B1
81B6
81B7
81B9
81BC
81C1
81C4
81C7
81CC
81D0
81D2
81D4
81D6
81DC
81E2
81E6
81E9
81EE
81EF
81F7
8204
8206
820B
8211
8215
8220
8223
8224
8225
8226
8227
822D
822F
8230
8231
823B
823C
823D
823E
823F
8241
8242
8248
8249
824A
824C
824D
8250
8252
8253
8254
8255
8257
825B
825E
8261
8265
8269
826C
8270
8273
8275
8279
827A
827C
8282
8285
8286
8288
828C
828F
8290
8293
8295
8297
829C
829E
82A2
82B5
82B6
82C0
82C1
82C2
82C3
82C4
82C7
82C8
82C9
82CA
82CB
82CC
82CD
82CE
82CF
82D6
82D8
82DD
82E9
82EC
82EE
82F0
82F2
82F5
82F8
82FC
82FF
830C
830D
830F
8310
8311
8312
8313
8314
8315
8319
831A
8320
8324
8325
8326
8327
8329
832A
833B
833E
833F
8341
8346
8348
834B
834C
8359
835A
835B
835C
835D
835E
835F
8360
8361
8362
8363
8364
8365
8366
8367
8368
8369
836A
836B
836C
836D
836E
836F
8371
8372
8374
8376
8379
837A
837E
8381
8383
8388
838B
838C
838F
8390
8391
8397
83A1
83A3
83A4
83A5
83AE
83AF
83B0
83B2
83B3
83B4
83B6
83B7
83B8
83B9
83BA
83BB
83BC
83C2
83C3
83C4
83C6
83C8
83CB
83CD
83D2
83D5
83D7
83D9
83DA
83DB
83DE
83E1
83E2
83E3
83E4
83E5
83E6
83E7
83EC
83ED
83EE
83F3
83F5
83FA
83FE
83FF
8400
8402
8405
8408
8409
8410
8412
8414
8416
8417
8418
841A
841B
841C
841D
841E
841F
8421
8423
8424
8425
8426
8427
8428
842B
842D
842E
8430
8432
8433
8434
8436
8437
843A
843B
843E
843F
8440
8441
8442
8443
8444
844B
844C
8450
8453
8454
8455
845D
845E
845F
8468
8472
847B
847E
847F
8480
8483
8486
8487
8488
8489
848A
848C
848D
848E
848F
8491
8496
8497
8498
849A
849B
849D
84A0
84A2
84A3
84A4
84A5
84A7
84AB
84AC
84AE
84B0
84B3
84B5
84B6
84B7
84C3
84C5
84CE
84D2
84D4
84D5
84D7
84D8
84DB
84DD
84DE
84DF
84E0
84E1
84E2
84E3
84E4
84E5
84E6
84E8
84E9
84EB
84ED
84F3
84F5
84F6
84F8
84F9
84FE
8501
8504
8505
8508
8509
850A
850B
850D
850F
8512
8516
8519
851B
851D
8520
8528
8529
852E
8530
8531
8537
8538
8539
853A
853B
853C
853E
8542
8544
8545
8547
854C
854D
8554
855B
8565
8566
8567
856C
856E
8570
8571
8572
8573
8574
8575
8576
8578
857C
8582
8583
858D
858E
8592
8595
8596
859A
859E
85A1
85A3
85B0
85B1
85B2
85B3
85B5
85BB
85C0
85C3
85C4
85C5
85C6
85C8
85CC
85D1
85D2
85D3
85D4
85D6
85D7
85D9
85DB
85DE
85E1
85E2
85E3
85E7
85EB
85EC
85EE
85EF
85F0
85F1
85F2
85F4
85F5
85F8
85FD
8601
8603
8608
8609
860C
860F
8614
8615
861C
861D
861F
8620
8623
8624
8625
8626
8628
862A
862B
862C
862E
8631
8632
8633
8634
8635
8637
8639
863B
863E
8643
8644
8645
8647
8648
8649
864A
864B
864C
864F
8651
865B
8665
8666
8668
866A
866D
866E
8670
8672
8673
8674
8678
867C
867D
867E
867F
8680
8681
8682
8683
8684
8685
8686
8687
8689
868E
868F
8690
8692
8694
8697
8699
869B
869D
869E
869F
86A0
86A2
86A5
86AC
86AE
86B2
86BA
86BB
86BC
86BD
86BE
86C2
86C8
86CA
86CC
86CF
86D0
86D3
86D6
86D8
86DD
86E1
86E2
86E6
86E8
86EA
86EB
86F0
86F1
86F2
86F3
86F4
86F5
86F6
86F7
86FF
8701
870C
8715
8716
8717
871B
871D
8720
8722
8724
8726
8727
872A
872B
872C
872D
8730
8733
8735
8736
8738
8741
8742
8744
8746
8747
8748
874A
874F
8750
8751
8752
8754
8756
875A
875B
875C
875E
8762
8767
8769
876B
876C
876D
8770
8773
8775
8777
8779
877A
877C
877D
877E
8780
8781
878A
878E
878F
8791
8792
8794
8796
879A
879B
879C
879D
87A1
87A4
87A5
87A6
87A8
87A9
87AA
87B0
87B2
87B4
87B6
87B7
87B8
87B9
87BC
87C2
87C3
87C5
87CC
87CD
87CF
87D1
87D3
87D4
87D7
87D8
87DB
87DD
87DE
87E1
87E5
87E6
87E7
87E8
87E9
87EC
87EE
87F0
87F4
87F5
87FC
87FD
8800
8802
8804
8807
8808
880C
8817
881D
8820
8824
8825
8826
8829
882A
882B
882C
882F
8833
8834
8837
8838
883D
883E
883F
8847
884F
8850
8854
8865
8866
8867
886A
886C
886D
886E
886F
8873
8874
8876
8878
887A
887C
8883
8884
8885
8886
8887
8889
888A
888C
888E
888F
8890
8891
8893
8894
8895
889D
88A1
88A3
88A5
88A6
88A7
88A9
88AC
88AD
88AF
88B2
88B3
88B6
88B8
88B9
88BB
88BC
88C6
88C7
88C8
88C9
88D0
88D6
88D7
88DA
88E0
88E2
88E3
88E4
88E5
88E6
88E9
88EA
88EB
88EC
88ED
88EE
88F6
88FA
88FB
88FF
8900
8903
8905
8908
8909
890B
8911
8914
8917
891B
891F
8921
8922
8923
8924
8929
892C
892D
892E
892F
8933
8934
8937
893C
893D
893F
8947
8948
894A
894B
894E
8950
8951
8953
8954
8955
8958
8959
895D
8965
8967
8968
8969
896C
8971
8976
8978
8979
8980
8982
8984
8985
898C
898E
8991
8992
8999
899D
899E
89A2
89A3
89A4
89A8
89AB
89AD
89AE
89B1
89B8
89B9
89BB
89BE
89C1
89C2
89C3
89C4
89C5
89C6
89C7
89C8
89C9
89CA
89CB
89CC
89CD
89CE
89CF
89D0
89D1
89D3
89D9
89DB
89DE
89DF
89E0
89E1
89E2
89E4
89E8
89EA
89EC
89EE
89EF
89F0
89F2
89F5
89F7
89FA
89FB
89FC
89FE
8A01
8A06
8A09
8A0B
8A0D
8A19
8A1A
8A1C
8A21
8A27
8A28
8A29
8A2E
8A30
8A32
8A38
8A39
8A3F
8A42
8A44
8A4A
8A4B
8A4C
8A4F
8A59
8A5A
8A5F
8A64
8A68
8A6A
8A6F
8A74
8A78
8A7D
8A81
8A88
8A8A
8A8E
8A94
8A9B
8A9C
8A9D
8AA2
8AAA
8AAB
8AB1
8AB4
8AB5
8AB8
8ABA
8ABD
8AC0
8AC1
8AC5
8ACE
8AD0
8AD8
8AD9
8AE3
8AE5
8AE8
8AE9
8AEA
8AEF
8AF2
8AF9
8AFB
8AFD
8B03
8B08
8B09
8B0D
8B0F
8B12
8B13
8B15
8B18
8B22
8B23
8B24
8B25
8B27
8B29
8B2A
8B2E
8B2F
8B31
8B32
8B34
8B36
8B38
8B3A
8B3B
8B3D
8B3F
8B40
8B47
8B4A
8B4B
8B50
8B51
8B55
8B57
8B5D
8B61
8B62
8B64
8B65
8B67
8B68
8B69
8B6A
8B6E
8B73
8B75
8B7A
8B7B
8B7F
8B82
8B86
8B87
8B88
8B89
8B91
8B97
8B98
8B9B
8B9D
8BA0
8BA1
8BA2
8BA3
8BA4
8BA5
8BA6
8BA7
8BA8
8BA9
8BAA
8BAB
8BAC
8BAD
8BAE
8BAF
8BB0
8BB1
8BB2
8BB3
8BB4
8BB5
8BB6
8BB7
8BB8
8BB9
8BBA
8BBB
8BBC
8BBD
8BBE
8BBF
8BC0
8BC1
8BC2
8BC3
8BC4
8BC5
8BC6
8BC7
8BC8
8BC9
8BCA
8BCB
8BCC
8BCD
8BCE
8BCF
8BD0
8BD1
8BD2
8BD3
8BD4
8BD5
8BD7
8BD8
8BD9
8BDA
8BDB
8BDC
8BDD
8BDE
8BDF
8BE0
8BE1
8BE2
8BE3
8BE4
8BE5
8BE6
8BE7
8BE8
8BE9
8BEA
8BEB
8BEC
8BED
8BEE
8BEF
8BF0
8BF2
8BF3
8BF4
8BF5
8BF6
8BF7
8BF8
8BF9
8BFA
8BFB
8BFC
8BFD
8BFE
8BFF
8C00
8C01
8C02
8C03
8C04
8C05
8C06
8C07
8C08
8C09
8C0A
8C0B
8C0C
8C0D
8C0E
8C0F
8C10
8C11
8C12
8C13
8C14
8C15
8C16
8C17
8C18
8C19
8C1A
8C1B
8C1C
8C1D
8C1E
8C1F
8C20
8C21
8C22
8C23
8C24
8C25
8C26
8C27
8C28
8C29
8C2A
8C2B
8C2C
8C2D
8C2E
8C2F
8C30
8C31
8C32
8C33
8C34
8C35
8C36
8C3B
8C3C
8C40
8C42
8C43
8C44
8C4D
8C52
8C56
8C5C
8C5E
8C5F
8C60
8C65
8C67
8C6E
8C6F
8C70
8C71
8C72
8C74
8C77
8C7D
8C7F
8C80
8C81
8C83
8C84
8C88
8C8F
8C91
8C95
8C96
8C97
8C9A
8C9F
8CA3
8CA5
8CA6
8CB1
8CB5
8CBE
8CCC
8CD0
8CD2
8CD4
8CD7
8CD8
8CDF
8CE5
8CE7
8CE9
8CEB
8CEE
8CF1
8CF3
8CF4
8CF6
8CF9
8D00
8D02
8D06
8D0C
8D0E
8D11
8D15
8D18
8D19
8D1A
8D1C
8D1D
8D1E
8D1F
8D20
8D21
8D22
8D23
8D24
8D25
8D26
8D27
8D28
8D29
8D2A
8D2B
8D2C
8D2D
8D2E
8D2F
8D30
8D31
8D32
8D33
8D34
8D35
8D36
8D37
8D38
8D39
8D3A
8D3B
8D3C
8D3D
8D3E
8D3F
8D40
8D41
8D42
8D43
8D44
8D45
8D46
8D47
8D48
8D49
8D4A
8D4B
8D4C
8D4D
8D4E
8D4F
8D50
8D51
8D52
8D53
8D54
8D55
8D56
8D57
8D58
8D59
8D5A
8D5B
8D5C
8D5D
8D5E
8D5F
8D60
8D61
8D62
8D63
8D68
8D6A
8D6F
8D72
8D75
8D76
8D78
8D79
8D7A
8D7B
8D7C
8D7D
8D7E
8D80
8D83
8D86
8D87
8D89
8D8B
8D8C
8D8E
8D8F
8D92
8D93
8D94
8D96
8D97
8D98
8D9A
8D9B
8D9C
8D9D
8DA1
8DA2
8DA4
8DA5
8DA7
8DA9
8DAA
8DAD
8DAE
8DB0
8DB1
8DB4
8DB6
8DB8
8DBD
8DBF
8DC1
8DC3
8DC4
8DC9
8DCD
8DD0
8DD2
8DD3
8DD8
8DDC
8DDE
8DE0
8DE2
8DE6
8DE9
8DED
8DEE
8DF6
8DF7
8DF8
8DF9
8DFA
8DFB
8DFE
8E00
8E02
8E03
8E07
8E0C
8E0D
8E0E
8E12
8E13
8E15
8E17
8E18
8E19
8E1A
8E1B
8E1C
8E24
8E25
8E28
8E29
8E2B
8E2C
8E2D
8E2E
8E2F
8E32
8E3A
8E3B
8E3C
8E3E
8E3F
8E43
8E45
8E46
8E51
8E52
8E53
8E56
8E57
8E58
8E5A
8E65
8E66
8E67
8E68
8E6A
8E6B
8E6E
8E73
8E75
8E77
8E78
8E7D
8E7E
8E7F
8E80
8E86
8E88
8E8C
8E8E
8E8F
8E96
8E97
8E98
8E9C
8E9F
8EA0
8EA3
8EA4
8EA5
8EA6
8EA8
8EB2
8EB4
8EB6
8EB7
8EB8
8EB9
8EBC
8EBD
8EBF
8EC2
8EC9
8ECE
8ED0
8ED3
8ED5
8ED6
8ED7
8ED8
8ED9
8EDA
8EDD
8EDE
8EE0
8EE1
8EE4
8EE5
8EE6
8EE7
8EE9
8EEA
8EEC
8EEF
8EF2
8EF3
8EF4
8EF5
8EF6
8EFF
8F01
8F04
8F06
8F0B
8F0D
8F0E
8F11
8F1A
8F22
8F24
8F2B
8F30
8F31
8F32
8F3C
8F3D
8F48
8F4A
8F4B
8F50
8F56
8F59
8F5A
8F5B
8F60
8F66
8F67
8F68
8F69
8F6A
8F6B
8F6C
8F6D
8F6E
8F6F
8F70
8F71
8F72
8F73
8F74
8F75
8F76
8F77
8F78
8F79
8F7A
8F7B
8F7C
8F7D
8F7E
8F7F
8F80
8F81
8F82
8F83
8F84
8F85
8F86
8F87
8F88
8F89
8F8A
8F8B
8F8C
8F8D
8F8E
8F8F
8F90
8F91
8F92
8F93
8F94
8F95
8F96
8F97
8F98
8F99
8F9A
8FA2
8FA9
8FAA
8FAB
8FAC
8FB3
8FB4
8FB9
8FBD
8FC3
8FC7
8FC8
8FC9
8FCC
8FCF
8FD6
8FD7
8FD8
8FD9
8FDB
8FDC
8FDD
8FDE
8FDF
8FE1
8FE7
8FEC
8FF2
8FF3
8FFC
8FFF
9007
9009
900A
9012
901C
9024
9025
9026
902B
9030
903A
903B
903D
9040
9046
9048
9057
905A
905F
9064
906A
906B
9071
9073
907B
907E
9086
908D
9092
9093
9094
9096
909A
909C
909D
909E
909F
90A4
90A7
90A9
90AB
90AC
90AD
90AE
90B7
90B9
90BA
90BB
90BC
90BF
90C0
90C2
90C6
90C9
90CB
90CD
90CF
90D0
90D1
90D3
90D4
90D6
90DA
90DE
90E0
90E3
90E6
90E7
90E9
90EA
90EC
90EE
90F1
90F2
90F3
90F8
90F9
90FA
90FB
90FC
9101
9103
9107
9109
910A
910B
910C
910E
910F
9111
9113
9115
911B
911D
911F
9121
9124
9126
9128
912A
912B
912C
9133
9135
9138
913B
913E
913F
9140
9141
9142
9144
9145
9146
9150
9151
9155
915C
915D
915E
915F
9160
9166
9168
916B
916E
916F
9170
9171
9176
917C
917D
917E
917F
9180
9184
9188
918C
918F
9196
9199
919A
919B
919D
919F
91A0
91A3
91A5
91A7
91A9
91B7
91B9
91BE
91C4
91CA
91D2
91D5
91E0
91E2
91E8
91EB
91F2
91F3
91F4
91F8
91FA
91FE
9202
9203
9208
920B
920F
9217
9219
921A
921B
921F
9220
9221
9222
9227
922A
922B
922D
9231
9232
923B
923D
9241
924C
9252
9253
9254
9255
9256
925F
9263
926A
926B
926C
926D
9272
9273
9274
927A
9281
9282
9284
9286
9287
928B
928C
928F
9290
9294
929D
929E
92A1
92A2
92A3
92A6
92A9
92AA
92AC
92AE
92B0
92B1
92B3
92B4
92B5
92BE
92C4
92C9
92CA
92D1
92D4
92D6
92DA
92DB
92DE
92E2
92E6
92EB
92EF
92F1
92F4
92F5
92F6
92F7
92FD
92FE
9301
9303
9304
9305
9307
9309
930A
930B
930C
930E
9312
9313
9316
9317
931B
932D
9330
9331
9338
9339
933C
933D
933E
933F
9340
9341
9342
9343
9345
9346
934A
934C
934E
934F
9353
9359
935D
935F
9361
9362
9363
9366
9368
936B
9372
9377
9378
9379
937B
9383
9384
9385
9386
9387
9389
938E
9390
9391
9393
9399
939C
939D
939F
93A0
93A2
93A5
93AA
93AF
93B1
93B2
93B3
93B7
93B8
93BB
93BC
93BD
93BE
93BF
93C0
93C2
93CE
93CF
93D2
93D4
93D5
93DA
93DB
93E0
93E3
93E9
93EA
93EB
93EC
93ED
93EE
93EF
93F0
93F1
93F2
93F3
93F4
93F5
93F6
93FC
93FE
93FF
9400
9405
9406
940A
940B
940C
9411
9412
941B
941C
941D
941E
9420
9422
9423
9424
9425
9426
9427
9428
9429
942A
942C
942D
9430
9437
9439
943C
943E
9440
9442
9446
9447
9449
944B
944D
944E
944F
9450
9454
9456
9457
9458
945D
9464
9465
9466
9467
9469
946C
9473
9474
9476
9478
9479
947A
947B
9480
9482
9485
9486
9487
9488
9489
948A
948B
948C
948D
948E
948F
9490
9491
9492
9493
9494
9495
9496
9497
9498
9499
949A
949B
949C
949D
949E
949F
94A0
94A1
94A2
94A3
94A4
94A5
94A7
94A8
94A9
94AA
94AC
94AD
94AE
94AF
94B0
94B1
94B2
94B3
94B4
94B5
94B6
94B7
94B8
94B9
94BA
94BB
94BC
94BD
94BE
94BF
94C0
94C1
94C2
94C3
94C4
94C5
94C6
94C7
94C8
94C9
94CA
94CB
94CC
94CD
94CE
94CF
94D0
94D1
94D2
94D3
94D4
94D5
94D6
94D7
94D8
94D9
94DB
94DC
94DD
94DE
94DF
94E0
94E1
94E2
94E3
94E4
94E5
94E6
94E7
94E8
94E9
94EA
94EB
94EC
94ED
94EE
94EF
94F0
94F1
94F2
94F3
94F4
94F5
94F6
94F7
94F8
94F9
94FA
94FB
94FC
94FD
94FE
94FF
9500
9501
9502
9503
9504
9505
9506
9507
9508
9509
950A
950B
950C
950D
950E
950F
9510
9511
9512
9513
9514
9515
9516
9517
9518
9519
951A
951B
951C
951D
951E
951F
9520
9521
9522
9523
9524
9525
9526
9527
9528
9529
952A
952B
952C
952D
952E
952F
9530
9531
9532
9533
9534
9535
9536
9537
9538
9539
953A
953B
953C
953D
953E
953F
9540
9541
9542
9543
9544
9545
9546
9547
9548
9549
954A
954B
954C
954D
954E
954F
9550
9551
9552
9553
9554
9555
9556
9557
9558
9559
955A
955B
955C
955D
955E
955F
9560
9561
9562
9563
9564
9565
9566
9567
9568
9569
956A
956B
956C
956D
956E
956F
9570
9571
9572
9573
9574
9575
9576
957A
957B
957C
957D
957F
9581
9585
9586
9590
9592
9595
9597
959A
959B
959C
95AA
95AE
95AF
95B0
95B1
95B3
95B5
95B7
95B8
95C0
95C1
95C2
95C4
95C5
95CE
95CF
95D7
95DB
95E3
95E7
95E8
95E9
95EA
95EB
95EC
95ED
95EE
95EF
95F0
95F1
95F2
95F3
95F4
95F5
95F6
95F7
95F8
95F9
95FA
95FB
95FC
95FD
95FE
95FF
9600
9601
9602
9603
9604
9605
9606
9607
9608
9609
960A
960B
960C
960D
960E
960F
9610
9611
9612
9613
9614
9615
9616
9617
9618
9619
961A
961B
961F
9620
9623
9627
9629
962B
962D
9630
9634
9635
9636
963E
9643
9645
9646
9647
9648
9649
964A
964E
9651
9653
9655
9659
965A
9660
9667
9668
9669
966B
966D
966F
9671
9679
9680
9687
968C
9690
9692
9693
969E
96A1
96A2
96AB
96AC
96AD
96B5
96BD
96BE
96BF
96C2
96C3
96C8
96CF
96D0
96D3
96D4
96D7
96E0
96E1
96E4
96E5
96E6
96E7
96EC
96ED
96EE
96F3
96F4
96F5
96F8
96FC
96FD
96FE
96FF
9701
970B
970C
9710
9712
9714
9715
9717
9718
971F
9720
9725
9726
9729
972B
972C
972D
972E
972F
9734
9735
9736
9737
973A
973B
973C
973F
9740
9745
9747
974B
974C
974D
9750
9751
9753
9754
975D
975F
9765
976C
976F
9770
9772
9775
977E
9782
9783
9787
9788
978A
978C
978E
9791
9792
9793
9794
979B
979D
97A1
97A4
97A5
97A7
97A9
97AA
97AF
97B0
97B7
97BB
97BD
97C0
97C2
97CF
97D2
97D5
97D6
97DA
97DF
97E2
97E3
97E5
97E6
97E7
97E8
97E9
97EA
97EB
97EC
97F0
97F9
97FC
97FD
97FE
9800
9804
9809
980B
9815
981B
981D
981F
9822
9827
9828
9829
982A
9831
9836
9839
983A
983F
9840
9841
9842
9843
9845
9848
9849
9850
985C
985D
985F
9860
9861
9864
9868
9869
986D
986E
9872
9875
9876
9877
9878
9879
987A
987B
987C
987D
987E
987F
9880
9881
9882
9883
9884
9885
9886
9887
9888
9889
988A
988B
988C
988D
988E
988F
9890
9891
9892
9893
9894
9895
9896
9897
9898
9899
989A
989B
989C
989D
989E
989F
98A0
98A1
98A2
98A3
98A4
98A5
98A6
98A7
98A9
98AC
98B2
98B3
98B5
98B9
98BC
98BD
98BE
98C0
98C1
98C7
98C9
98CA
98CB
98CD
98CE
98CF
98D0
98D1
98D2
98D3
98D4
98D5
98D6
98D7
98D8
98D9
98DA
98DD
98DE
98E0
98E4
98E8
98EC
98F0
98F1
98F5
98F7
98F8
98F9
98FA
98FB
98FF
9900
9901
9904
9906
990B
990D
990E
990F
9919
9923
9925
9929
992A
992D
992F
9930
9936
9937
9938
993F
9943
9944
994A
994F
9953
9956
995A
995D
9961
9962
9963
9964
9965
9966
9967
9968
9969
996A
996B
996C
996D
996E
996F
9970
9971
9972
9973
9974
9975
9976
9977
9978
9979
997A
997B
997C
997D
997E
997F
9980
9981
9982
9983
9984
9985
9986
9987
9988
9989
998A
998B
998C
998D
998E
998F
9990
9991
9992
9993
9994
9995
999A
999C
999E
99A0
99A1
99A2
99A3
99A4
99A7
99A9
99AA
99AB
99AF
99B6
99B7
99B8
99BB
99BE
99C0
99C2
99C7
99CA
99CB
99CC
99CD
99CE
99CF
99D6
99D7
99E0
99E1
99E3
99E4
99E5
99E6
99E8
99E9
99EF
99F3
99F6
99F7
99FA
99FC
9A00
9A06
9A07
9A08
9A09
9A0A
9A0D
9A14
9A15
9A17
9A18
9A1A
9A1B
9A1C
9A1D
9A1F
9A21
9A25
9A26
9A29
9A2A
9A2C
9A2F
9A31
9A32
9A34
9A39
9A3A
9A3B
9A3C
9A3D
9A3F
9A46
9A48
9A49
9A4F
9A50
9A52
9A53
9A58
9A59
9A5C
9A5E
9A60
9A61
9A63
9A66
9A67
9A68
9A6C
9A6D
9A6E
9A6F
9A70
9A71
9A72
9A73
9A74
9A75
9A76
9A77
9A78
9A79
9A7A
9A7B
9A7C
9A7D
9A7E
9A7F
9A80
9A81
9A82
9A83
9A84
9A85
9A86
9A87
9A88
9A89
9A8A
9A8B
9A8C
9A8D
9A8E
9A8F
9A90
9A91
9A92
9A93
9A94
9A95
9A96
9A97
9A98
9A99
9A9A
9A9B
9A9C
9A9D
9A9E
9A9F
9AA0
9AA1
9AA2
9AA3
9AA4
9AA5
9AA6
9AA7
9AA9
9AAB
9AB1
9AB3
9AB7
9ABA
9ABD
9AC2
9AC5
9AC7
9AC9
9ACA
9ACB
9ACC
9ACD
9AD9
9ADA
9ADD
9AE1
9AE8
9AF6
9AF8
9AFC
9AFE
9B07
9B0A
9B0F
9B11
9B13
9B14
9B15
9B17
9B1D
9B1E
9B21
9B24
9B2C
9B30
9B36
9B38
9B3E
9B3F
9B40
9B46
9B47
9B49
9B4A
9B50
9B52
9B53
9B59
9B5C
9B5D
9B5F
9B60
9B62
9B64
9B67
9B69
9B70
9B71
9B72
9B76
9B7A
9B7B
9B7C
9B7D
9B7E
9B81
9B82
9B88
9B8C
9B95
9B98
9B99
9B9B
9B9C
9BA1
9BA2
9BA3
9BA4
9BA5
9BAF
9BB3
9BB5
9BB6
9BBA
9BBD
9BC2
9BC3
9BC4
9BC5
9BCB
9BCC
9BCD
9BD3
9BD5
9BD9
9BDA
9BDC
9BDE
9BE0
9BE6
9BE9
9BEC
9BED
9BEE
9BF4
9BF6
9BFB
9BFC
9BFE
9C01
9C03
9C05
9C07
9C0E
9C17
9C1D
9C1F
9C20
9C2B
9C2C
9C33
9C34
9C38
9C3C
9C3F
9C40
9C42
9C4B
9C4C
9C4D
9C51
9C55
9C59
9C61
9C62
9C64
9C65
9C66
9C6C
9C6D
9C6F
9C71
9C73
9C74
9C79
9C7A
9C7C
9C7D
9C7E
9C7F
9C80
9C81
9C82
9C83
9C84
9C85
9C86
9C87
9C88
9C89
9C8A
9C8B
9C8C
9C8D
9C8E
9C8F
9C90
9C91
9C92
9C93
9C94
9C95
9C96
9C97
9C98
9C99
9C9A
9C9B
9C9C
9C9D
9C9E
9C9F
9CA0
9CA1
9CA2
9CA3
9CA4
9CA5
9CA6
9CA7
9CA8
9CA9
9CAA
9CAB
9CAC
9CAD
9CAE
9CAF
9CB0
9CB1
9CB2
9CB3
9CB4
9CB5
9CB6
9CB7
9CB8
9CB9
9CBA
9CBB
9CBC
9CBD
9CBE
9CBF
9CC0
9CC1
9CC2
9CC3
9CC4
9CC5
9CC6
9CC7
9CC8
9CC9
9CCA
9CCB
9CCC
9CCD
9CCE
9CCF
9CD0
9CD1
9CD2
9CD3
9CD4
9CD5
9CD6
9CD7
9CD8
9CD9
9CDA
9CDB
9CDC
9CDD
9CDE
9CDF
9CE0
9CE1
9CE2
9CE3
9CE4
9CE8
9CEA
9CED
9CEE
9CEF
9CF1
9CF5
9CF8
9CFA
9CFB
9CFC
9CFD
9CFE
9CFF
9D00
9D01
9D04
9D05
9D0A
9D0C
9D0D
9D0F
9D10
9D13
9D14
9D16
9D19
9D1A
9D20
9D21
9D22
9D24
9D25
9D27
9D29
9D2D
9D2E
9D31
9D35
9D36
9D37
9D38
9D39
9D40
9D49
9D4B
9D4C
9D4D
9D4E
9D4F
9D52
9D55
9D56
9D57
9D58
9D5A
9D5B
9D66
9D67
9D68
9D6D
9D6E
9D71
9D73
9D74
9D75
9D78
9D79
9D7D
9D7F
9D80
9D81
9D82
9D85
9D88
9D8B
9D8C
9D90
9D91
9D94
9D99
9D9B
9D9C
9D9D
9D9E
9D9F
9DA0
9DA2
9DA3
9DA5
9DA6
9DA7
9DA8
9DAD
9DB0
9DB3
9DB6
9DB7
9DBD
9DBE
9DC0
9DC5
9DC8
9DCB
9DCC
9DCD
9DCE
9DD0
9DD1
9DD2
9DD8
9DDB
9DDC
9DDD
9DE1
9DE2
9DE3
9DE4
9DE8
9DEA
9DEC
9DF1
9DF5
9DF6
9DF7
9DFB
9DFC
9DFF
9E00
9E01
9E03
9E04
9E05
9E06
9E08
9E09
9E0B
9E0C
9E0D
9E0F
9E13
9E14
9E17
9E18
9E1F
9E20
9E21
9E22
9E23
9E24
9E25
9E26
9E27
9E28
9E29
9E2A
9E2B
9E2C
9E2D
9E2E
9E2F
9E30
9E31
9E32
9E33
9E34
9E35
9E36
9E37
9E38
9E39
9E3A
9E3B
9E3C
9E3D
9E3E
9E3F
9E40
9E41
9E42
9E43
9E44
9E45
9E46
9E47
9E48
9E49
9E4A
9E4B
9E4C
9E4D
9E4E
9E4F
9E50
9E51
9E52
9E53
9E54
9E55
9E56
9E57
9E58
9E59
9E5A
9E5B
9E5C
9E5D
9E5E
9E5F
9E60
9E61
9E62
9E63
9E64
9E65
9E66
9E67
9E68
9E69
9E6A
9E6B
9E6C
9E6D
9E6E
9E6F
9E70
9E71
9E72
9E73
9E74
9E76
9E77
9E7E
9E86
9E89
9E8A
9E8D
9E90
9E94
9E99
9E9A
9E9C
9EA0
9EA1
9EA2
9EA3
9EA7
9EAB
9EB1
9EB2
9EB6
9EB7
9EBD
9EC0
9EC1
9EC2
9EC3
9EC5
9EC7
9EC9
9ECA
9ED1
9ED3
9ED6
9ED7
9EDA
9EE1
9EE2
9EE3
9EE6
9EE9
9EEA
9EEB
9EF3
9EFA
9EFE
9F00
9F01
9F04
9F05
9F06
9F0A
9F0B
9F0C
9F0D
9F18
9F1C
9F1D
9F1E
9F23
9F24
9F25
9F27
9F28
9F29
9F2D
9F2E
9F30
9F33
9F35
9F36
9F38
9F40
9F42
9F48
9F49
9F4C
9F4D
9F50
9F51
9F59
9F5B
9F5C
9F64
9F65
9F6B
9F74
9F78
9F79
9F7B
9F7C
9F7E
9F7F
9F80
9F81
9F82
9F83
9F84
9F85
9F86
9F87
9F88
9F89
9F8A
9F8B
9F8C
9F8E
9F93
9F98
9F99
9F9A
9F9B
9F9F
9FA4
EOH
}

sub InJISX0221JapaneseNonIdeographicsSupplement {
<<EOH;
007E
00A0	00A1	
00A4
00A6
00A9
00AA
00AB
00AD	00AF	
00B2	00B3	
00B5
00B7	00D6	
00D8	00F6	
00F8	00FF	
0100	017F	
0250	02A8	
0374
0375
037A
037E
0384	038A	
038C
038E
038F
0390
03AA	03B0	
03C2
03CA	03CE	
0402	040C	
040E
040F
0452	045C	
045E	0486	
0490	04C4	
04C7
04C8
04CB
04CC
04D0	04EB	
04EE	04F5	
04F8
04F9
2000	200F	
2011	2013	
2015
2017
201A	201B	
201E
201F
2022	2024	
2027	202E	
2031
2034	203A	
203C
203D
203F	2046	
2070
2074	208E	
20A0	20AA	
2100	2102	
2104	212A	
212C	2138	
2153	2182	
2194	21D1	
21D3
21D5	21EA	
2201
2204	2206	
2209
220A
220C	2211	
2213	2219	
221B	221C	
221F
2221	2226	
222D	2233	
2236	223C	
223E	2251	
2253	225F	
2262	2265	
2268
2269
226C	2281	
2284
2285
2288	22A4	
22A6	22F1	
2460	24EA	
2504	250B	
250D
250E
2511
2512
2515
2516
2519
251A
251E
251F
2521
2522
2526
2527
2529
252A
252D
252E
2531
2532
2532
2535
2536
2539
253A
253D
253E
2540
2541
2543
2544	254A	
254C	2595	
25A2	25B1	
25B4	25BB	
25BE	25C5	
25C8	25CA	
25CC
25CD
25D0	25EE	
2600	2604	
2607	2613	
261A	263F	
2641
2643	2669	
266B	266E	
2701	2704	
2706	2709	
270C	2727	
2729	274B	
274D
274F	2752	
2756
2758	275E	
2761	2767	
2776	27AF	
27B1	27BE	
3004
3015	301B	
301D	3020	
3033	3036	
3094
30F7	30FA	
3220	3243	
3280	32B0	
32D0	32FE	
3300	3357	
3371	3376	
337B	33DD	
EOH
}

=head1 COLLECTION NAMES

=over 4

=item C<InJISX0221BasicJapanese>

=item C<InJISX0221FullwidthAlphanumeric>

=item C<InJISX0221HalfwidthKatakana>

=item C<InJISX0221JapaneseIdeographicsSupplement1>

=item C<InJISX0221JapaneseIdeographicsSupplement2>

=item C<InJISX0221JapaneseIdeographicsSupplement3>

=item C<InJISX0221JapaneseNonIdeographicsSupplement>

=back

=cut


=head1 EXAMPLE

 use Char::Class::JISX0221;
 if ($s =~ /\p{InFullwidthAlphanumeric}/) {
   print "Match!\n";
 }

=head1 SEE ALSO

ISO/IEC 10646-1:1993, ISO/IEC JTC1, 1993.  Obsoleted by ISO/IEC 10646-1:2000.

ISO/IEC 10646-1:2000, ISO/IEC JTC1, 2000.  Revision of ISO/IEC 10646-1:1993.

JIS X 0221-1995, Japanese Industrial Standard Commitee
(JISC <http://www.jisc.go.jp/>), 1995.  Obsoleted by JIS X 0221-1:2001.

JIS X 0221-1:2001, Japanese Industrial Standard Commitee
(JISC <http://www.jisc.go.jp/>), 2001.  JIS version of ISO/IEC
10646-1:2000.  Revision of JIS X 0221-1995.

ISO/IEC 646:1991, JIS X 0201:1997, JIS X 0208:1997, JIS X 0212-1990,
JIS X 0213:2000 are also related.

L<Char::Class::UCS>

L<Char::Class::RFC1815>

=head1 LICENSE

Copyright 2007 Wakaba <w@suika.fam.cx>

This library and the library generated by it is free software;
you can redistribute them and/or modify them under the same
terms as Perl itself.

=cut

1;
### JISX0221.pm ends here
