#!/usr/bin/perl
use strict;
use SuikaWiki::Name;
use Test;

plan tests => 25;

my $name = SuikaWiki::Name->new ([qw/A B C D E F/]);
ok $name->stringify (delimiter => q(//)), q(A//B//C//D//E//F);

$name = SuikaWiki::Name->new (bless [qw/A B C 0 1 2/], 'SomeModule');
ok $name->stringify (delimiter => q(!)), q(A!B!C!0!1!2);

$name = SuikaWiki::Name->new (bless {a => [qw/_ _ _/]}, 'SomeOtherModule');
ok $name->stringify (delimiter => q(@)), q(_@_@_);

$name = SuikaWiki::Name->new ('A//B//C', delimiter_reg => qr#//#);
ok $name->stringify (delimiter => q(/)), q(A/B/C);

$name = SuikaWiki::Name->new ('A B C D', wiki => {config => {name => {space => {separator_reg => qr#\s#}}}});
ok $name->stringify (wiki => {config => {name => {space => {separator => q( - )}}}}), q(A - B - C - D);

$name->append_component ('a');
ok $name->stringify (delimiter => '_'), 'A_B_C_D_a';

$name->append_component ([qw/b c/]);
ok $name->stringify (delimiter => '_'), 'A_B_C_D_a_b_c';

$name->prepend_component ('1');
ok $name->stringify (delimiter => '_'), '1_A_B_C_D_a_b_c';

$name->prepend_component ([qw/2 3/]);
ok $name->stringify (delimiter => '_'), '2_3_1_A_B_C_D_a_b_c';


$name = SuikaWiki::Name->new ([qw/.. 1 2/]);
ok $name->absolute (self => '.', parent => '..', base => [qw/5 6/])
        ->stringify (delimiter => ' '),
   '5 1 2';

$name = SuikaWiki::Name->new ([qw/.. .. 1 2/]);
ok $name->absolute (self => '.', parent => '..', base => [qw/5 6/])
        ->stringify (delimiter => ' '),
   '1 2';

$name = SuikaWiki::Name->new ([qw/1 2/]);
ok $name->absolute (self => '.', parent => '..', base => [qw/5 6/])
        ->stringify (delimiter => ' '),
   '1 2';

$name = SuikaWiki::Name->new ([qw/. 1 2/]);
ok $name->absolute (self => '.', parent => '..', base => [qw/5 6/])
        ->stringify (delimiter => ' '),
   '5 6 1 2';

$name = SuikaWiki::Name->new ([qw/. . . 1 2/]);
ok $name->absolute (self => '.', parent => '..', base => [qw/5 6/])
        ->stringify (delimiter => ' '),
   '5 6 1 2';

## Root namespace

$name = SuikaWiki::Name->new ([]);
ok $name->stringify (root => '\\'), '\\';

$name = SuikaWiki::Name->new ([]);
ok $name->stringify (wiki => {config => {name => {space => {root => '/'}}}}),
   '/';

$name = SuikaWiki::Name->new ('/', root => '/');
ok $name->stringify (root => '\\'), '\\';

$name = SuikaWiki::Name->new ('/', wiki => {config => {name => {space => {root => '/'}}}});
ok $name->stringify (root => '\\'), '\\';

$name = SuikaWiki::Name->new ('', root => '/', delimiter => ':');
ok $name->stringify (root => '\\', delimiter => '/'), '\\';

$name = SuikaWiki::Name->new ([]);
ok $name->absolute (self => '.', parent => '..', base => [qw/5 6/])
        ->stringify (delimiter => ' ', root => '/'),
   '/';

$name = SuikaWiki::Name->new ([]);
ok $name->absolute (self => '.', parent => '..', base => [])
        ->stringify (delimiter => ' ', root => '/'),
   '/';

$name = SuikaWiki::Name->new ([qw/. . a/]);
ok $name->absolute (self => '.', parent => '..', base => [])
        ->stringify (delimiter => ' ', root => '/'),
   'a';

$name = SuikaWiki::Name->new ([qw/.. .. a/]);
ok $name->absolute (self => '.', parent => '..', base => [])
        ->stringify (delimiter => ' ', root => '/'),
   'a';

$name = SuikaWiki::Name->new ([qw/a/]);
ok $name->absolute (self => '.', parent => '..', base => [])
        ->stringify (delimiter => ' ', root => '/'),
   'a';

$name = SuikaWiki::Name->new ([qw/a b/]);
ok $name->absolute (self => '.', parent => '..', base => [])
        ->stringify (delimiter => ' ', root => '/'),
   'a b';

package SomeOtherModule;
use overload '@{}' => sub {shift->{a}};
