#!/usr/bin/perl
use strict;
use warnings;
use Test;
use FindBin q($Bin);
BEGIN {plan tests => 5}
use SuikaWiki::DB::Hash;

my %db;
my $db = new SuikaWiki::DB::Hash
           constructor => sub { \%db },
           has_exist => 1;

unshift @{$db->{event}->{error}}, sub {
  my ($self, $event) = @_;
  unless ({qw/fatal 1 stop 1 warn 1/}->{$event->{error}->{-def}->{level}}) {
    warn "DEBUG: ". $event->{error}->stringify;
  }
} if $^W;

$db->set (test => ['Key'] => 'Value');

ok $db->get (test => ['Key']), 'Value';
ok $db->get (test => ['other']), undef;

$db->set (test => ['Key', 'Sub'] => 'SubValue');
ok $db->get (test => ['Key', 'Sub']), 'SubValue';

$db->set (test => ['KeySub'] => 'OtherValue');
ok $db->get (test => ['KeySub']), 'OtherValue';
ok $db->get (test => ['Key', 'Sub']), 'SubValue';

$db->close;

undef $db;

