#!/usr/bin/perl
use strict;
use warnings;
use Test;
use FindBin q($Bin);
BEGIN {plan tests => 6}
use SuikaWiki::DB::FileSystem::LeafProp;

my $dir = $Bin.'/db.tmp';
#mkdir $dir or die "$0: $dir: $!" unless -d $dir;

sub filename ($;$) {
  my ($key, $suffix) = (shift, shift || '.txt');
  $dir.'/'.join ('.ns/', map {s/(.)/sprintf '%02X', ord $1/ges;$_} @$key).$suffix;
}

my $db = new SuikaWiki::DB::FileSystem::LeafProp
           base_directory => $dir,
           directory_suffix => '.ns',
           file_suffix => '.txt';

unshift @{$db->{event}->{error}}, sub {
  my ($self, $event) = @_;
  unless ({qw/fatal 1 stop 1 warn 1/}->{$event->{error}->{-def}->{level}}) {
    warn "DEBUG: ". $event->{error}->stringify;
  }
} if $^W;

my $v = $db->get (test => ['Key']);
ok $v->get_attribute_value ('V1'), undef;

$v->set_attribute (V1 => 'value1');
$db->set (test => ['Key'] => $v);
ok $db->get (test => ['Key'])->get_attribute_value ('V1'), 'value1';

$db->close;

undef $db;

my $file = filename (['Key']);
ok -e $file, 1, 'Value is written on disk';
unlink $file or warn "$0: $file: $!";

