
=head1 NAME

SuikaWiki::DB::Lock::NoLock - SuikaWiki: "No lock" Locking Implementation

=head1 DESCRIPTION

C<SuikaWiki::DB::Lock::NoLock> implements locking interface that
actually make nothing done.  This module can be used in context where
SuikaWiki WikiDB interface requires some lock module implementation
but locking is not necessary (or not preferred).

This module is part of SuikaWiki.

=cut

package SuikaWiki::DB::Lock::NoLock;
use strict;
our $VERSION=do{my @r=(q$Revision: 1.3 $=~/\d+/g);sprintf "%d."."%02d" x $#r,@r};

=head1 METHODS

=over 4

=item $locker = SuikaWiki::DB::Lock::NoLock->new (%options)

Generates a new instance of this module.

Options:

=over 4

=item appendable => 1/0 (Default 1)

=item readable => 1/0 (Default 1)

=item writable => 1/0 (Default 0)

=back

=cut

sub new ($%) {
  my $self = bless {}, shift;
  my %opt = @_;
  $self->{option}->{readable} = defined $opt{readable} ? $opt{readable} : 1;
  $self->{option}->{writable} = defined $opt{writable} ? $opt{writable} : 0;
  $self->{option}->{appendable} = defined $opt{appendable} ? $opt{appendable} : 1;
  $self;
}

=item 1/0 = $locker->lock ()

Lock.  Returns C<1> if lock is successed.  Otherwise C<0> is returned.

=cut

sub lock ($) {
  my $self = shift;
  $self->{locked} ? 1 : "0 but true";
}

=item 1/0 = $locker->unlock ()

Unlock.  Returns C<1> if unlock is success.  C<-1> if lock file is
lost.  Otherwise C<0> is returned.

=cut

sub unlock ($) {
  my $self = shift;
  $self->{locked} ? 1 : "0 but true";
}

=item 1/0 = $locker->readable ()

Returns whether readable or not.

=item 1/0 = $locker->writable ()

Returns whether writable or not.

=item 1/0 = $locker->appendable

Returns whether line-appendable or not.

=item 1/0 = $locker->locked ()

Returns whether locked or not.       

=cut

sub readable ($) { shift->{option}->{readable} }
sub writable ($) { shift->{option}->{writable} }
sub appendable ($) { shift->{option}->{appendable} }

sub locked ($) { "0 but true" }

=head1 EXAMPLE

    require SuikaWiki::DB::Lock::NoLock;
    my $locker = SuikaWiki::DB::Lock::NoLock->new;
    
    $locker->lock or die "Can't lock";
    
    open DATA, 'foo.txt';
    while (<DATA>) {
      # something
    }
    close DATA;
    
    open NEWDATA, '>', 'bar.txt';
      # something
    close NEWDATA;
    
    $locker->unlock or die "Can't unlock";

=head1 SEE ALSO

SuikaWiki:"SuikaWiki//WikiDB" 
<http://suika.fam.cx/~wakaba/-temp/wiki/wiki?SuikaWiki%2F%2FWikiDB>,
L<SuikaWiki::DB::Util::Lock>

=head1 LICENSE

Copyright 2003-2004 Wakaba <w@suika.fam.cx>.  All rights reserved.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut

1; # $Date: 2004/04/05 06:09:23 $
