function Factory () { }

    /**
       Creates a CSS style sheet object.
       [DOM Level 2 CSS]
    */
Factory.prototype.createCSSStyleSheet = function (title, media) {
      var ss = StyleSheet ();
      if (title != null) ss._SetTitle (title);
      //if (media != null) /* not implemented */
      return ss;
    };

    /**
       Creates a CSS |@import| rule object.
       
         Note.  Creating a |@import| object does not mean to load the referenced
                style sheet.
                @@ISSUE: Inserting the rule into a style sheet should make
                         the referenced style sheet loaded?
       
       [non-standard]
       
       @param href  The DOM URI of the referenced style sheet.
       @param media The media query associated to the rule.
                    If |null| is specified, then an empty media list
                    (which is equivalent to |all| by definition) is set.
       @return The newly created |@import| rule.
    */
Factory.prototype.createCSSImportRule = function (href, media) {
      return new ImportRule (href, media);
    };

    /**
       Creates a CSS |@charset| rule object.
       [non-standard]
    */
Factory.prototype.createCSSCharsetRule = function (charset) {
      return new CharsetRule (charset);
    };
    
    /**
       Creates a CSS |@namespace| rule object.
       
       [non-standard]
       
       @param prefix The namespace prefix, or |null| if it defines the
                     default namespace URI.
       @param namespaceURI The namespace URI.
       @return The newly created |@namespace| rule.
    */
Factory.prototype.createCSSNamespaceRule = function (prefix, namespaceURI) {
      return new NamespaceRule (prefix, namespaceURI);
    };

    /**
       Creates a CSS rule set object.
       [non-standard]
    */
Factory.prototype.createCSSRuleSet = function (selector) {
      return new RuleSet (selector);
    };

    /**
       Creates a CSS property declaration object.
       [non-standard]
       
       @param namespaceURI  The namespace URI of the property.
       @param prefix        The namespace prefix of the property, if any, or |null|.
       @param localName     The local name of the property.
       @param value         The value of the property.
    */
Factory.prototype.createCSSPropertyNS = function (namespaceURI, prefix, localName, value, priority) {
      if (priority == null) {
        priority = this.createCSSKeywordValueNS
                     ("http://suika.fam.cx/~wakaba/archive/2005/cssc.",
                      "manakaic", "normal");
      }
      return new PropertyDeclaration
                   (namespaceURI, prefix, localName, value, priority);
    };

var CSS_UNKNOWN_RULE_NODE         =   0;
var CSS_RULE_SET_NODE             =   1;
var CSS_AT_CHARSET_NODE           =   2;
var CSS_AT_IMPORT_NODE            =   3;
var CSS_AT_MEDIA_NODE             =   4;
var CSS_AT_FONT_FACE_NODE         =   5;
var CSS_AT_PAGE_NODE              =   6;
var CSS_UNKNOWN_NODE              = 100;
var CSS_STYLE_SHEET_NODE          = 101;
var CSS_DECLARATION_BLOCK_NODE    = 102;
var CSS_EMPTY_DECLARATION_NODE    = 103;
var CSS_PROPERTY_DECLARATION_NODE = 104;
var CSS_AT_NAMESPACE_NODE         = 106;

// _EscapeIdent = Value._EscapeIdent

/**
   Interface |CSSStyleSheet|
   
   A |CSSStyleSheet| object represents a CSS style sheet.
*/
function StyleSheet () {
  this.cssRules = new RuleList ();
};

StyleSheet.prototype.getCSSNodeType = function () {
  return CSS_STYLE_SHEET_NODE;
};

/**
   Appends a |CSSRule| to the list.
   [non-standard]
*/
StyleSheet.prototype.appendCSSRule = function (newRule) {
  /* There should be |HIERARCHY_REQUEST_ERR|. */
  newRule._SetParentStyleSheet (this);
  newRule._SetParentRule (null);
  return this.cssRules.v.push (newRule);
};

/**
   The base URI of the style sheet.  If it is not explicitly set,
   then |href| is the base URI.  If |href| is not defined neither,
   then |null|.
   [non-standard]
*/
StyleSheet.prototype.getBaseURI = function () {
  if (this.baseURI != null) {
    return this.baseURI;
  } else {
    return this.href;
  }
};

StyleSheet.prototype._SetBaseURI = function (newValue) {
  this.baseURI = newValue;
};

/**
   The list of rules, i.e. rule sets and at-rules.
   [DOM Level 2 CSS]
*/
StyleSheet.prototype.getCSSRules = function () {
  return this.cssRules;
};

/**
   The textual representation of the style sheet.
   [non-standard]
*/
StyleSheet.prototype.getCSSText = function () {
  var r = "";
  var lastType = CSS_UNKNOWN_RULE_NODE;
  for (var i = 0; i < this.cssRules.v.length; i++) {
    var rule = this.cssRules.v[i];
    if (lastType == CSS_RULE_SET_NODE ||
        rule.getCSSNodeType () == CSS_RULE_SET_NODE) {
      r += "\n";
    }
    lastType = rule.getCSSNodeType ();
    r += rule.getCSSText ();
  }
  /* TODO: Namespace fixup */
  return r;
};

/**
   Whether the style sheet is applied to the document or not.
   [DOM Level 2 Style Sheets]
*/
StyleSheet.prototype.getDisabled = function () {
  return this.disabled;
};
StyleSheet.prototype.setDisabled = function (newValue) {
  this.disabled = newValue;
};

/**
   The URI of the style sheet document, if available, or |null|.
   [DOM Level 2 Style Sheets]
*/
StyleSheet.prototype.getHref = function () {
  return this.href;
};
StyleSheet.prototype._SetHref = function (newValue) {
  this.href = newValue;
};

/* Not implemented: |media|, |ownerNode| from DOM Level 2 Style Sheets,
                    |setCSSText| */

/**
   Returns the namespace URI associated to a namespace prefix,
   if any, or |null|.
   [non-standard]
   
   @param prefix The namespace prefix to lookup.  If |null|, default
                 namespace URI, if any, is returned.  Note that in CSS
                 identifiers including prefixes are case-insensitive.
   @return The namespace URI associated with |prefix|, if any, or |null|.
*/
StyleSheet.prototype.lookupNamespaceURI =
function (prefix) {
  if (prefix != null) prefix = prefix.toLowerCase ();
  var uri = null;
  for (var i = 0; i < this.cssRules.v.length; i++) {
    var rule = this.cssRules.v[i];
    var ruleType = rule.getType ();
    if (ruleType == rule.NAMESPACE_RULE) {
      if (rule.getPrefix () == prefix) {
        uri = rule.getNamespaceURI ();
      }
      /* Don't |break|, since last occurence is in effect if there is 
         more than one declarations. */
    } else if (ruleType != rule.CHARSET_RULE &&
               ruleType != rule.IMPORT_RULE) {
      break;
    }
  }
  return uri;
};

/**
   The rule that references the style sheet, if any, or |null| otherwise.
   [DOM Level 2 CSS]
*/
StyleSheet.prototype.getOwnerRule = function () {
  return this.ownerRule;
};
StyleSheet.prototype._SetOwnerRule = function (newValue) {
  this.ownerRule = newValue;
};

/**
   The parent style sheet, if any, or |null|.
   [DOM Level 2 Style Sheets]
*/
StyleSheet.prototype.getParentStyleSheet = function () {
  return this.parentStyleSheet;
};
StyleSheet.prototype._SetParentStyleSheet =
function (newValue) {
  this.parentStyleSheet = newValue;
  for (var i = 0; i < this.cssRules.v.length; i++) {
    this.cssRules.v[i]._SetParentStyleSheet (newValue);
  }
};

/**
   The title of the style sheet, if any, or |null|.
   [DOM Level 2 Style Sheets]
*/
StyleSheet.prototype.getTitle = function () {
  return this.title;
};
StyleSheet.prototype._SetTitle =
function (newValue) {
  this.title = newValue;
};

/**
   The Internet media type of the style sheet.
   [DOM Level 2 Style Sheets]
*/
StyleSheet.prototype.getType = function () {
  return "text/css";
};

StyleSheet.prototype.toString = function () {
  return "[object CSSStyleSheet]";
};

/* Not implemented: |insertRule|, |deleteRule| from DOM Level 2 CSS */


/*
   Interface |CSSRule|
   
   A |CSSRule| represents a rule set or at-rule (i.e. a |statement|
   in CSS source document).
*/
cx.fam.suika.y2005.CSS.Node.Rule = function () {
  cx.fam.suika.y2005.CSS.Node.Rule._superclass.apply (this, arguments);
};
cx.fam.suika.y2005.CSS.Node.Rule.inherits (cx.fam.suika.y2005.CSS.Node.Node);

/**
   Appends a |CSSRule| to the list.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.appendCSSRule = function (newRule) {
  /* There should be |HIERARCHY_REQUEST_ERR|. */
  newRule._SetParentStyleSheet (this.parentStyleSheet);
  newRule._SetParentRule (this);
  return this.cssRules.v.push (newRule);
};

/**
   The textual representation of the rule.
   [DOM Level 2 CSS]
   
   Note that namespace fix up is not done.
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.getCSSText =
function () {
  return "@" + this._EscapeIdent (this.getRuleName ()) + ";\n";
};
/* Not implemented: |setCSSText| from DOM Level 2 CSS */

/*
  The rule that contains this rule, if any, or |null| otherwise.
  [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.getParentRule = function () {
  return this.parentRule;
};
cx.fam.suika.y2005.CSS.Node.Rule.prototype._SetParentRule = function (newValue) {
  this.parentRule = newValue;
};

/*
  The style sheet that contains the rule.
  [DOM Level 2 CSS]
  
  It might be |null| if the rule is not part of any style sheet
  in this implementation.
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.getParentStyleSheet = function () {
  return this.parentStyleSheet;
};
cx.fam.suika.y2005.CSS.Node.Rule.prototype._SetParentStyleSheet = function (newValue) {
  this.parentStyleSheet = newValue;
  if (this.cssRules) {
    for (var i = 0; i < this.cssRules.v.length; i++) {
      this.cssRules.v[i]._SetParentStyleSheet (mewValue);
    }
  }
};

/**
   The local name of the rule.  If the rule is not an at-rule, |null|.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.getRuleLocalName = function () {
  return this.ruleLocalName;
};

/**
   The qualified name of the rule.  If the rule is not an at-rule, |null|.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.getRuleName = function () {
  if (this.ruleNamespaceURI == "urn:x-suika-fam-cx:css:") {
    return this.ruleLocalName;
  } else {
    return "-" + this.rulePrefix + "-" + this.ruleLocalName;
  }
};

/**
   The namespace URI of the rule.  If the rule is not an at-rule, |null|.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.getRuleNamespaceURI = function () {
  return this.ruleNamespaceURI;
};

/**
   The namespace prefix of the rule.  If the rule is not an at-rule
   or the rule has no namespace prefix, |null|.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.getRulePrefix = function () {
  return this.rulePrefix;
};
cx.fam.suika.y2005.CSS.Node.Rule.prototype.setRulePrefix = function (newValue) {
  this.rulePrefix = newValue;
};

/**
  The type of the rule.
  [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.getType = function () {
  return this.UNKNOWN_RULE;
};
cx.fam.suika.y2005.CSS.Node.Rule.prototype.UNKNOWN_RULE   = 0;
cx.fam.suika.y2005.CSS.Node.Rule.prototype.STYLE_RULE     = 1;
cx.fam.suika.y2005.CSS.Node.Rule.prototype.CHARSET_RULE   = 2;
cx.fam.suika.y2005.CSS.Node.Rule.prototype.IMPORT_RULE    = 3;
cx.fam.suika.y2005.CSS.Node.Rule.prototype.MEDIA_RULE     = 4;
cx.fam.suika.y2005.CSS.Node.Rule.prototype.FONT_FACE_RULE = 5;
cx.fam.suika.y2005.CSS.Node.Rule.prototype.PAGE_RULE      = 6;

/**
   |@namespace| rule.
   [non-standard]
   
     Note.  The |type| value of |@namespace| rules is |0|,
            i.e. |UNKNOWN_RULE|, in Gecko.
*/
cx.fam.suika.y2005.CSS.Node.Rule.prototype.NAMESPACE_RULE = 1001;

/**
   Interface |CSSAtRule|
*/
cx.fam.suika.y2005.CSS.Node.AtRule = function (namespaceURI, localName) {
  cx.fam.suika.y2005.CSS.Node.AtRule._superclass.apply (this, []);
  this.ruleNamespaceURI = namespaceURI;
  this.ruleLocalName = localName.toLowerCase ();
};
cx.fam.suika.y2005.CSS.Node.AtRule.inherits (cx.fam.suika.y2005.CSS.Node.Rule);

cx.fam.suika.y2005.CSS.Node.AtRule.prototype.toString = function () {
  return "[object CSSAtRule]";
};

/**
   Interface |CSSMediaRule|
*/
cx.fam.suika.y2005.CSS.Node.MediaRule = function (mq) {
  cx.fam.suika.y2005.CSS.Node.MediaRule._superclass.apply
    (this, ["urn:x-suika-fam-cx:css:", "media"]);
  this.cssRules = new cx.fam.suika.y2005.CSS.RuleList ();
  if (mq != null) {
    this.media = mq;
  } else {
    /* TODO: set empty media query */
  }
};
cx.fam.suika.y2005.CSS.Node.MediaRule.inherits (cx.fam.suika.y2005.CSS.Node.AtRule);
cx.fam.suika.y2005.CSS.Node.MediaRule.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_AT_MEDIA_NODE;
};
cx.fam.suika.y2005.CSS.Node.MediaRule.prototype.getType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.MEDIA_RULE;
};

/**
   The list of rules within the |@media| block.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.MediaRule.prototype.getCSSRules = function () {
  return this.cssRules;
};


/**
   The textual representation of the rule.
   [DOM Level 2 CSS]
   
   Note that namespace fix up is not done.
*/
cx.fam.suika.y2005.CSS.Node.MediaRule.prototype.getCSSText =
function () {
  var r = "@media";
  var mq = this.media.getMediaText ();
  if (mq.length > 0) {
    r += " " + mq;
  }
  r += " {\n\n";
  for (var i = 0; i < this.cssRules.v.length; i++) {
    r += this.cssRules.v[i].getCSSText () + "\n";
  }
  r += "}\n";
  return r;
};
/* Not implemented: |setCSSText| */

/**
   The media query.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.MediaRule.prototype.getMedia = function () {
  return this.media;
};

/* Not implemented: |insertRule|, |deleteRule| from DOM Level 2 CSS */

cx.fam.suika.y2005.CSS.Node.MediaRule.prototype.toString = function () {
  return "[object CSSMediaRule]";
};


/**
   Interface |CSSFontFaceRule|
*/
cx.fam.suika.y2005.CSS.Node.FontFaceRule = function () {
  cx.fam.suika.y2005.CSS.Node.FontFaceRule._superclass.apply
    (this, ["urn:x-suika-fam-cx:css:", "font-face"]);
  this.style = new cx.fam.suika.y2005.CSS.Property.MultiValueSet ();
};
cx.fam.suika.y2005.CSS.Node.FontFaceRule.inherits (cx.fam.suika.y2005.CSS.Node.AtRule);
cx.fam.suika.y2005.CSS.Node.FontFaceRule.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_AT_FONT_FACE_NODE;
};
cx.fam.suika.y2005.CSS.Node.FontFaceRule.prototype.getType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.FONT_FACE_RULE;
};

/**
   The textual representation of the rule.
   [DOM Level 2 CSS]
   
   Note that namespace fix up is not done.
*/
cx.fam.suika.y2005.CSS.Node.FontFaceRule.prototype.getCSSText =
function () {
  return "@font-face {\n\n"
       + this.style.getCSSText ()
       + "\n}\n";
};
/* Not implemented: |setCSSText| */

/**
   The declaration block of the |@font-face| rule.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.FontFaceRule.prototype.getStyle = function () {
  return this.style;
};

cx.fam.suika.y2005.CSS.Node.FontFaceRule.prototype.toString = function () {
  return "[object CSSFontFaceRule]";
};



/**
   Interface |CSSPageRule|
*/
cx.fam.suika.y2005.CSS.Node.PageRule = function () {
  cx.fam.suika.y2005.CSS.Node.PageRule._superclass.apply
    (this, ["urn:x-suika-fam-cx:css:", "page"]);
};
cx.fam.suika.y2005.CSS.Node.PageRule.inherits (cx.fam.suika.y2005.CSS.Node.AtRule);
cx.fam.suika.y2005.CSS.Node.PageRule.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_AT_PAGE_NODE;
};
cx.fam.suika.y2005.CSS.Node.PageRule.prototype.getType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.PAGE_RULE;
};

/**
   The textual representation of the rule.
   [DOM Level 2 CSS]
   
   Note that namespace fixup is not done.
*/
cx.fam.suika.y2005.CSS.Node.PageRule.prototype.getCSSText =
function () {
  var r = "@page";
  var sel = this.getSelectorText ();
  if (sel.length > 0) {
    r += " " + sel;
  }
  r += " {\n\n"
     + this.style.getCSSText ()
     + "\n}\n";
  return r;
};
/* Not implemented: |setCSSText| */

/**
   The selector object of the |@page| rule.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.PageRule.prototype.getSelectorObject = function () {
  return this.selector;
};
cx.fam.suika.y2005.CSS.Node.PageRule.prototype.setSelectorObject =
function (newValue) {
  this.selector = newValue;
};

/**
   The textual representation of selector of the |@page| rule.
   [DOM Level 2 CSS]
   
   Note that namespace fixup is not done.
*/
cx.fam.suika.y2005.CSS.Node.PageRule.prototype.getSelectorText = function () {
  return this.selector.getCSSText ();
};
/* Not implemented: |setSelectorText| from DOM Level 2 CSS */

/**
   The declaration block of the |@page| rule.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.PageRule.prototype.getStyle = function () {
  return this.style;
};

cx.fam.suika.y2005.CSS.Node.PageRule.prototype.toString = function () {
  return "[object CSSPageRule]";
};


/**
   Interface |CSSImportRule|
*/
cx.fam.suika.y2005.CSS.Node.ImportRule = function (hrefArg, mediaArg) {
  cx.fam.suika.y2005.CSS.Node.ImportRule._superclass.apply
    (this, ["urn:x-suika-fam-cx:css:", "import"]);
  this.href = hrefArg;
  if (mediaArg) {
    this.media = mediaArg;
  } else {
    /* TODO: set empty media query */
  }
};
cx.fam.suika.y2005.CSS.Node.ImportRule.inherits (cx.fam.suika.y2005.CSS.Node.AtRule);
cx.fam.suika.y2005.CSS.Node.ImportRule.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_AT_IMPORT_NODE;
};
cx.fam.suika.y2005.CSS.Node.ImportRule.prototype.getType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.IMPORT_RULE;
};

/**
   The textual representation of the rule.
   [DOM Level 2 CSS]
   
   Note that namespace fix up is not done.
*/
cx.fam.suika.y2005.CSS.Node.ImportRule.prototype.getCSSText =
function () {
  var r = '@import "';
        + this.href.replace (/([\u000A\u000C"\\]|\u000D\u000A?)/g,
                             function (c) { return "\\" + c })
        + '"';
  var mq = this.media.getMediaText ();
  if (mq.length > 0) {
    r += " " + mq;
  }
  r += ";\n";
  return r;
};
/* Not implemented: |setCSSText| */

/**
   The DOM URI of the style sheet to be imported.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.ImportRule.prototype.getHref = function () {
  return this.href;
};

/**
   The media query of the rule.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.ImportRule.prototype.getMedia = function () {
  return this.media;
};

/**
   The style sheet referred to by the rule, if it has been loaded,
   or |null| otherwise.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.ImportRule.prototype.getStyleSheet = function () {
  return this.styleSheet;
};
cx.fam.suika.y2005.CSS.Node.ImportRule.prototype._SetStyleSheet = function (newValue) {
  this.styleSheet = newValue;
};

cx.fam.suika.y2005.CSS.Node.ImportRule.prototype.toString = function () {
  return "[object CSSImportRule]";
};


/**
   Interface |CSSCharsetRule|
*/
cx.fam.suika.y2005.CSS.Node.CharsetRule = function (encodingArg) {
  cx.fam.suika.y2005.CSS.Node.CharsetRule._superclass.apply
    (this, ["urn:x-suika-fam-cx:css:", "charset"]);
  this.encoding = encodingArg;
};
cx.fam.suika.y2005.CSS.Node.CharsetRule.inherits (cx.fam.suika.y2005.CSS.Node.AtRule);
cx.fam.suika.y2005.CSS.Node.CharsetRule.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_AT_CHARSET_NODE;
};
cx.fam.suika.y2005.CSS.Node.CharsetRule.prototype.getType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CHARSET_RULE;
};

/**
   The textual representation of the rule.
   [DOM Level 2 CSS]
   
   Note that namespace fix up is not done.
*/
cx.fam.suika.y2005.CSS.Node.CharsetRule.prototype.getCSSText =
function () {
  return '@charset "'
       + this.encoding.replace (/([\u000A\u000C"\\]|\u000D\u000A?)/g,
                                function (c) { return "\\" + c })
       + '";\n';
};
/* Not implemented: |setCSSText| */

/**
   The charset name.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.CharsetRule.prototype.getEncoding = function () {
  return this.encoding;
};

cx.fam.suika.y2005.CSS.Node.CharsetRule.prototype.toString = function () {
  return "[object CSSCharsetRule]";
};


/**
   Interface |CSSNameSpaceRule|
*/
cx.fam.suika.y2005.CSS.Node.NamespaceRule = function (prefixArg, namespaceURIArg) {
  cx.fam.suika.y2005.CSS.Node.NamespaceRule._superclass.apply
    (this, ["urn:x-suika-fam-cx:css:", "namespace"]);
  this.prefix = prefixArg;
  this.namespaceURI = namespaceURIArg;
};
cx.fam.suika.y2005.CSS.Node.NamespaceRule.inherits
  (cx.fam.suika.y2005.CSS.Node.AtRule);
cx.fam.suika.y2005.CSS.Node.NamespaceRule.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_AT_NAMESPACE_NODE;
};
cx.fam.suika.y2005.CSS.Node.NamespaceRule.prototype.getType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.NAMESPACE_RULE;
};

/**
   The textual representation of the rule.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.NamespaceRule.prototype.getCSSText =
function () {
  var r = "@namespace";
  if (this.prefix != null) r += " " + this._EscapeIdent (this.prefix);
  r += ' "'
     + this.namespaceURI.replace (/([\u000A\u000C"\\]|\u000D\u000A?)/g,
                                  function (c) { return "\\" + c })
     + '";\n';
  return r;
};
/* Not implemented: |setCSSText| */

/**
   The namespace URI.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.NamespaceRule.prototype.getNamespaceURI = function () {
  return this.namespaceURI;
};
/* Is setter necessary? */

/**
   The namespace prefix.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.NamespaceRule.prototype.getPrefix = function () {
  return this.prefix;
};
/* Is setter necessary? */

cx.fam.suika.y2005.CSS.Node.NamespaceRule.prototype.toString = function () {
  return "[object CSSNameSpaceRule]";
};


/**
   Interface |CSSUnknownRule|
*/
cx.fam.suika.y2005.CSS.Node.UnknownRule = function (namespaceURI, localName) {
  cx.fam.suika.y2005.CSS.Node.UnknownRule._superclass.apply
    (this, [namespaceURI, localName]);
};
cx.fam.suika.y2005.CSS.Node.UnknownRule.inherits (cx.fam.suika.y2005.CSS.Node.AtRule);

cx.fam.suika.y2005.CSS.Node.UnknownRule.prototype.toString = function () {
  return "[object CSSUnknownRule]";
};
cx.fam.suika.y2005.CSS.Node.UnknownRule.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_UNKNOWN_RULE_NODE;
};
cx.fam.suika.y2005.CSS.Node.UnknownRule.prototype.getType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.UNKNOWN_RULE;
};


/**
   Interface |CSSStyleRule|
   
   A |CSSStyleRule| object represents a rule set in a CSS style sheet.
*/
cx.fam.suika.y2005.CSS.Node.RuleSet = function (sel) {
  cx.fam.suika.y2005.CSS.Node.RuleSet._superclass.apply (this, []);
  this.selector = sel;
  this.style = new cx.fam.suika.y2005.CSS.Property.MultiValueSet ();
  this.style.parentRule = this;
};
cx.fam.suika.y2005.CSS.Node.RuleSet.inherits (cx.fam.suika.y2005.CSS.Node.Rule);
cx.fam.suika.y2005.CSS.Node.RuleSet.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_RULE_SET_NODE;
};
cx.fam.suika.y2005.CSS.Node.RuleSet.prototype.getType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.STYLE_RULE;
};

/**
   The textual representation of the rule set.
   [DOM Level 2 CSS]
   
   Note that namespace fix up is not done.
*/
cx.fam.suika.y2005.CSS.Node.RuleSet.prototype.getCSSText =
function () {
  return this.getSelectorText () + " {\n"
       + this.style.getCSSText ()
       + "}\n";
};
/* Not implemented: |setCSSText| from DOM Level 2 CSS */

/* Not implemented: |setSelectorText| from DOM Level 2 CSS */

/**
   The selector object of the rule set.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.RuleSet.prototype.getSelectorObject = function () {
  return this.selector;
};
cx.fam.suika.y2005.CSS.Node.RuleSet.prototype.setSelectorObject = function (newValue) {
  this.selector = newValue;
};

/**
   A textual representation of the selector of the rule set.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.RuleSet.prototype.getSelectorText = function () {
  return this.selector.getSelectorText ();
};

/**
   The declaration block of the rule set.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.RuleSet.prototype.getStyle = function () {
  return this.style;
};

cx.fam.suika.y2005.CSS.Node.RuleSet.prototype.toString = function () {
  return "[object CSSRuleSet]";
};


/**
   Interface |CSSBlock|
*/
cx.fam.suika.y2005.CSS.Node.Block = function () {
  cx.fam.suika.y2005.CSS.Node.Block._superclass.apply (this, arguments);
};
cx.fam.suika.y2005.CSS.Node.Block.inherits (cx.fam.suika.y2005.CSS.Node.Node);

cx.fam.suika.y2005.CSS.Node.Block.prototype.toString = function () {
  return "[object CSSBlock]";
};


/**
   Interface |CSSStyleDeclaration|
   
   A |CSSStyleDeclaration| represents a CSS declaration block.
*/
cx.fam.suika.y2005.CSS.Node.StyleDeclaration = function () {
  cx.fam.suika.y2005.CSS.Node.StyleDeclaration._superclass.apply (this, arguments);
  this.decls = [];
};
cx.fam.suika.y2005.CSS.Node.StyleDeclaration.inherits
  (cx.fam.suika.y2005.CSS.Node.Block);
cx.fam.suika.y2005.CSS.Node.StyleDeclaration.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_DECLARATION_BLOCK_NODE;
};

/**
   Appends a CSS property declaration object.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.StyleDeclaration.prototype.appendPropertyNode =
function (newProp) {
  newProp.parentRule = this;
  return this.decls.push (newProp);
};

/* Not implemented: |setCSSText|, |length|, |getPropertyCSSValue|,
                    |getPropertyPriority|, |getPropertyValue|,
                    |removeProperty|, |setProperty| from DOM Level 2 CSS */

/**
   The textual representation of the declaration block, excluding the
   surrounding curly braces.
   [DOM Level 2 CSS]
   
   Note that namespace fix up is not done.
*/
cx.fam.suika.y2005.CSS.Node.StyleDeclaration.prototype.getCSSText =
function () {
  var r = "";
  for (var i = 0; i < this.decls.length; i++) {
    r += "  " + this.decls[i].getCSSText () + ";\n";
  }
  return r;
};

/**
   The number of declarations in the declaration block.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.StyleDeclaration.prototype.getDeclarationLength =
function () {
  return this.decls.length;
};

/**
   Returns the |index|th declaration in the declaration block, if any, or |null|.
   [non-standard]
   
   @param index The index of the declaration.
   @return The declaration object or |null|.
*/
cx.fam.suika.y2005.CSS.Node.StyleDeclaration.prototype.getDeclarationNode =
function (index) {
  return this.decls[index];
};

/*
  The rule that contains this rule, if any, or |null| otherwise.
  [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.Node.StyleDeclaration.prototype.getParentRule = function () {
  return this.parentRule;
};
cx.fam.suika.y2005.CSS.Node.StyleDeclaration.prototype._SetParentRule =
function (newValue) {
  this.parentRule = newValue;
};

cx.fam.suika.y2005.CSS.Node.StyleDeclaration.prototype.toString = function () {
  return "[object CSSStyleDeclaration]";
};


/**
   Interface |CSSDeclaration|
*/
cx.fam.suika.y2005.CSS.Node.Declaration = function () {
  cx.fam.suika.y2005.CSS.Node.Declaration._superclass.apply (this, arguments);
};
cx.fam.suika.y2005.CSS.Node.Declaration.inherits (cx.fam.suika.y2005.CSS.Node.Node);
cx.fam.suika.y2005.CSS.Node.Declaration.prototype.getCSSNodeType = function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_EMPTY_DECLARATION_NODE;
};

/**
   The textual representation of the declaration.
   [non-standard]
   
   Note that namespace fix up is not done.
*/
cx.fam.suika.y2005.CSS.Node.Declaration.prototype.getCSSText =
function () {
  return "";
};

cx.fam.suika.y2005.CSS.Node.Declaration.prototype.toString = function () {
  return "[object CSSDeclaration]";
};


/**
   Interface |CSSPropertyDeclaration|
   
   A |CSSPropertyDeclaration| object represents a CSS declaration,
   i.e. a pair of property (or descriptor) name and value.
*/
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration =
function (nsURI, prefix, lname, val, pri) {
  cx.fam.suika.y2005.CSS.Node.PropertyDeclaration._superclass.apply (this, []);
  this.propertyNamespaceURI = nsURI;
  this.propertyPrefix = prefix != null ? prefix.toLowerCase () : null;
  this.propertyLocalName = lname.toLowerCase ();
  this.propertyValue = val;
  this.priority = pri;
};
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.inherits
  (cx.fam.suika.y2005.CSS.Node.Declaration);
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.getCSSNodeType =
function () {
  return cx.fam.suika.y2005.CSS.Node.Rule.prototype.CSS_PROPERTY_DECLARATION_NODE;
};

/**
   The textual representation of the declaration.
   Note that namespace fix up is not done.
   [non-standard]
*/
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.getCSSText =
function () {
  var r = this._EscapeIdent (this.getPropertyName ()) + ": "
        + this.getPropertyValue ().getCSSText ();
  if (this.priority.namespaceURI == "http://suika.fam.cx/~wakaba/archive/2005/cssc." &&
      this.priority.localName == "normal") {
    //
  } else {
    r += " !" + this.priority.getCSSText ();
  }
  return r;
};

/**
   The priority value of the property.
*/
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.getPriority =
function () {
  return this.priority;
};
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.setPriority =
function (newValue) {
  this.priority = newValue;
};

cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.getPropertyLocalName =
function () {
  return this.propertyLocalName;
};
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.getPropertyName =
function () {
  if (this.propertNamePrefix == null) {
    return this.propertyLocalName;
  } else {
    return "-" + this.propertyPrefix + "-" + this.propertyLocalName;
  }
};
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.getPropertyPrefix =
function () {
  return this.propertyPrefix;
};
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.setPropertyPrefix =
function (newValue) {
  this.propertyPrefix = newValue.toLowerCase ();
};
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.getPropertyNamespaceURI =
function () {
  return this.propertyNamespaceURI;
};
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.getPropertyValue =
function () {
  return this.propertyValue;
};
cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.setPropertyValue =
function (newValue) {
  this.propertyValue = newValue;
};

cx.fam.suika.y2005.CSS.Node.PropertyDeclaration.prototype.toString = function () {
  return "[object CSSPropertyDeclaration]";
};


/**
   Interface |StyleSheetList|
*/
cx.fam.suika.y2005.CSS.StyleSheetList = function () {
  this.v = [];
};

/**
   Appends a style sheet to the last of the list.
   [non-standard]
   
   @param styleSheet    The style sheet to add.
   @throw DOMException  |NO_MODIFICATION_ALLOWED_ERR|: If the list is read-only.
*/
cx.fam.suika.y2005.CSS.StyleSheetList.prototype.addStyleSheet = function (styleSheet) {
  this.v.push (styleSheet);
};

/**
   The |index|th style sheet in the list, if any, or |null| otherwise.
   [DOM Level 2 Style Sheet]
*/
cx.fam.suika.y2005.CSS.StyleSheetList.prototype.item = function (index) {
  return this.v[index];
};

/**
   The number of style sheets in the list.
   [DOM Level 2 Style Sheet]
*/
cx.fam.suika.y2005.CSS.StyleSheetList.prototype.getLength = function () {
  return this.v.length;
};

cx.fam.suika.y2005.CSS.StyleSheetList.prototype.toString = function () {
  return "[object StyleSheetList]";
};


/**
   Interface |CSSRuleList|
*/
cx.fam.suika.y2005.CSS.RuleList = function () {
  this.v = [];
};

/**
   Appends a CSS rule to the list.
   [non-standard]
   
     Note.  In the current implementation this method does not set
            |parentRule| and |parentStyleSheet| properties; use
            |CSSRule.appendCSSRule| or |CSSStyleSheet.appendCSSRule|
            method instead.
            This method is intended for contexts where the |CSSRuleList| is
            not part of any CSS style sheet.
   
   @param rule          The rule to add.
   @throw DOMException  |NO_MODIFICATION_ALLOWED_ERR|: If the list is read-only.
                        |HIERARCHY_REQUEST_ERR|: If the type of rule is not
                        allowed in the list.
*/
cx.fam.suika.y2005.CSS.RuleList.prototype.addCSSRule = function (rule) {
  this.v.push (rule);
};

/**
   The |index|th rule in the list, if any, or |null| otherwise.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.RuleList.prototype.item = function (index) {
  return this.v[index];
};

/**
   The number of rules in the list.
   [DOM Level 2 CSS]
*/
cx.fam.suika.y2005.CSS.RuleList.prototype.getLength = function () {
  return this.v.length;
};

cx.fam.suika.y2005.CSS.RuleList.prototype.toString = function () {
  return "[object CSSRuleList]";
};

/* Revision: $Date: 2007/12/30 05:09:05 $ */

/* ***** BEGIN LICENSE BLOCK *****
 * Copyright 2005 Wakaba <w@suika.fam.cx>.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the same terms as Perl itself.
 *
 * Alternatively, the contents of this file may be used 
 * under the following terms (the "MPL/GPL/LGPL"), 
 * in which case the provisions of the MPL/GPL/LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of the MPL/GPL/LGPL, and not to allow others to
 * use your version of this file under the terms of the Perl, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the MPL/GPL/LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the Perl or the MPL/GPL/LGPL.
 *
 * "MPL/GPL/LGPL":
 *
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <http://www.mozilla.org/MPL/>
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is BIDOM code.
 *
 * The Initial Developer of the Original Code is Wakaba.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Wakaba <w@suika.fam.cx>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
