## -*- Perl -*- -*- Coding: euc-jisx0213 -*-

=head1 NAME

Chat::Suika

=head1 DESCRIPTION

SuikaChat -- SuikaChat format.

=cut

use strict;
package Chat::Suika;
use vars qw($VERSION);
$VERSION = '1.01';

sub open($$) {
  my $class = shift;
  my $file = shift;
  
  my @CHAT;
  if (open CHAT, $file) {@CHAT = <CHAT>; close CHAT}
  
  bless {file => $file, data => \@CHAT}, $class;
}

sub reopen($) {
  my $self = shift;
  my @CHAT;
  if (CORE::open(CHAT, $self->{file})) {@CHAT = <CHAT>; close CHAT}
  $self->{data} = \@CHAT;
  $self;
}

sub say($%) {
  my $self = shift;
  my %saying = @_;
  return $self unless $saying{text};
  for ($saying{keys %saying}) {tr/\x1f\x0d\x0a//d}
  $saying{time} = time unless $saying{time};
  $saying{name} = 'foo' unless $saying{name};
  for ('namecolor', 'textcolor') {
    $saying{$_}
      = 'rgb('.int(rand(127)).','.int(rand(127)).','.int(rand(127)).')'
      if $saying{$_} eq 'random';
  }
  my $newtext;
  for (keys %saying) {$newtext .= $_."\x1f".$saying{$_}."\x1f"}
  $newtext .= "\n";
  
  if (CORE::open(CHAT, '>> '. $self->{file})) {
    print CHAT $newtext;
  close CHAT}
  $self;
}

sub reverse($) {
  my $self = shift;
  @{$self->{data}} = CORE::reverse @{$self->{data}};
  $self;
}

sub get($%) {
  my $self = shift;
  my %param = @_;
  $param{start} = 0 unless $param{start};
  $param{end} = $#{$self->{data}} unless $param{end};
  $param{end} = $param{start} if $param{end} < $param{start};
  my @ret;
  
  for (my $i = $param{start}; $i <= $param{end}; $i++) {
    my %val = split /[\x1f\x0d\x0a]/, ${$self->{data}}[$i];
    push @ret, \%val;
  }
  
  wantarray? @ret: \@ret;
}

=head1 CHANGE

2001-11-10  wakaba <wakaba@suika.fam.cx>

	* use strict.

2001-05-11  wakaba <wakaba@suika.fam.cx>

	* New File.

=cut

1;
