## -*- Perl -*- -*- Coding: euc-jisx0213 -*-

=head1 NAME

Chat::Comchat

=head1 DESCRIPTION

SuikaChat - Comchat-compatible data file
=cut

use strict;
package Chat::Comchat;
use vars qw($VERSION);
$VERSION = '1.01';
use base qw(Chat::Suika);

sub open($$) {
  my $class = shift;
  my $file = shift;
  
  my @CHAT;
  if (CORE::open CHAT, $file) {@CHAT = <CHAT>; close CHAT}
  
  bless {file => $file, data => \@CHAT}, $class;
}

sub say($%) {
  my $self = shift;
  my %saying = @_;
  return $self unless $saying{text};
  #$saying{time} = Suika::CGI::timetext() unless $saying{time};
  $saying{time} = gmtime()." GMT" unless $saying{time};
  $saying{name} = 'foo' unless $saying{name};
  for ($saying{name}, $saying{text}) {
    tr/\x0d\x0a//d;
    s/&/&amp;/g; s/"/&quot;/g; s/</&lt;/g; s/>/&gt;/g;
  }
  my $newtext = $saying{time}.'<>'.$saying{name}.'<><>'.
                $saying{text}.'<><>'.$saying{ip}."\n";
  
  CORE::open(CHAT, '>> '. $self->{file});
    #or Suika::CGI::Error::die('write', file => $self->{file});
    print CHAT $newtext;
  close CHAT;
  $self;
}

sub get($%) {
  my $self = shift;
  my %param = @_;
  $param{start} = 0 unless $param{start};
  $param{end} = $#{$self->{data}} unless $param{end};
  $param{end} = $param{start} if $param{end} < $param{start};
  my @ret;
  
  for (my $i = $param{start}; $i <= $param{end}; $i++) {
    my ($time, $name, $mail, $text, $namecolor, $ip, $textcolor)
      = split /<>|\x0d|\x0a/, $self->{data}->[$i];
    push @ret, {time => $time, name => $name, text => $text, ip => $ip,
                mail => $mail, textcolor => $textcolor, namecolor => $namecolor};
  }
  
  wantarray? @ret: \@ret;
}

=head1 CHANGE

2001-11-10  wakaba <wakaba@suika.fam.cx>

	* use strict.

2001-05-11  wakaba <wakaba@suika.fam.cx>

	* New File.

=cut

1;
