#!/usr/bin/perl
use strict;
use warnings;
use Test;
use FindBin q($Bin);
BEGIN {plan tests => 5}
use SuikaWiki::DB::Logical;
use SuikaWiki::DB::FileSystem::SuikaWikiMetaInfo09;
use SuikaWiki::DB::Util::Error;

my $dir = $Bin.'/db.tmp';
mkdir $dir or die "$0: $dir: $!" unless -d $dir;

my $db = new SuikaWiki::DB::Logical;
my $subdb = new SuikaWiki::DB::FileSystem::SuikaWikiMetaInfo09
              directory => $dir;
_set_prop_db $db
  'test' => {-db => $subdb, -db_close => sub {
               my %opt = @_;
               local $Error::Depth = $Error::Depth + 1;
               $opt{prop_info}->{-db}->close;
               delete $opt{prop_info}->{-db};
             }};

unshift @{$db->{event}->{error}}, sub {
  my ($self, $event) = @_;
  unless ({qw/fatal 1 stop 1 warn 1/}->{$event->{error}->{-def}->{level}}) {
    warn "DEBUG: ". $event->{error}->stringify;
  }
} if $^W;
unshift @{$subdb->{event}->{error}}, sub {
  my ($self, $event) = @_;
  unless ({qw/fatal 1 stop 1 warn 1/}->{$event->{error}->{-def}->{level}}) {
    warn "DEBUG: test: ". $event->{error}->stringify;
  }
} if $^W;

$db->set (test => ['Key'] => 'Value');
ok $db->get (test => ['Key']), 'Value';

ok $db->get (other => ['Key']), undef;
ok $db->get (test => ['other']), undef;

$db->set (test => ['Key', 'Subkey'] => 'SubValue');
ok $db->get (test => ['Key', 'Subkey']), 'SubValue';

$db->close;

my $file = $subdb->{directory}.$subdb->{prefix}.$subdb->__encode_base16 ('test')
          .$subdb->{suffix};
undef $subdb;
undef $db;

ok -e $file, 1, 'Database is written on disk';
unlink $file or warn "$0: $file: $!";
