#!/usr/bin/perl
use strict;
use warnings;
use Test;
use FindBin q($Bin);
BEGIN {plan tests => 6}
use SuikaWiki::DB::FileSystem::LeafFile;

my $dir = $Bin.'/db.tmp';
#mkdir $dir or die "$0: $dir: $!" unless -d $dir;

sub filename ($;$) {
  my ($key, $suffix) = (shift, shift || '.txt');
  $dir.'/'.join ('.ns/', map {s/(.)/sprintf '%02X', ord $1/ges;$_} @$key).$suffix;
}

my $db = new SuikaWiki::DB::FileSystem::LeafFile
           base_directory => $dir,
           directory_suffix => '.ns',
           file_suffix => '.txt';

unshift @{$db->{event}->{error}}, sub {
  my ($self, $event) = @_;
  unless ({qw/fatal 1 stop 1 warn 1/}->{$event->{error}->{-def}->{level}}) {
    warn "DEBUG: ". $event->{error}->stringify;
  }
} if $^W;

$db->set (test => ['Key'] => 'Value');

ok $db->get (test => ['Key']), 'Value';
ok $db->get (test => ['other']), undef;

$db->set (test => ['Key'] => 'Value2');
ok $db->get (test => ['Key']), 'Value2';

$db->set (test => ['Key', 'Sub'] => 'SubValue');
ok $db->get (test => ['Key', 'Sub']), 'SubValue';

$db->close;

undef $db;

my $file = filename (['Key']);
ok -e $file, 1, 'Value is written on disk';
unlink $file or warn "$0: $file: $!";

$file = filename (['Key', 'Sub']);
ok -e $file, 1, 'Namespaced value is written on disk';
unlink $file or warn "$0: $file: $!";

$file = filename (['Key'], '.ns');
rmdir $file or warn "$0: $file: $!";

