#!/usr/bin/perl -w 
use strict;
use Test;
use SuikaWiki::DB::FileSystem::Base;
use File::Spec;

my $db = new SuikaWiki::DB::FileSystem::Base
           base_directory => q<base>,
           root_file => q<root>,
           directory_prefix => 'dir--',
           directory_suffix => '.ns',
           file_prefix => 'file--',
           file_suffix => '.name';

my $db2 = new SuikaWiki::DB::FileSystem::Base
           base_directory => q<base>,
           root_key => [qw/ROOT/],
           directory_prefix => 'dir--',
           directory_suffix => '.ns',
           file_prefix => 'file--',
           file_suffix => '.name';

plan tests => 16;

ok $db->__keyns2dirname (keyns => "\x31\x32\x33"), 'dir--313233.ns';
ok $db->__keyname2filename (keyname => "\x31\x32\x33"), 'file--313233.name';

ok $db->__key2filepath (key => [qw/123/]),
   File::Spec->catfile (qw/base file--313233.name/);
ok $db->__key2filepath (key => [qw/123 456/]),
   File::Spec->catfile (qw/base dir--313233.ns file--343536.name/);
ok $db->__key2filepath (key => [qw/123 456 789/]),
   File::Spec->catfile (qw/base dir--313233.ns dir--343536.ns file--373839.name/);

ok $db->__key2filepath (key => []),
  File::Spec->rel2abs ('root', 'base');

ok $db2->__key2filepath (key => []),
  File::Spec->catfile (qw/base file--524F4F54.name/);

ok $db->__key2dirpath (key => []),
   File::Spec->catdir (qw/base /);
ok $db->__key2dirpath (key => [qw/123/]),
   File::Spec->catdir (qw/base dir--313233.ns/);
ok $db->__key2dirpath (key => [qw/123 456/]),
   File::Spec->catdir (qw/base dir--313233.ns dir--343536.ns/);
ok $db->__key2dirpath (key => [qw/123 456 789/]),
   File::Spec->catdir (qw/base dir--313233.ns dir--343536.ns dir--373839.ns/);

ok $db->__key2dirpath (fullkey => [qw/123/]),
   File::Spec->catdir (qw/base/);
ok $db->__key2dirpath (fullkey => [qw/123 456/]),
   File::Spec->catdir (qw/base dir--313233.ns/);
ok $db->__key2dirpath (fullkey => [qw/123 456 789/]),
   File::Spec->catdir (qw/base dir--313233.ns dir--343536.ns/);


ok $db->__dirname2keyns (dirname => 'dir--313233.ns'), "123";
ok $db->__filename2keyname (filename => 'file--313233.name'), "123";


