
=head1 NAME

SuikaWiki::Format::Definition - SuikaWiki: Format definition manager

=head1 DESCRIPTION

This module provides "format" definitions management functionality.

This module is part of SuikaWiki.

=cut

package SuikaWiki::Format::Definition;
use strict;
our $VERSION = do{my @r=(q$Revision: 1.8 $=~/\d+/g);sprintf "%d."."%02d" x $#r,@r};

sub new_handler ($;%) {
  my ($class, %opt) = @_;
  my $self = bless {%opt}, $class;
  my $pack = $self->__get_class_name (\%opt);
  report SuikaWiki::Format::Definition::error
    -type => 'CLASS_NOT_FOUND',
    type => \%opt,
    -object => $self, method => 'new_handler',
    unless $pack;
  
  $pack->new (type => \%opt);
}

sub __get_param_string ($$) {
  join '', map {
              ';'. $_ .'='. __quote ($_[1]->{$_})
            } sort {
              $a cmp $b
            } keys %{$_[1]||{}}
}
sub __quote ($) {
  my $s = shift;
  $s =~ s/([\\"])/\\$1/g;
  '"'.$s.'"';
}
sub __get_class_name ($$) {
  local $Error::Depth = $Error::Depth + 1;
  my ($self, $opt) = @_;
  my $pack;
  if ($opt->{serialized_media_type}) {
    $pack = $SuikaWiki::Format::Definition::Class{$opt->{serialized_media_type}};
    return $pack if $pack;
  }
  if ($opt->{Type}) {
    $pack = $SuikaWiki::Format::Definition::Class{'IMT:'.$opt->{Type}
                                                 .$self->__get_param_string
                                                    ($opt->{Type_param}||{})
                                                 .'##'};
    return $pack if $pack;
  }
  
  if (not ($opt->{Name}) and $opt->{magic}) {
    if ($opt->{magic} =~ m#^([\w.+-]+)(?:/([\w.+-]+))?#) {
      $opt->{Name} = $1;
      $opt->{Version} = $2;
    }
  }
  
  $pack = $SuikaWiki::Format::Definition::Class{'MAGIC:'.$opt->{Name}
                                               .'/'.$opt->{Version}.'##'}
    || $SuikaWiki::Format::Definition::Class{'MAGIC:'.$opt->{Name}.'/##'};
  return $pack if $pack;
  
  report SuikaWiki::Format::Definition::error
    -type => 'WARN_DEFAULT_CLASS',
    type => $opt,
    -object => $self, method => '___get_class_name';
  if ( ($opt->{serialized_media_type} and
        $opt->{serialized_media_type} =~ m#^IMT:text/#)
    or ($opt->{Type} and substr ($opt->{Type}, 0, 5) eq 'text/') or
    ($opt->{serialized_media_type} and
     $opt->{serialized_media_type} =~ m#^MAGIC:#)
    or $opt->{Name}) {
    $pack = $SuikaWiki::Format::Definition::Class{'IMT:text/plain##'};
  } elsif (
    ($opt->{serialized_media_type} and
     $opt->{serialized_media_type} =~ m#^IMT:multipart/#) or
    ($opt->{Type} and $opt->{Type} =~ m#^multipart/#)
  ) {
    $pack = $SuikaWiki::Format::Definition::Class{'IMT:multipart/mixed##'};
  } else {
    $pack = $SuikaWiki::Format::Definition::Class{'IMT:application/octet-stream##'};
  }
  return $pack if $pack;
  
  return undef
}

sub serialize_media_type ($%) {
  my (undef, %opt) = @_;
  my %return;
  if ($opt{Type}) {
    $return{Type} = 'IMT:'.$opt{Type};
    if ($opt{Type_param}) {
      $return{Type} .= join '', map {my $s;
                         ';'. $_ .'="'
                       . (($s = $opt{Type_param}->{$_}) =~ s/([\\"])/\\$1/g, $s)
                       . '"' 
                       } sort {
                         $a cmp $b
                       } keys %{$opt{Type_param}};
    }
  }
  if ($opt{Magic}) {
    $return{Magic} = 'MAGIC:'.$opt{Magic};
  } elsif ($opt{Name}) {
    $return{Name} = 'MAGIC:'.$opt{Name}.'/*';
    $return{Magic} = 'MAGIC:'.$opt{Name}.'/'.$opt{Version} if $opt{Version};
  }
  if ($opt{URIReference}) {
    $return{URIReference} = $opt{URIReference};
  }
  my $flag = '##';
  $flag .= 'f' if $opt{IsFragment};
  $flag .= 'p' if $opt{IsPlaceholder};
  for (qw/URIReference Type Magic Name/) {
    $return{$_} .= $flag if $return{$_};
  }
  $return{_} = $return{URIReference} || $return{Type}
            || $return{Magic} || $return{Name};
  \%return;
}

sub ___report_error ($$) {
  my ($self, $err) = @_;
  $self->{-error}->($err) if $self->{-error};
  if ($err->{-def}->{level} ne 'warn') {
    $err->throw;
  }
}

package SuikaWiki::Format::Definition::template;

sub new ($;%) {
  my $class = shift;
  bless {@_}, $class;
}

sub convert ($$;%) {
  my ($self, $source, %opt) = @_;
  report SuikaWiki::Format::Definition::error
    -type => 'CONVERTER_NOT_FOUND',
    -object => $self, method => 'converter',
    type => $self->{type},
    type_to => \%opt;
}

sub wikiform ($$;%) {
  my ($self, $source, %opt) = @_;
  report SuikaWiki::Format::Definition::error
    -type => 'WIKIFORM_NOT_FOUND',
    -object => $self, method => 'wikiform',
    type => $self->{type};
}

sub next_index_for_anchor ($$;%) {
  my ($self, $source, %opt) = @_;
  1;
#  report SuikaWiki::Format::Definition::error
#    -type => 'NEXT_INDEX_NOT_FOUND',
#    -object => $self, method => 'next_index_for_anchor',
#    type => $self->{type},
#    next_index_type => 'anchor';
}

sub headsummary ($$;%) {
  my ($self, $source, %opt) = @_;
#  report SuikaWiki::Format::Definition::error
#    -type => '',
#    -object => $self, method => 'wikiform',
#    type => $self->{type};
  undef;
}

sub content_written ($%) {

}

sub content_removed ($%) {

}

sub content_type_changed_from ($%) {
  
}

=item $format->content_prop_modified (%param)

When WikiPage content property other than media-type:media-type modified.

=cut

sub content_prop_modified ($%) {

}

=item $val = $format->prop ($uri, %option)

Get format property.

=cut

sub prop ($$;%) {
  my ($self, $name, %opt) = @_;
  return $opt{default};
}

sub ___report_error ($$) {
  my ($view, $err) = @_;
  $err->throw;
}

package SuikaWiki::Format::Definition::error;
require Message::Util::Error;
our @ISA = 'Message::Util::Error';

sub ___error_def () {+{
  CLASS_NOT_FOUND => {
    description => q(%type;: Format handler class not found),
  },
  CONVERTER_NOT_FOUND => {
    description => q(%type; => %type-to;: Converter not found),
  },
  NEXT_INDEX_NOT_FOUND => {
    description => q(%type;: Next %t (name => next_index_type); index is unknown),
  },
  WARN_DEFAULT_CLASS => {
    description => q(%type;: Default type is selected),
    level => 'warn',
  },
  WIKIFORM_NOT_FOUND => {
    description => q(%type;: WikiForm handler not defined),
  },
}}

sub _FORMATTER_PACKAGE_ () {'SuikaWiki::Formatter::Definition::error::formatter'}

package SuikaWiki::Formatter::Definition::error::formatter;
our @ISA = 'Message::Util::Error::formatter';

sub ___rule_def ($) {+{
  type => {
    after => sub {
      my ($f, $name, $p, $o) = @_;
      my $opt = $o->{type};
      if ($opt->{serialized_media_type}) {
        $p->{-result} .= '(Serialized:) '.$opt->{serialized_media_type};
      } elsif ($opt->{Type}) {
        $p->{-result} .= 'IMT:'.$opt->{Type}.SuikaWiki::Format::Definition->__get_param_string ($opt->{Type_param});
      } else {
        $p->{-result} .= 'MAGIC:'.$opt->{Name}.'/'.$opt->{Version};
      }
    },
  },
  type_to => {
    after => sub {
      my ($f, $name, $p, $o) = @_;
      my $opt = $o->{type_to};
      if ($opt->{serialized_media_type}) {
        $p->{-result} .= '(Serialized:) '.$opt->{serialized_media_type};
      } elsif ($opt->{Type}) {
        $p->{-result} .= 'IMT:'.$opt->{Type}.SuikaWiki::Format::Definition->__get_param_string ($opt->{Type_param});
      } else {
        $p->{-result} .= 'MAGIC:'.$opt->{Name}.'/'.$opt->{Version};
      }
    },
  },
}}

=head1 LICENSE

Copyright 2003-2004 Wakaba <w@suika.fam.cx>

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut

1; # $Date: 2004/07/25 06:54:29 $
